/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.utils.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class Sort {
    public static final String DESC = "DESC";
    public static final String ASC = "ASC";

    public static <T> List<T> by(List<T> list, String sortKeys) {
        final List<SortModel> sorts = Sort.parseSortModel(sortKeys);
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T obj1, T obj2) {
                int result = 0;
                for (SortModel model : sorts) {
                    try {
                        Object value1 = PropertyUtils.getProperty(obj1, (String)model.getName());
                        Object value2 = PropertyUtils.getProperty(obj2, (String)model.getName());
                        result = Sort.DESC.equalsIgnoreCase(model.getModel()) ? Compare.compareObject(value2, value1) : Compare.compareObject(value1, value2);
                        if (result != 0) break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return result;
            }
        });
        return list;
    }

    private static List<SortModel> parseSortModel(String sortKeys) {
        ArrayList<SortModel> sorts = new ArrayList<SortModel>();
        StringTokenizer tokenizers = new StringTokenizer(sortKeys, ",");
        while (tokenizers.hasMoreTokens()) {
            String token = tokenizers.nextToken();
            StringTokenizer tokenizer = new StringTokenizer(token, ":");
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken();
                String model = tokenizer.nextToken();
                sorts.add(new SortModel(name, model));
            }
        }
        return sorts;
    }

    static class SortModel {
        public String name;
        public String model;

        public SortModel() {
        }

        public SortModel(String name, String model) {
            this.name = name;
            this.model = model;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }
    }

    static class Compare {
        Compare() {
        }

        public static int compareObject(Object obj1, Object obj2) {
            if (obj1 instanceof Integer) {
                Integer num1 = Integer.valueOf(String.valueOf(obj1));
                Integer num2 = Integer.valueOf(String.valueOf(obj2));
                return num1.compareTo(num2);
            }
            if (obj1 instanceof Long) {
                Long num1 = Long.valueOf(String.valueOf(obj1));
                Long num2 = Long.valueOf(String.valueOf(obj2));
                return num1.compareTo(num2);
            }
            if (obj1 instanceof Float) {
                Float num1 = Float.valueOf(String.valueOf(obj1));
                Float num2 = Float.valueOf(String.valueOf(obj2));
                return num1.compareTo(num2);
            }
            if (obj1 instanceof Double) {
                Double num1 = Double.valueOf(String.valueOf(obj1));
                Double num2 = Double.valueOf(String.valueOf(obj2));
                return num1.compareTo(num2);
            }
            if (obj1 instanceof BigDecimal) {
                BigDecimal num1 = new BigDecimal(String.valueOf(obj1));
                BigDecimal num2 = new BigDecimal(String.valueOf(obj2));
                return num1.compareTo(num2);
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u6bd4\u8f83");
        }
    }
}

