/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.utils.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class DateUtils {
    private static Logger logger = Logger.getLogger(DateUtils.class);
    private static String pattern = "yyyy-MM-dd HH:mm:ss";

    public static String getDateTime() {
        return DateUtils.format(pattern);
    }

    public static String format(int unixTimeStamp, String pattern) {
        Date dt = new Date((long)unixTimeStamp * 1000L);
        return DateUtils.format(dt, pattern);
    }

    public static String format(int unixTimeStamp) {
        return DateUtils.format(unixTimeStamp, pattern);
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(date);
    }

    public static String format(String date, String old_pattern, String new_pattern) {
        SimpleDateFormat df = new SimpleDateFormat(old_pattern);
        try {
            Date dt = df.parse(date);
            return DateUtils.format(dt, new_pattern);
        }
        catch (ParseException e) {
            logger.info((Object)e);
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        return "";
    }

    public static Date parse(String date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(date);
        }
        catch (ParseException e) {
            logger.info((Object)e);
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        return null;
    }

    public static String format(String pattern) {
        return DateUtils.format(new Date(), pattern);
    }

    public static String getCurrentDate() {
        String pattern = "yyyyMMdd";
        return DateUtils.format(pattern);
    }

    public static String getCurrentTime() {
        String pattern = "HHmmss";
        return DateUtils.format(pattern);
    }

    public static Calendar afterYear(Calendar calendar, int diff) {
        calendar.add(1, diff);
        return calendar;
    }

    public static Calendar afterYear(int diff) {
        Calendar c = Calendar.getInstance();
        return DateUtils.afterYear(c, diff);
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static int getUnixTimeStamp() {
        return (int)(DateUtils.getCurrentTimeMillis() / 1000L);
    }

    public static int getUnixTimeStamp(Date dt) {
        Calendar cl = DateUtils.getCalendar(dt);
        return (int)cl.getTimeInMillis() / 1000;
    }

    public static int getUnixTimeStamp(String date, String pattern) {
        Date dt = DateUtils.parse(date, pattern);
        return DateUtils.getUnixTimeStamp(dt);
    }

    public static Calendar afterMonth(int diff) {
        Calendar c = Calendar.getInstance();
        return DateUtils.afterMonth(c, diff);
    }

    public static Calendar afterMonth(Calendar calendar, int diff) {
        calendar.add(2, diff);
        return calendar;
    }

    public static Date afterDay(Date dt, int diff) {
        Calendar c = DateUtils.getCalendar(dt);
        return DateUtils.getDate(DateUtils.afterDay(c, diff));
    }

    public static Calendar afterDay(int diff) {
        Calendar c = Calendar.getInstance();
        return DateUtils.afterDay(c, diff);
    }

    public static Calendar afterDay(Calendar calendar, int diff) {
        calendar.add(5, diff);
        return calendar;
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public static Calendar getCalendar(Date date) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        return cal;
    }

    public static Date getDate(Calendar calendar) {
        return calendar.getTime();
    }
}

