/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.utils.db;

import com.atomikos.icatch.jta.UserTransactionImp;
import com.atomikos.jdbc.AtomikosDataSourceBean;
import com.atomikos.jdbc.nonxa.AtomikosNonXADataSourceBean;
import com.efuture.pre.utils.common.BasicUtil;
import com.efuture.pre.utils.db.DBException;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class DBUnitManager {
    private static final String PREFIX = "jdbc:apache:commons:dbcp";
    private static Logger log = Logger.getLogger(DBUnitManager.class);
    private static Map<String, String> dbUnitKeys = new HashMap<String, String>();
    private static Map<String, Boolean> _dbUnitIsXAs = new HashMap<String, Boolean>();
    private static DBUnitManager instance;
    private static Map<String, Object> dbUnitPoolDBCP;
    private static Map<String, Object> dbUnitPoolXAXA;
    private static Map<String, Map<String, Connection>> utxConnPool;

    public static DBUnitManager getInstance() throws Exception {
        if (instance == null) {
            instance = new DBUnitManager();
        }
        return instance;
    }

    private DBUnitManager() throws Exception {
    }

    public String getSqlType(String dbUnitKey) {
        DBUnitManager.registerDbUnit(dbUnitKey);
        String sqlType = dbUnitKeys.get(dbUnitKey).toString();
        if (sqlType == null || sqlType.isEmpty()) {
            sqlType = "MYSQL";
        }
        return sqlType;
    }

    private static boolean getIsXA(String dbUnitKey) {
        DBUnitManager.registerDbUnit(dbUnitKey);
        boolean isXA = _dbUnitIsXAs.get(dbUnitKey);
        return isXA;
    }

    public String beginUserTransaction() throws Exception {
        UserTransactionImp utx = new UserTransactionImp();
        utx.setTransactionTimeout(28800000);
        utx.begin();
        return BasicUtil.getGUID();
    }

    public void endUserTransaction(String transId, boolean error) throws DBException {
        UserTransactionImp utx = new UserTransactionImp();
        try {
            utx.setTransactionTimeout(600000);
            if (utx.getStatus() != 6) {
                if (error) {
                    utx.rollback();
                } else {
                    utx.commit();
                }
            } else {
                System.out.println("WARNING: closeConnection called outside a tx");
            }
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
        finally {
            DBUnitManager.closeUtxConnPool(transId);
        }
    }

    public void commit() throws DBException {
        UserTransactionImp utx = new UserTransactionImp();
        try {
            if (utx.getStatus() != 6) {
                utx.commit();
            } else {
                System.out.println("WARNING: closeConnection called outside a tx");
            }
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
    }

    private static void addUtxConnPool(String transId, String dbUnitKey, Connection dbConn) {
        Map<String, Connection> connMap = utxConnPool.get(transId);
        if (connMap == null) {
            connMap = new HashMap<String, Connection>();
        }
        connMap.put(dbUnitKey, dbConn);
        utxConnPool.put(transId, connMap);
    }

    public static final void closeUtxConnPool(String transId) throws DBException {
        if (transId == null) {
            return;
        }
        Map<String, Connection> connMap = utxConnPool.get(transId);
        if (connMap == null) {
            utxConnPool.remove(transId);
            return;
        }
        for (Map.Entry<String, Connection> entry : connMap.entrySet()) {
            String key = entry.getKey();
            DBUnitManager.closeConnection(key, transId);
        }
        utxConnPool.remove(transId);
    }

    private static void removeUtxConnPoolConn(String transId, String dbUnitKey) {
        Map<String, Connection> connMap = utxConnPool.get(transId);
        if (connMap == null) {
            return;
        }
        connMap.remove(dbUnitKey);
    }

    private static Connection getUtxConn(String transId, String dbUnitKey) {
        Map<String, Connection> connMap = utxConnPool.get(transId);
        if (connMap == null) {
            return null;
        }
        return connMap.get(dbUnitKey);
    }

    public static final Connection getConnection(String dbUnitKey, String transId, Boolean isONE) throws DBException {
        if (dbUnitKey == null || dbUnitKey.isEmpty()) {
            throw new DBException("dbUnitKey \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (transId == null || transId.isEmpty()) {
            throw new DBException("transId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (isONE == null) {
            throw new DBException("isONE \u4e0d\u80fd\u4e3a\u7a7a");
        }
        DBUnitManager.registerDbUnit(dbUnitKey);
        boolean autoCommit = false;
        String connMsg = "";
        try {
            Connection dbConn = DBUnitManager.getUtxConn(transId, dbUnitKey);
            if (dbConn == null || dbConn.isClosed()) {
                if (isONE.booleanValue()) {
                    autoCommit = true;
                    connMsg = "jdbc:apache:commons:dbcp:" + dbUnitKey;
                    dbConn = DriverManager.getConnection(connMsg);
                } else {
                    autoCommit = false;
                    connMsg = transId + "@" + dbUnitKey;
                    if (DBUnitManager.getIsXA(dbUnitKey)) {
                        AtomikosDataSourceBean dsXA = (AtomikosDataSourceBean)dbUnitPoolXAXA.get(dbUnitKey);
                        dbConn = dsXA.getConnection(connMsg);
                    } else {
                        AtomikosNonXADataSourceBean dsNonXA = (AtomikosNonXADataSourceBean)dbUnitPoolXAXA.get(dbUnitKey);
                        dbConn = dsNonXA.getConnection(connMsg);
                    }
                }
                dbConn.setAutoCommit(autoCommit);
                DBUnitManager.addUtxConnPool(transId, dbUnitKey, dbConn);
            }
            return dbConn;
        }
        catch (Exception e) {
            throw new DBException(dbUnitKey + "\u83b7\u53d6\u8fde\u63a5\u5f02\u5e38" + e.getMessage());
        }
    }

    public static final void closeConnection(String dbUnitKey, String transId) throws DBException {
        if (dbUnitKey == null || dbUnitKey.isEmpty()) {
            throw new DBException("dbUnitKey \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (transId == null || transId.isEmpty()) {
            return;
        }
        try {
            Connection dbConn = DBUnitManager.getUtxConn(transId, dbUnitKey);
            if (dbConn != null && !dbConn.isClosed()) {
                dbConn.setAutoCommit(true);
                dbConn.close();
            }
        }
        catch (Exception e) {
            throw new DBException(e);
        }
    }

    private static void chkDbProperties(Properties properties) throws DBException {
        if (properties == null) {
            throw new DBException("\u914d\u7f6e\u53c2\u6570\u6587\u4ef6\u3010properties\u3011\u4e3a\u7a7a!");
        }
        String driverClassName = properties.getProperty("jdbc.driverClass");
        if (driverClassName == null) {
            throw new DBException("\u6570\u636e\u8d44\u6e90\u6ce8\u518c\u3010driverClassName\u3011\u5f02\u5e38!");
        }
        try {
            Class.forName(properties.getProperty("jdbc.driverClass"));
        }
        catch (Exception e) {
            throw new DBException("\u68c0\u67e5\u3010driverClassName\u3011\u5f02\u5e38\uff1a" + e.getMessage());
        }
        String dbType = properties.getProperty("jdbc.dbType");
        if (dbType == null || dbType.isEmpty()) {
            throw new DBException("\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0c\u672a\u5b9a\u4e49DbType");
        }
        String isNonXA = properties.getProperty("jdbc.isNonXA");
        if (isNonXA == null || isNonXA.isEmpty()) {
            throw new DBException("\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0c\u672a\u5b9a\u4e49isNonXA");
        }
        String registerMode = properties.getProperty("jdbc.registerMode");
        if (registerMode == null || registerMode.isEmpty()) {
            throw new DBException("\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0c\u672a\u5b9a\u4e49registerMode");
        }
        if (driverClassName.toUpperCase().indexOf(dbType) < 0) {
            throw new DBException("\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0cDbType\u548cdriverClass\u4e0d\u4e00\u81f4");
        }
    }

    private static void registerDbUnit(String dbUnitKey) throws DBException {
        String dbType = dbUnitKeys.get(dbUnitKey);
        if (dbType != null) {
            return;
        }
        Properties properties = new Properties();
        try {
            String filePath = instance.getClass().getClassLoader().getResource("").getFile();
            log.info((Object)("\u5f53\u524d\u8d44\u6e90\u8def\u5f84\uff1a" + filePath));
            File confFile = new File(filePath + "conf/" + dbUnitKey + ".properties");
            if (confFile == null) {
                throw new DBException(confFile + "\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6\u672a\u5b9a\u4e49");
            }
            properties.load(new FileInputStream(confFile));
        }
        catch (Exception e) {
            throw new DBException(e);
        }
        DBUnitManager.chkDbProperties(properties);
        String registerMode = properties.getProperty("jdbc.registerMode");
        String isNonXA = properties.getProperty("jdbc.isNonXA");
        if (registerMode.equalsIgnoreCase("XAXA")) {
            if (isNonXA.equalsIgnoreCase("TRUE")) {
                DBUnitManager.registerDbUnitNonXA(dbUnitKey, properties);
            } else {
                DBUnitManager.registerDbUnitXA(dbUnitKey, properties);
            }
        } else if (registerMode.equalsIgnoreCase("DBCP")) {
            DBUnitManager.registerDbUnitDBCP(dbUnitKey, properties);
        } else {
            DBUnitManager.registerDbUnitDBCP(dbUnitKey, properties);
            if (isNonXA.equalsIgnoreCase("TRUE")) {
                DBUnitManager.registerDbUnitNonXA(dbUnitKey, properties);
            } else {
                DBUnitManager.registerDbUnitXA(dbUnitKey, properties);
            }
        }
        dbUnitKeys.put(dbUnitKey, properties.getProperty("jdbc.dbType"));
        if (isNonXA.equalsIgnoreCase("TRUE")) {
            _dbUnitIsXAs.put(dbUnitKey, false);
        } else {
            _dbUnitIsXAs.put(dbUnitKey, true);
        }
    }

    private static void registerDbUnitDBCP(String dbUnitKey, Properties properties) throws DBException {
        try {
            String connectURI = properties.getProperty("jdbc.url");
            GenericObjectPool connectionPool = new GenericObjectPool(null, Integer.parseInt(properties.getProperty("jdbc.poolSize")), 1, Long.parseLong(properties.getProperty("jdbc.maxWait")), Integer.parseInt(properties.getProperty("jdbc.maxIdle")), Integer.parseInt(properties.getProperty("jdbc.minIdle")), Boolean.parseBoolean(properties.getProperty("jdbc.testOnBorrow")), false, Long.parseLong(properties.getProperty("jdbc.timeBetweenEvictionRunsMillis")), 3, Long.parseLong(properties.getProperty("jdbc.minEvictableIdleTimeMillis")), Boolean.parseBoolean(properties.getProperty("jdbc.testWhileIdle")));
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectURI, properties.getProperty("jdbc.username"), properties.getProperty("jdbc.password"));
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
            poolableConnectionFactory.setValidationQuery(properties.getProperty("jdbc.validationQuery"));
            Class.forName("org.apache.commons.dbcp.PoolingDriver");
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
            driver.registerPool(dbUnitKey, (ObjectPool)connectionPool);
            dbUnitPoolDBCP.put(dbUnitKey, connectionPool);
        }
        catch (Exception e) {
            throw new DBException(e);
        }
    }

    private static void registerDbUnitNonXA(String dbUnitKey, Properties properties) throws DBException {
        try {
            AtomikosNonXADataSourceBean dsNonXa = new AtomikosNonXADataSourceBean();
            dsNonXa.setUniqueResourceName(dbUnitKey);
            dsNonXa.setDriverClassName(properties.getProperty("jdbc.driverClass"));
            dsNonXa.setUrl(properties.getProperty("jdbc.url"));
            dsNonXa.setUser(properties.getProperty("jdbc.username"));
            dsNonXa.setPassword(properties.getProperty("jdbc.password"));
            dsNonXa.setTestQuery(properties.getProperty("jdbc.testQuery"));
            dsNonXa.setPoolSize(Integer.valueOf(properties.getProperty("jdbc.poolSize")).intValue());
            dsNonXa.setMaxPoolSize(Integer.valueOf(properties.getProperty("jdbc.maxIdle")).intValue());
            dsNonXa.setMinPoolSize(Integer.valueOf(properties.getProperty("jdbc.minIdle")).intValue());
            dsNonXa.setLoginTimeout(Integer.valueOf(properties.getProperty("jdbc.connTimeout")).intValue());
            dsNonXa.setReapTimeout(30000);
            dsNonXa.setBorrowConnectionTimeout(28800000);
            dbUnitPoolXAXA.put(dbUnitKey, dsNonXa);
        }
        catch (Exception e) {
            throw new DBException(e);
        }
    }

    private static void registerDbUnitXA(String dbUnitKey, Properties properties) throws DBException {
        try {
            AtomikosDataSourceBean ds = new AtomikosDataSourceBean();
            ds.setUniqueResourceName(dbUnitKey);
            ds.setXaDataSourceClassName(properties.getProperty("jdbc.driverXaClass"));
            Properties pXa = new Properties();
            pXa.setProperty("user", properties.getProperty("jdbc.username"));
            pXa.setProperty("password", properties.getProperty("jdbc.password"));
            pXa.setProperty("URL", properties.getProperty("jdbc.url"));
            pXa.setProperty("serverName", properties.getProperty("jdbc.serverName"));
            pXa.setProperty("portNumber", String.valueOf(properties.getProperty("jdbc.portNumber")));
            pXa.setProperty("databaseName", properties.getProperty("jdbc.databaseName"));
            pXa.setProperty("autoReconnect", "true");
            pXa.setProperty("autoReconnectForPools", "true");
            pXa.setProperty("failOverReadOnly", "false");
            ds.setTestQuery(properties.getProperty("jdbc.testQuery"));
            ds.setXaProperties(pXa);
            ds.setPoolSize(Integer.valueOf(properties.getProperty("jdbc.poolSize")).intValue());
            ds.setMaxPoolSize(Integer.valueOf(properties.getProperty("jdbc.maxIdle")).intValue());
            ds.setMinPoolSize(Integer.valueOf(properties.getProperty("jdbc.minIdle")).intValue());
            ds.setLoginTimeout(Integer.valueOf(properties.getProperty("jdbc.connTimeout")).intValue());
            ds.setReapTimeout(30000);
            ds.setBorrowConnectionTimeout(28800000);
            dbUnitPoolXAXA.put(dbUnitKey, ds);
        }
        catch (Exception e) {
            throw new DBException(e);
        }
    }

    public static void closDBCPConnPool(String dbUnitKey) {
        try {
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(PREFIX);
            driver.closePool(dbUnitKey);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void printDBCPConnPoolStatus(String dbUnitKey) {
        try {
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(PREFIX);
            ObjectPool connectionPool = driver.getConnectionPool(dbUnitKey);
            log.info((Object)String.format("NumActive: %s | NumIdle: %s", connectionPool.getNumActive(), connectionPool.getNumIdle()));
        }
        catch (SQLException e) {
            log.error((Object)"connection pool error:", (Throwable)e);
        }
    }

    static {
        dbUnitPoolDBCP = new HashMap<String, Object>();
        dbUnitPoolXAXA = new HashMap<String, Object>();
        utxConnPool = new HashMap<String, Map<String, Connection>>();
    }
}

