/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.utils.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NameNotFoundException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;

public class DBUnitTest {
    private static Logger log = Logger.getLogger(DBUnitTest.class);
    private String location;
    private static ConcurrentHashMap<String, DataSource> connections = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> dbNames = new ConcurrentHashMap();
    private static DBUnitTest instance;

    private DBUnitTest() throws Exception {
        this.init();
    }

    public static DBUnitTest getInstance() throws Exception {
        if (instance == null) {
            instance = new DBUnitTest();
        }
        return instance;
    }

    private void init() throws Exception {
        this.location = null == this.location || "".equals(this.location) ? this.getClass().getClassLoader().getResource("").getFile() : this.getClass().getClassLoader().getResource("").getFile() + this.location;
        File confDir = new File(this.location + "conf/db");
        File[] confs = confDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("^dbUnit_\\w*.properties$");
            }
        });
        for (int i = 0; i < confs.length; ++i) {
            log.debug((Object)("db configure file path" + (i + 1) + ":" + confs[i].getAbsolutePath()));
            Properties properties = new Properties();
            properties.load(new FileInputStream(confs[i]));
            String dbKey = properties.getProperty("jdbc.id");
            if (null == dbKey || "".equals(dbKey)) {
                dbKey = confs[i].getName().split("_")[1].split("\\.")[0];
            }
            String driverClassName = properties.getProperty("jdbc.driverClass");
            String jdbcUrl = properties.getProperty("jdbc.url");
            String username = properties.getProperty("jdbc.username");
            String password = properties.getProperty("jdbc.password");
            String initSize = properties.getProperty("jdbc.initialSize");
            int initialSize = initSize == null ? 15 : Integer.parseInt(initSize);
            String maxActiveStr = properties.getProperty("jdbc.maxActive");
            int maxActive = maxActiveStr == null ? 10 : Integer.parseInt(maxActiveStr);
            String maxIdleStr = properties.getProperty("jdbc.maxIdle");
            int maxIdle = maxIdleStr == null ? 10 : Integer.parseInt(maxIdleStr);
            String maxWaitStr = properties.getProperty("jdbc.maxWait");
            int maxWait = maxWaitStr == null ? 10 : Integer.parseInt(maxWaitStr);
            String readOnly = properties.getProperty("jdbc.readOnly");
            boolean defaultReadOnly = readOnly == null ? false : Boolean.parseBoolean(readOnly);
            String maxStatements = properties.getProperty("jdbc.maxStatements");
            int maxOpenStatements = maxStatements == null ? 15 : Integer.parseInt(maxStatements);
            BasicDataSource datasource = new BasicDataSource();
            datasource.setDriverClassName(driverClassName);
            datasource.setUsername(username);
            datasource.setPassword(password);
            datasource.setUrl(jdbcUrl);
            datasource.setInitialSize(initialSize);
            datasource.setMaxActive(maxActive);
            datasource.setMaxIdle(maxIdle);
            datasource.setMaxWait((long)maxWait);
            datasource.setDefaultReadOnly(defaultReadOnly);
            datasource.setMaxOpenPreparedStatements(maxOpenStatements);
            connections.put(dbKey, (DataSource)datasource);
        }
    }

    protected Connection getConnection(String dbKey) throws SQLException, NameNotFoundException {
        Connection conn = null;
        if (!connections.containsKey(dbKey)) {
            throw new NameNotFoundException("'" + dbKey + "' datasource not found");
        }
        conn = connections.get(dbKey).getConnection();
        return conn;
    }
}

