/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.utils.db;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.efuture.pre.utils.common.BasicUtil;
import com.efuture.pre.utils.common.ParamUtil;
import com.efuture.pre.utils.db.DBException;
import com.efuture.pre.utils.db.DBUnitManager;
import com.efuture.pre.utils.exceptions.ParamException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlRunner {
    private static final Log log = LogFactory.getLog(SqlRunner.class);
    private static final QueryRunner _g_runner = new QueryRunner();
    private static final ColumnListHandler _g_columnListHandler = new ColumnListHandler(){

        protected Object handleRow(ResultSet rs) throws SQLException {
            Object obj = super.handleRow(rs);
            if (obj instanceof BigInteger) {
                return ((BigInteger)obj).longValue();
            }
            return obj;
        }
    };
    private static final ScalarHandler _g_scaleHandler = new ScalarHandler(){

        public Object handle(ResultSet rs) throws SQLException {
            Object obj = super.handle(rs);
            if (obj instanceof BigInteger) {
                return ((BigInteger)obj).longValue();
            }
            return obj;
        }
    };
    private static final List<Class<?>> PrimitiveClasses = new ArrayList<Class<?>>(){
        {
            this.add(Long.class);
            this.add(Integer.class);
            this.add(String.class);
            this.add(java.util.Date.class);
            this.add(Date.class);
            this.add(Timestamp.class);
        }
    };

    private static final boolean _IsPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || PrimitiveClasses.contains(clazz);
    }

    public static Connection getConnection(String dbUnitKey, String transId, Boolean isONE) throws DBException {
        try {
            DBUnitManager dbPoolConn = DBUnitManager.getInstance();
            return DBUnitManager.getConnection(dbUnitKey, transId, isONE);
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage());
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
    }

    public static void closeConnection(String dbUnitKey, String transId, Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.setAutoCommit(true);
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
        SqlRunner.closeUtxConnPool(transId);
    }

    public static void closeUtxConnPool(String transId) {
        try {
            DBUnitManager dbPoolConn = DBUnitManager.getInstance();
            DBUnitManager.closeUtxConnPool(transId);
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage());
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
    }

    public static String getSqlType(String dbUnitKey) {
        try {
            DBUnitManager dbPoolConn = DBUnitManager.getInstance();
            return dbPoolConn.getSqlType(dbUnitKey);
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
    }

    public static String getInsertKey(String dbUnitKey) {
        String sqlType = SqlRunner.getSqlType(dbUnitKey);
        if (sqlType.equalsIgnoreCase("PHOENIX")) {
            return "UPSERT INTO ";
        }
        return "INSERT INTO ";
    }

    public static List<Map<String, Object>> query(String dbUnitKey, String sql, List<Map<String, Object>> paramMapList, Integer inResCtl) {
        String transId = BasicUtil.getGUID();
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, true);
            List<Object> paraList = new ArrayList();
            StringBuffer strbSQL = new StringBuffer(sql);
            paraList = ParamUtil.auditSqlParam(strbSQL, paramMapList, inResCtl);
            System.out.println(strbSQL.toString());
            Object[] objParam = paraList.toArray();
            if (objParam.length == 0) {
                List list = (List)_g_runner.query(conn, strbSQL.toString(), (ResultSetHandler)new MapListHandler());
                return list;
            }
            List list = (List)_g_runner.query(conn, strbSQL.toString(), (ResultSetHandler)new MapListHandler(), objParam);
            return list;
        }
        catch (ParamException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DBException(e);
        }
        finally {
            SqlRunner.closeConnection(dbUnitKey, transId, conn);
        }
    }

    public static List<Map<String, Object>> query(String dbUnitKey, String sql, List<Map<String, Object>> paramMapList) {
        try {
            return SqlRunner.query(dbUnitKey, sql, paramMapList, 0);
        }
        catch (DBException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
    }

    public static <T> List<T> query(String dbUnitKey, Class<T> beanClass, String sql, List<Map<String, Object>> paramMapList, Integer inResCtl) {
        String transId = BasicUtil.getGUID();
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, true);
            List<Object> paraList = new ArrayList();
            StringBuffer strbSQL = new StringBuffer(sql);
            paraList = ParamUtil.auditSqlParam(strbSQL, paramMapList, inResCtl);
            Object[] objParam = paraList.toArray();
            if (objParam.length == 0) {
                List list = (List)_g_runner.query(conn, strbSQL.toString(), (ResultSetHandler)(SqlRunner._IsPrimitive(beanClass) ? _g_columnListHandler : new BeanListHandler(beanClass)));
                return list;
            }
            List list = (List)_g_runner.query(conn, strbSQL.toString(), (ResultSetHandler)(SqlRunner._IsPrimitive(beanClass) ? _g_columnListHandler : new BeanListHandler(beanClass)), objParam);
            return list;
        }
        catch (ParamException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
        catch (SQLException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
        finally {
            SqlRunner.closeConnection(dbUnitKey, transId, conn);
        }
    }

    public static <T> List<T> query(String dbUnitKey, Class<T> beanClass, String sql, List<Map<String, Object>> paramMapList) {
        try {
            return SqlRunner.query(dbUnitKey, beanClass, sql, paramMapList, 0);
        }
        catch (DBException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
    }

    public static <T> List<T> query(String dbUnitKey, Class<T> beanClass, String sql, Object ... params) {
        String transId = BasicUtil.getGUID();
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, true);
            List list = (List)_g_runner.query(conn, sql, (ResultSetHandler)(SqlRunner._IsPrimitive(beanClass) ? _g_columnListHandler : new BeanListHandler(beanClass)), params);
            return list;
        }
        catch (SQLException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
        finally {
            SqlRunner.closeConnection(dbUnitKey, transId, conn);
        }
    }

    public static <T> List<T> query(String dbUnitKey, Class<T> beanClass, String sql, Object param) {
        String transId = BasicUtil.getGUID();
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, true);
            List list = (List)_g_runner.query(conn, sql, (ResultSetHandler)(SqlRunner._IsPrimitive(beanClass) ? _g_columnListHandler : new BeanListHandler(beanClass)), new Object[]{param});
            return list;
        }
        catch (SQLException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
        finally {
            SqlRunner.closeConnection(dbUnitKey, transId, conn);
        }
    }

    public static <T> List<T> query(String dbUnitKey, Class<T> beanClass, String sql) {
        String transId = BasicUtil.getGUID();
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, true);
            List list = (List)_g_runner.query(conn, sql, (ResultSetHandler)(SqlRunner._IsPrimitive(beanClass) ? _g_columnListHandler : new BeanListHandler(beanClass)));
            return list;
        }
        catch (SQLException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
        finally {
            SqlRunner.closeConnection(dbUnitKey, transId, conn);
        }
    }

    public static List<Map<String, Object>> query(String dbUnitKey, String sql) {
        String transId = BasicUtil.getGUID();
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, true);
            List list = (List)_g_runner.query(conn, sql, (ResultSetHandler)new MapListHandler());
            return list;
        }
        catch (SQLException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
        finally {
            SqlRunner.closeConnection(dbUnitKey, transId, conn);
        }
    }

    public static List<Map<String, Object>> query(String dbUnitKey, String sql, Object ... params) {
        String transId = BasicUtil.getGUID();
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, true);
            List list = (List)_g_runner.query(conn, sql, (ResultSetHandler)new MapListHandler(), params);
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
        finally {
            SqlRunner.closeConnection(dbUnitKey, transId, conn);
        }
    }

    public static int update(String transId, String dbUnitKey, String sql, Object ... params) {
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, false);
            int n = _g_runner.update(conn, sql, params);
            return n;
        }
        catch (SQLException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
    }

    public static int update(String transId, String dbUnitKey, String sql) {
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, false);
            int n = _g_runner.update(conn, sql);
            return n;
        }
        catch (SQLException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
    }

    public static int update(String dbUnitKey, String sql, Object ... params) {
        String transId = BasicUtil.getGUID();
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, true);
            int n = _g_runner.update(conn, sql, params);
            return n;
        }
        catch (SQLException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
        finally {
            SqlRunner.closeConnection(dbUnitKey, transId, conn);
        }
    }

    public static int update(String dbUnitKey, String sql, Object param) {
        String transId = BasicUtil.getGUID();
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, true);
            int n = _g_runner.update(conn, sql, param);
            return n;
        }
        catch (SQLException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
        finally {
            SqlRunner.closeConnection(dbUnitKey, transId, conn);
        }
    }

    public static int update(String dbUnitKey, String sql) {
        String transId = BasicUtil.getGUID();
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, true);
            int n = _g_runner.update(conn, sql);
            return n;
        }
        catch (SQLException e) {
            throw new DBException("dbUnitKey=" + dbUnitKey + e.getMessage());
        }
        finally {
            SqlRunner.closeConnection(dbUnitKey, transId, conn);
        }
    }

    public static int[] batch(String dbUnitKey, String sql, Object[][] params) {
        String transId = BasicUtil.getGUID();
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, true);
            int[] nArray = _g_runner.batch(conn, sql, params);
            return nArray;
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
        finally {
            SqlRunner.closeConnection(dbUnitKey, transId, conn);
        }
    }

    public static int[] batch(String transId, String dbUnitKey, String sql, Object[][] params) {
        Connection conn = null;
        try {
            conn = SqlRunner.getConnection(dbUnitKey, transId, false);
            return _g_runner.batch(conn, sql, params);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public static UserTransactionManager getUserTransactionManager() throws DBException {
        try {
            return new UserTransactionManager();
        }
        catch (Exception ex) {
            throw new DBException("\u4e8b\u52a1\u7ba1\u7406\u5b9e\u4f8b\u5316\u9519\u8bef" + ex.getMessage());
        }
    }

    public static String beginTransaction() throws DBException {
        try {
            DBUnitManager dbManager = DBUnitManager.getInstance();
            return dbManager.beginUserTransaction();
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage());
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
    }

    public static void endTransaction(Boolean error) throws DBException {
        SqlRunner.endTransaction(null, error);
    }

    public static void endTransaction(String transactionId, Boolean error) throws DBException {
        try {
            DBUnitManager utx = DBUnitManager.getInstance();
            utx.endUserTransaction(transactionId, error);
        }
        catch (Exception ex) {
            throw new DBException(ex);
        }
    }
}

