/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.utils.db;

import com.efuture.pre.utils.db.DBUnitTest;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.log4j.Logger;

public class UnitSqlHandler {
    private static Logger log = Logger.getLogger(UnitSqlHandler.class);
    private static ThreadLocal<DBUnitTest> localThread = new ThreadLocal();

    public UnitSqlHandler() {
        try {
            localThread.set(DBUnitTest.getInstance());
        }
        catch (Exception e) {
            log.error((Object)("Database initialization failed " + e.getMessage()));
        }
    }

    public static Connection getConnection(String dbKey) throws Exception {
        if (null == localThread.get()) {
            localThread.set(DBUnitTest.getInstance());
        }
        return localThread.get().getConnection(dbKey);
    }

    public static List<Map<String, Object>> query(String dbKey, String sql) throws Exception {
        QueryRunner query = new QueryRunner();
        List result = (List)query.query(UnitSqlHandler.getConnection(dbKey), sql, (ResultSetHandler)new MapListHandler());
        return result;
    }

    public static List<Map<String, Object>> query(String dbKey, String sql, Object[] params) throws Exception {
        QueryRunner query = new QueryRunner();
        List result = (List)query.query(UnitSqlHandler.getConnection(dbKey), sql, (ResultSetHandler)new MapListHandler(), params);
        return result;
    }

    public static <T> T query(String dbKey, Class<T> beanClass, String sql, Object[] params) throws Exception {
        QueryRunner query = new QueryRunner();
        return (T)query.query(UnitSqlHandler.getConnection(dbKey), sql, (ResultSetHandler)new BeanHandler(beanClass), params);
    }
}

