/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.utils.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FileUtils {
    private static Logger logger = Logger.getLogger(FileUtils.class);

    public boolean makeDirs(String path) {
        File file = new File(path);
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    public boolean createFile(String fileName) {
        boolean rtn = false;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    this.makeDirs(fileName);
                }
                rtn = file.createNewFile();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return rtn;
    }

    public boolean createNewFile(String fileName) {
        boolean rtn = false;
        try {
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            rtn = this.createFile(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            rtn = false;
        }
        return rtn;
    }

    public boolean delete(String filePath) {
        File file = new File(filePath);
        boolean rtn = false;
        if (file.exists()) {
            rtn = file.delete();
        }
        file = null;
        return rtn;
    }

    public boolean exists(String filePath) {
        File file = new File(filePath);
        boolean rtn = false;
        if (file.exists()) {
            rtn = true;
        }
        file = null;
        return rtn;
    }

    public String getName(String filePath) {
        File file = new File(filePath);
        String name = file.getName();
        file = null;
        return name;
    }

    public String getExt(String file) {
        String name = this.getName(file);
        if (null == name || name.isEmpty()) {
            return "";
        }
        int pos = name.lastIndexOf(".");
        return -1 == pos ? "" : name.substring(pos + 1);
    }

    public File createTempFile(String dir, String prefix, String suffix) {
        File parent = new File(dir);
        if (!parent.exists()) {
            this.makeDirs(dir);
        }
        File out = null;
        try {
            out = File.createTempFile(prefix, suffix, parent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    public BufferedWriter getBufferedWriter(File file, boolean append) {
        BufferedWriter out = null;
        try {
            FileWriter fstream = new FileWriter(file, append);
            out = new BufferedWriter(fstream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    public BufferedWriter getBufferedWriter(File file) {
        return this.getBufferedWriter(file, true);
    }

    public BufferedWriter getBufferedWriter(String file, boolean append) {
        BufferedWriter out = null;
        try {
            FileWriter fstream = new FileWriter(file, append);
            out = new BufferedWriter(fstream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    public BufferedWriter getBufferedWriter(String file) {
        return this.getBufferedWriter(file, true);
    }
}

