/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pre.utils.http;

import com.efuture.pre.utils.string.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;

public class HttpUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final int CONNECTTIMEOUT = 300000;
    private static final int READTIMEOUT = 300000;

    private static HttpURLConnection getConnection(URL url, String method, String contentType) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx = null;
            try {
                ctx = SSLContext.getInstance("SSL");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
                HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
                connHttps.setSSLSocketFactory(ctx.getSocketFactory());
                connHttps.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
                conn = connHttps;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Conetnt-Type", contentType);
        conn.setRequestProperty("Connection", "Keep-Alive");
        return conn;
    }

    public static String doGet(String url, Map<String, Object> params) throws IOException {
        return HttpUtil.doGet(url, params, DEFAULT_CHARSET);
    }

    public static String doGet(String url, Map<String, Object> params, String charset) throws IOException {
        if (StringUtil.isEmpty(url) || null == params) {
            return null;
        }
        String response = "";
        url = url + "?";
        url = url + HttpUtil.buildQueryString(params, charset);
        HttpURLConnection conn = null;
        String contentType = "application/x-www-form-urlencoded;charset=" + charset;
        conn = HttpUtil.getConnection(new URL(url), GET, contentType);
        response = HttpUtil.getResponseAsString(conn);
        return response;
    }

    public static String doPost(String url, Map<String, Object> params) throws UnsupportedEncodingException, IOException {
        return HttpUtil.doPost(url, params, DEFAULT_CHARSET, 300000, 300000);
    }

    public static String doPost(String url, Map<String, Object> params, String charset) throws UnsupportedEncodingException, IOException {
        return HttpUtil.doPost(url, params, charset, 300000, 300000);
    }

    public static String doPost(String url, Map<String, Object> params, String charset, int connectTimeout, int readTimeout) throws UnsupportedEncodingException, IOException {
        HttpURLConnection conn = null;
        String response = "";
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        conn = HttpUtil.getConnection(new URL(url), POST, ctype);
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(readTimeout);
        conn.getOutputStream().write(HttpUtil.buildQueryString(params, charset).getBytes(charset));
        response = HttpUtil.getResponseAsString(conn);
        return response;
    }

    public static String doPost(String url, String data) throws IOException {
        return HttpUtil.doPost(url, data, DEFAULT_CHARSET, 300000, 300000);
    }

    public static String doPost(String url, String data, String charset) throws IOException {
        return HttpUtil.doPost(url, data, charset, 300000, 300000);
    }

    public static String doPost(String url, String data, String charset, int connectTimeout, int readTimeout) throws IOException {
        String response = "";
        String ctype = "application/json;charset=" + charset;
        URL httpUrl = new URL(url);
        URLConnection urlConnection = httpUrl.openConnection();
        urlConnection.setConnectTimeout(connectTimeout);
        urlConnection.setReadTimeout(readTimeout);
        urlConnection.setDoOutput(true);
        urlConnection.setRequestProperty("content-type", ctype);
        OutputStreamWriter out = new OutputStreamWriter(urlConnection.getOutputStream());
        out.write(data);
        out.flush();
        out.close();
        InputStream inputStream = urlConnection.getInputStream();
        String encoding = urlConnection.getContentEncoding();
        response = IOUtils.toString((InputStream)inputStream, (String)encoding);
        return response;
    }

    private static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = HttpUtil.getResponseCharset(conn.getContentType());
        InputStream is = conn.getErrorStream();
        if (null == is) {
            return HttpUtil.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = HttpUtil.getStreamAsString(is, charset);
        if (StringUtil.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream inputStream, String charset) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader bf = null;
        bf = new BufferedReader(new InputStreamReader(inputStream, charset));
        try {
            String str;
            while ((str = bf.readLine()) != null) {
                sb.append(str);
            }
        }
        finally {
            if (null != bf) {
                bf.close();
                bf = null;
            }
        }
        return sb.toString();
    }

    private static String getResponseCharset(String contentType) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtil.isEmpty(contentType)) {
            String[] params;
            for (String param : params = contentType.split("\\;")) {
                String[] pair;
                if (!(param = param.trim()).startsWith("charset") || (pair = param.split("\\=")).length != 2) continue;
                charset = pair[1].trim();
            }
        }
        return charset;
    }

    public static String buildQueryString(Map<String, ?> params, String charset) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            String value;
            String key;
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            if (!StringUtil.areNotEmpty(key = entry.getKey(), value = String.valueOf(entry.getValue()))) continue;
            try {
                sb.append(key).append("=").append(URLEncoder.encode(value, charset));
            }
            catch (UnsupportedEncodingException e) {}
        }
        return sb.toString();
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

