/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.component;

import com.alibaba.fastjson.JSON;
import com.efuture.common.component.BaseComponent;
import com.efuture.common.entity.ServiceSession;
import com.efuture.common.exception.ServiceException;
import java.text.MessageFormat;
import java.util.Date;
import org.springframework.util.StringUtils;

public class BaseServiceComponent
extends BaseComponent {
    public void AssertNotNullSession(ServiceSession session, String errorMsg) throws ServiceException {
        if (session == null) {
            String messageFormat = "{0},\u53d1\u751f\u5728\u65f6\u95f4:{1,date,yyyy-MM-dd HH:mm:ss},\u4f1a\u8bdd\u53c2\u6570\u4e3a\u7a7a";
            String message = MessageFormat.format(messageFormat, errorMsg, new Date());
            this.getLogger().error((Object)message);
            throw new ServiceException("50001", messageFormat, errorMsg, new Date());
        }
    }

    public void AssertNotNullParams(Object params, String errorMsg) throws ServiceException {
        if (StringUtils.isEmpty((Object)params)) {
            String messageFormat = "{0},\u53d1\u751f\u5728\u65f6\u95f4:{1,date,yyyy-MM-dd HH:mm:ss},\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a";
            String message = MessageFormat.format(messageFormat, errorMsg, new Date(), JSON.toJSONString((Object)params));
            this.getLogger().error((Object)message);
            throw new ServiceException("50003", messageFormat, errorMsg, new Date());
        }
    }

    public void AssertInformation(ServiceSession session, Object params, String warningMsg) throws ServiceException {
        if (StringUtils.isEmpty((Object)params)) {
            String messageFormat = "{0},\u53d1\u751f\u5728\u65f6\u95f4:{1,date,yyyy-MM-dd HH:mm:ss},\u4f1a\u8bdd\u53c2\u6570:[{2}] \u8bf7\u6c42\u53c2\u6570:[{3}]";
            String message = MessageFormat.format(messageFormat, warningMsg, new Date(), JSON.toJSONString((Object)session), JSON.toJSONString((Object)params));
            this.getLogger().info((Object)message);
        }
    }
}

