/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.component;

import com.alibaba.fastjson.JSON;
import com.efuture.common.component.BaseComponent;
import com.efuture.common.exception.ServiceException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpComponent
extends BaseComponent {
    protected void onProxy(HttpPost httpPost) {
    }

    protected void onAddHeader(HttpPost httpPost) {
        httpPost.addHeader("charset", "utf-8");
        httpPost.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:42.0) Gecko/20100101 Firefox/42.0");
        httpPost.setHeader("Content-type", "application/json");
    }

    protected void on(HttpPost httpPost) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public <T> T onHttpPost(String remoteURL, Map<String, Object> paramsMap, Object value, Class<T> classzz) throws ServiceException {
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        if (paramsMap != null && paramsMap.size() > 0) {
            Set<String> keySet = paramsMap.keySet();
            for (String keyname : keySet) {
                BasicNameValuePair keyPair = new BasicNameValuePair(keyname, JSON.toJSONString((Object)paramsMap.get(keyname)));
                formParams.add(keyPair);
            }
            if (formParams.size() > 0) {
                try {
                    remoteURL = remoteURL + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(formParams, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new ServiceException("60001", "\u5ba2\u6237\u7aef\u63d0\u4ea4\u7ed9\u670d\u52a1\u5668\u7684\u8bf7\u6c42\uff0c\u53c2\u6570\u8f6c\u7801\u5f02\u5e38,\u5f02\u5e38\u5185\u5bb9:{0}", e.getMessage() == null ? "" : e.getMessage());
                }
                catch (ParseException e) {
                    throw new ServiceException("60001", "\u5ba2\u6237\u7aef\u63d0\u4ea4\u7ed9\u670d\u52a1\u5668\u7684\u8bf7\u6c42\uff0c\u53c2\u6570\u89e3\u6790\u5f02\u5e38,\u5f02\u5e38\u5185\u5bb9:{0}", e.getMessage() == null ? "" : e.getMessage());
                }
                catch (IOException e) {
                    throw new ServiceException("60001", "\u5ba2\u6237\u7aef\u63d0\u4ea4\u7ed9\u670d\u52a1\u5668\u7684\u8bf7\u6c42\uff0c\u53c2\u6570\u8f6c\u6362IO\u5f02\u5e38,\u5f02\u5e38\u5185\u5bb9:{0}", e.getMessage() == null ? "" : e.getMessage());
                }
            }
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
        HttpPost httpPost = new HttpPost(remoteURL);
        this.onProxy(httpPost);
        this.onAddHeader(httpPost);
        StringEntity entity = new StringEntity(JSON.toJSONString((Object)value), "UTF-8");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            int statusCode = 200;
            if (httpResponse == null || httpResponse.getStatusLine() == null || httpResponse.getStatusLine().getStatusCode() != 200) throw new ServiceException("60004", "\u5ba2\u6237\u7aef\u63d0\u4ea4\u7ed9\u670d\u52a1\u5668\u7684\u8bf7\u6c42\u8fd4\u56de\u72b6\u6001\u5f02\u5e38,\u5f02\u5e38\u5185\u5bb9:{0}", statusCode);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                String response = null;
                Header header = entity.getContentEncoding();
                response = header != null ? EntityUtils.toString((HttpEntity)httpEntity, (String)header.getValue()) : EntityUtils.toString((HttpEntity)httpEntity);
                System.out.println("\u8bf7\u6c42\u548c\u54cd\u5e94\u6210\u529f,\u8fd4\u56de\u7ed3\u679c:" + response);
                if (classzz == null) {
                    String string = response;
                    return (T)string;
                }
                if (classzz == String.class) {
                    String string = response;
                    return (T)string;
                }
                Object object = JSON.parseObject((String)response, classzz);
                return (T)object;
            }
            throw new ServiceException("60005", "\u5ba2\u6237\u7aef\u63d0\u4ea4\u7ed9\u670d\u52a1\u5668\u7684\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u7a7a\u5f02\u5e38", new Object[0]);
        }
        catch (ClientProtocolException e) {
            throw new ServiceException("60002", "\u5ba2\u6237\u7aef\u63d0\u4ea4\u7ed9\u670d\u52a1\u5668\u7684\u8bf7\u6c42\uff0c\u4e0d\u7b26\u5408HTTP\u534f\u8bae,\u5f02\u5e38\u5185\u5bb9:{0}", e.getMessage() == null ? "" : e.getMessage());
        }
        catch (IOException e) {
            throw new ServiceException("60003", "\u5ba2\u6237\u7aef\u63d0\u4ea4\u7ed9\u670d\u52a1\u5668\u7684\u8bf7\u6c42\u7f51\u7edc\u5f02\u5e38,\u5f02\u5e38\u5185\u5bb9:{0}", e.getMessage() == null ? "" : e.getMessage());
        }
        finally {
            if (closeableHttpClient != null) {
                try {
                    closeableHttpClient.close();
                    closeableHttpClient = null;
                }
                catch (Exception exception) {}
            }
        }
    }
}

