/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.common.entity.ServiceSession;
import com.product.util.DumpMsg;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class DiscoveryRestUtils {
    private static Logger logger = LoggerFactory.getLogger(DiscoveryRestUtils.class);

    public static String onURLDecoder(String remoteURL, String chartSet) {
        String response = remoteURL;
        try {
            response = URLDecoder.decode(remoteURL, chartSet);
            System.out.println(response);
            Pattern pattern = Pattern.compile("(%7B)|(%22)|(%3A)|(%2C)|(%7D)");
            Matcher matcher = pattern.matcher(response);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                if ("%7B".equalsIgnoreCase(matcher.group())) {
                    matcher.appendReplacement(buffer, "{");
                    continue;
                }
                if ("%22".equalsIgnoreCase(matcher.group())) {
                    matcher.appendReplacement(buffer, "'");
                    continue;
                }
                if ("%3A".equalsIgnoreCase(matcher.group())) {
                    matcher.appendReplacement(buffer, ":");
                    continue;
                }
                if ("%2C".equalsIgnoreCase(matcher.group())) {
                    matcher.appendReplacement(buffer, ",");
                    continue;
                }
                if (!"%7D".equalsIgnoreCase(matcher.group())) continue;
                matcher.appendReplacement(buffer, "}");
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return response;
        }
    }

    public static String onErrorDiscovery(String name, String remoteURL, String message) {
        if (message.startsWith("com.netflix.client.ClientException")) {
            String patternExpr = "com.netflix.client.ClientException:\\s+Load\\s+balancer\\s+does\\s+not\\s+have\\s+available\\s+server\\s+for\\s+client:\\s+(?<servicename>.+)";
            Pattern pattern = Pattern.compile(patternExpr);
            Matcher matcher = pattern.matcher(message);
            if (matcher.find()) {
                String response = String.format("\u672a\u53d1\u73b0\u53ef\u7528\u7684%1$s\u670d\u52a1:%2$s", name, matcher.group("servicename"));
                return response;
            }
        } else if (message.startsWith("Read timed out executing POST")) {
            String patternExpr = "Read\\s+timed\\s+out\\s+executing\\s+POST\\s*(?<remoteURL>.+)";
            Pattern pattern = Pattern.compile(patternExpr);
            Matcher matcher = pattern.matcher(message);
            if (matcher.find()) {
                String response = String.format("\u6267\u884c%1$s\u8fdc\u7a0bPOST\u8bf7\u6c42\u3010%2$s\u3011\u8d85\u65f6", name, matcher.group("remoteURL"));
                return response;
            }
        } else if (message.startsWith("java.lang.IllegalStateException") || message.startsWith("No instances available for")) {
            System.out.println("run where--->" + message);
            String eurekaServer = "";
            String servicename = "";
            String patternExpr = ".*No\\s+instances\\s+available\\s+for\\s*(?<eurekaServer>.+)";
            Pattern pattern = Pattern.compile(patternExpr);
            Matcher matcher = pattern.matcher(message);
            if (matcher.find()) {
                eurekaServer = matcher.group("eurekaServer");
                patternExpr = "http://(?<servicename>.+)(?<URI>.+)";
                pattern = Pattern.compile(patternExpr);
                matcher = pattern.matcher(remoteURL);
                if (matcher.find()) {
                    servicename = matcher.group("servicename");
                    int position = servicename.indexOf("/");
                    if (position > 0) {
                        servicename = servicename.substring(0, position);
                    }
                    String response = String.format("\u6ce8\u518c\u4e2d\u5fc3\u3010%1$s\u3011\u670d\u52a1%2$s\u3010%3$s\u3011\u4e0d\u53ef\u7528", eurekaServer, name, servicename);
                    return response;
                }
            }
        }
        return message;
    }

    public static <T> T onHttpPost(RestTemplate restTemplate, String templateURL, ServiceSession session, String value, Class<T> responseType) {
        return DiscoveryRestUtils.onHttpPost(restTemplate, "", templateURL, session, value, responseType, null);
    }

    public static <T> T onHttpPost(RestTemplate restTemplate, String traceID, String templateURL, ServiceSession session, String value, Class<T> responseType) {
        return DiscoveryRestUtils.onHttpPost(restTemplate, traceID, templateURL, session, value, responseType, null);
    }

    public static <T, X> T onHttpPost(RestTemplate restTemplate, String traceID, String templateURL, ServiceSession session, String value, Class<T> responseType, Class<X> instanceType) {
        Map<String, String> paramsMap = Collections.singletonMap("session", JSON.toJSONString((Object)session));
        return DiscoveryRestUtils.onHttpPost(restTemplate, traceID, templateURL, paramsMap, value, responseType, instanceType);
    }

    public static <T, X> T onHttpPost(RestTemplate restTemplate, String traceID, String templateURL, Map<String, String> paramsMap, String value, Class<T> responseType, Class<X> instanceType) {
        int connectTimeout = 1000;
        int readTimeout = 1000;
        String mediaType = "application/json; charset=UTF-8";
        return DiscoveryRestUtils.onHttpPost(restTemplate, traceID, connectTimeout, readTimeout, mediaType, templateURL, paramsMap, value, responseType, instanceType);
    }

    public static <T, X> T onHttpPost(RestTemplate restTemplate, String traceID, int connectTimeout, int readTimeout, String mediaType, String templateURL, Map<String, String> paramsMap, String value, Class<T> responseType, Class<X> instanceType) {
        return DiscoveryRestUtils.onHttpRequest(restTemplate, "POST", traceID, connectTimeout, readTimeout, mediaType, templateURL, paramsMap, value, responseType, instanceType);
    }

    public static <T, X> T onHttpGet(RestTemplate restTemplate, String traceID, int connectTimeout, int readTimeout, String mediaType, String templateURL, Map<String, String> paramsMap, Class<T> responseType, Class<X> instanceType) {
        return DiscoveryRestUtils.onHttpRequest(restTemplate, "GET", traceID, connectTimeout, readTimeout, mediaType, templateURL, paramsMap, null, responseType, instanceType);
    }

    public static <T, X> T onHttpRequest(RestTemplate restTemplate, String httpMethod, String traceID, int connectTimeout, int readTimeout, String mediaType, String templateURL, Map<String, String> paramsMap, String value, Class<T> responseType, Class<X> instanceType) {
        Object response;
        SimpleDateFormat formatter;
        long startTimeMillis;
        String remoteURL;
        block14: {
            remoteURL = templateURL;
            if (paramsMap != null && paramsMap.size() > 0) {
                UriTemplate template = new UriTemplate(templateURL);
                try {
                    remoteURL = template.expand(paramsMap).toString();
                }
                catch (Exception e) {
                    System.out.println(String.format("RemoteURL: %1$s params:%2$s onFaiure for expand:%3$s", templateURL, JSON.toJSONString(paramsMap), e.getMessage()));
                    throw e;
                }
                logger.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)templateURL);
                DumpMsg.printStack((Logger)logger, (String)"onHttpRequest", (String)remoteURL, (String)"javax.servlet.http.HttpServlet");
                if (instanceType != null) {
                    Logger LOGGER = LoggerFactory.getLogger(instanceType);
                    LOGGER.debug(String.format("current transfer:\r\n===============\r\n%1$s\r\n===============\r\n", remoteURL));
                }
            }
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            if (connectTimeout > 0) {
                requestFactory.setConnectTimeout(connectTimeout);
            }
            if (readTimeout > 0) {
                requestFactory.setReadTimeout(readTimeout);
            }
            restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
            HttpHeaders headers = new HttpHeaders();
            if (!StringUtils.isEmpty((Object)mediaType)) {
                MediaType type = MediaType.parseMediaType((String)mediaType);
                headers.setContentType(type);
            }
            startTimeMillis = System.currentTimeMillis();
            formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            try {
                if ("POST".equalsIgnoreCase(httpMethod)) {
                    Object paramsObject = JSONObject.parse((String)value);
                    HttpEntity postEntity = new HttpEntity((Object)JSON.toJSONString((Object)paramsObject), (MultiValueMap)headers);
                    response = restTemplate.postForObject(remoteURL, (Object)postEntity, responseType, new Object[0]);
                    break block14;
                }
                response = restTemplate.getForObject(remoteURL, responseType, new Object[0]);
            }
            catch (Exception e) {
                try {
                    System.out.println("\u8fdc\u7a0b\u8bf7\u6c42:---->" + e.getMessage());
                    String message = DiscoveryRestUtils.onErrorDiscovery("\u8fdc\u7a0b\u8bf7\u6c42:---->", remoteURL, e.getMessage());
                    System.out.println("\u8fdc\u7a0b\u8bf7\u6c42:---->parse---->" + message);
                    throw e;
                }
                catch (Throwable throwable) {
                    long endTimeMillis = System.currentTimeMillis();
                    if (instanceType != null) {
                        Logger LOGGER = LoggerFactory.getLogger(instanceType);
                        LOGGER.info(String.format("onHttpPost:traceID->[%1$s] remoteURL->[%2$s] starttime->[%3$s] endtime->[%4$s] usetime->[%5$d] timestamp->[%6$s]", traceID, remoteURL, formatter.format(new Date(startTimeMillis)), formatter.format(new Date(endTimeMillis)), endTimeMillis - startTimeMillis, formatter.format(new Date())));
                    }
                    throw throwable;
                }
            }
        }
        long endTimeMillis = System.currentTimeMillis();
        if (instanceType != null) {
            Logger LOGGER = LoggerFactory.getLogger(instanceType);
            LOGGER.info(String.format("onHttpPost:traceID->[%1$s] remoteURL->[%2$s] starttime->[%3$s] endtime->[%4$s] usetime->[%5$d] timestamp->[%6$s]", traceID, remoteURL, formatter.format(new Date(startTimeMillis)), formatter.format(new Date(endTimeMillis)), endTimeMillis - startTimeMillis, formatter.format(new Date())));
        }
        return (T)response;
    }
}

