/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URLDecoder;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpRequestUtils.class);

    public static JSONObject httpPost(String url, JSONObject jsonParam) {
        return HttpRequestUtils.httpPost(url, jsonParam, false);
    }

    public static JSONObject httpPost(String url, JSONObject jsonParam, boolean noNeedResponse) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        JSONObject jsonResult = null;
        HttpPost method = new HttpPost(url);
        try {
            if (null != jsonParam) {
                StringEntity entity = new StringEntity(jsonParam.toString(), "utf-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json");
                method.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)method);
            url = URLDecoder.decode(url, "UTF-8");
            if (result.getStatusLine().getStatusCode() == 200) {
                String str = "";
                try {
                    str = EntityUtils.toString((HttpEntity)result.getEntity());
                    if (noNeedResponse) {
                        return null;
                    }
                    jsonResult = JSON.parseObject((String)str);
                }
                catch (Exception e) {
                    logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        return jsonResult;
    }

    public static JSONObject httpGet(String url) {
        JSONObject jsonResult = null;
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpGet request = new HttpGet(url);
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                String strResult = EntityUtils.toString((HttpEntity)response.getEntity());
                jsonResult = JSON.parseObject((String)strResult);
                url = URLDecoder.decode(url, "UTF-8");
            } else {
                logger.error("get\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url);
            }
        }
        catch (IOException e) {
            logger.error("get\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        return jsonResult;
    }
}

