/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.security.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.common.component.BaseServiceComponent;
import com.efuture.common.entity.ServiceResponse;
import com.efuture.common.entity.ServiceSession;
import com.efuture.security.entity.AccountBean;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@ConditionalOnProperty(name={"spring.data.mongodb"}, matchIfMissing=false)
@Component(value="accountservice")
public class AccountServiceImpl
extends BaseServiceComponent {
    @Autowired
    MongoTemplate mongoTemplate;

    public ServiceResponse changePassword(ServiceSession session, String params) {
        try {
            this.AssertNotNullSession(session, "\u901a\u7528\u4f01\u4e1a\u4fee\u6539\u5bc6\u7801\u64cd\u4f5c");
            this.AssertNotNullParams(params, "\u901a\u7528\u4f01\u4e1a\u4fee\u6539\u5bc6\u7801\u64cd\u4f5c");
            this.AssertInformation(session, params, "\u901a\u7528\u4f01\u4e1a\u4fee\u6539\u5bc6\u7801\u64cd\u4f5c\u4fe1\u606f");
            JSONObject paramsObject = JSON.parseObject((String)params);
            if (!(paramsObject.containsKey((Object)"old_password") && paramsObject.containsKey((Object)"new_password1") && paramsObject.containsKey((Object)"new_password2") && paramsObject.get((Object)"old_password") != null && paramsObject.get((Object)"new_password1") != null && paramsObject.get((Object)"new_password1").equals(paramsObject.get((Object)"new_password2")))) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)session.getEnt_id());
            criteria.and("code").is((Object)paramsObject.getString("code"));
            criteria.and("password").is((Object)paramsObject.getString("old_password"));
            Query query = new Query((CriteriaDefinition)criteria);
            query.fields().include("authid");
            query.fields().include("code");
            query.fields().include("name");
            query.fields().include("ent_id");
            query.fields().include("extData");
            query.fields().include("expires");
            Sort order = new Sort(Sort.Direction.DESC, new String[]{"code"});
            query.with((Pageable)new PageRequest(0, 1, order));
            Assert.notNull((Object)this.mongoTemplate, (String)"MongoTemplate must not be null!");
            List dataList = this.mongoTemplate.find(query, AccountBean.class);
            if (dataList == null || dataList.size() < 1) {
                return ServiceResponse.buildFailure(session, "50000", "\u975e\u6cd5\u7528\u6237\u8d44\u6599", new Object[0]);
            }
            AccountBean accountBean = (AccountBean)dataList.get(0);
            accountBean.setPassword((String)paramsObject.get((Object)"new_password1"));
            accountBean.initUpdateMember(session);
            Update update = new Update();
            update.set("password", (Object)accountBean.getPassword());
            update.set("modifier", (Object)session.getUser_name());
            update.set("modifier_id", (Object)session.getUser_id());
            update.set("timestamp", (Object)new Date());
            update.set("note", (Object)"\u4fee\u6539\u5bc6\u7801");
            this.mongoTemplate.updateMulti(query, update, AccountBean.class);
            JSONObject respdata = new JSONObject();
            respdata.put("aid", (Object)accountBean.getAid());
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (Exception ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getMessage());
        }
    }
}

