/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.security.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.efuture.common.component.BaseServiceComponent;
import com.efuture.common.entity.ServiceResponse;
import com.efuture.common.entity.ServiceSession;
import com.efuture.common.exception.ServiceException;
import com.efuture.common.utils.ReflectUtils;
import com.efuture.common.utils.SimplePropertyFilter;
import com.efuture.redis.component.FtJedisPool;
import com.efuture.security.component.AccountServiceImpl;
import com.efuture.security.entity.AccountBean;
import com.efuture.security.entity.AuthenticationBean;
import com.mongodb.Mongo;
import com.product.util.SpringContext;
import com.product.util.UniqueID;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;

@ConditionalOnProperty(name={"spring.data.mongodb"}, matchIfMissing=false)
@Component(value="authenticationservice")
public class AuthenticationServiceImpl
extends BaseServiceComponent {
    @Autowired
    @Qualifier(value="mongoMasterTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    AccountServiceImpl accountservice;
    @Autowired
    private FtJedisPool jedisPool;

    private void onTokenSync(AuthenticationBean authentication) {
        Jedis jedis = this.jedisPool.getResource();
        Transaction tx = jedis.multi();
        final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String params = JSON.toJSONString((Object)authentication, (SerializeFilter)new ValueFilter(){

            public Object process(Object object, String name, Object value) {
                if (value != null) {
                    if (value instanceof Date) {
                        return formatter.format((Date)value);
                    }
                    return value.toString();
                }
                return value;
            }
        }, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
        Map paramsMap = (Map)JSON.parseObject((String)params, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String id = UUID.randomUUID().toString();
        long stamp = System.currentTimeMillis();
        String hashKey = "signtoken:log:" + id;
        String sortSetKey = "signtoken:log:update";
        tx.hmset(hashKey, paramsMap);
        tx.zadd(sortSetKey, (double)stamp, id);
        List results = tx.exec();
        if (results == null) {
            this.getLogger().error((Object)("\u6267\u884c[onTokenSync]\u4e8b\u52a1\u5f02\u5e38:" + this.jedisPool.getJedisPoolInfo()));
        }
        jedis.close();
    }

    private String getExpires() {
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date current = new Date();
        String expires = dataFormat.format(new Date(current.getTime() + 604800000L));
        return expires;
    }

    private void onOutputDBInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.format("mongoTemplate.getClass().getName():%1$s\r\n", this.mongoTemplate.getClass().getName()));
        MongoDbFactory dbFactory = ReflectUtils.onReflect(this.mongoTemplate, "mongoDbFactory", MongoDbFactory.class);
        if (dbFactory != null) {
            String dbName = ReflectUtils.onReflect(dbFactory, "databaseName", String.class);
            Mongo dbClient = ReflectUtils.onReflect(dbFactory, "mongo", Mongo.class);
            if (dbClient != null) {
                buffer.append(dbClient.toString());
                buffer.append("\r\n");
            }
            buffer.append(String.format("databaseName:%1$s", dbName));
        } else {
            System.out.println("MongoTemplate is null");
        }
        System.out.println(String.format("MongoTemplate %1$s", buffer.toString()));
    }

    public ServiceResponse signIn(ServiceSession session, String params) {
        try {
            this.AssertNotNullSession(session, "\u6307\u5b9a\u4f01\u4e1a\u767b\u5f55\u64cd\u4f5c");
            this.AssertNotNullParams(params, "\u6307\u5b9a\u4f01\u4e1a\u767b\u5f55\u64cd\u4f5c");
            this.AssertInformation(session, params, "\u6307\u5b9a\u4f01\u4e1a\u767b\u5f55\u64cd\u4f5c\u4fe1\u606f");
            AuthenticationBean authentication = (AuthenticationBean)JSON.parseObject((String)params, AuthenticationBean.class);
            try {
                authentication.validateBeanForSpecified("ent_id");
                session.setEnt_id(authentication.getEnt_id());
            }
            catch (Exception e) {
                authentication.setEnt_id(session.getEnt_id());
            }
            authentication.setToken(Long.toString(UniqueID.getUniqueID()));
            authentication.initInsertMember(session);
            authentication.setExpires(this.getExpires());
            if (StringUtils.isEmpty((Object)authentication.getPassword())) {
                authentication.setPassword("#");
            }
            String password = authentication.getPassword();
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)authentication.getEnt_id());
            criteria.and("code").is((Object)authentication.getCode());
            criteria.and("password").is((Object)password);
            Query query = new Query((CriteriaDefinition)criteria);
            query.fields().include("aid");
            query.fields().include("code");
            query.fields().include("name");
            query.fields().include("password");
            query.fields().include("expires");
            query.fields().include("customer_code");
            query.fields().include("ent_id");
            Sort order = new Sort(Sort.Direction.DESC, new String[]{"code"});
            query.with((Pageable)new PageRequest(0, 1, order));
            try {
                this.onOutputDBInfo();
                Assert.notNull((Object)this.mongoTemplate, (String)"MongoTemplate must not be null!");
                List dataList = null;
                try {
                    dataList = this.mongoTemplate.find(query, AccountBean.class);
                }
                catch (DataAccessResourceFailureException darfe) {
                    return ServiceResponse.buildFailure(session, "50000", "\u8fde\u63a5\u8ba4\u8bc1\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38:{0}", darfe.getMessage() + "");
                }
                if (dataList == null || dataList.size() < 1) {
                    return ServiceResponse.buildFailure(session, "50000", "\u767b\u5f55\u8ba4\u8bc1\u7528\u6237\u3001\u5bc6\u7801\u6216\u5bf9\u5e94\u4f01\u4e1a\u4e0d\u6b63\u786e", new Object[0]);
                }
                AccountBean accountBean = (AccountBean)dataList.get(0);
                String custno = accountBean.getCustomer_code();
                if (StringUtils.isEmpty((Object)custno)) {
                    custno = "";
                }
                authentication.setAuthid(accountBean.getAid());
                authentication.setCode(accountBean.getCode());
                authentication.setName(accountBean.getName());
                authentication.setPassword(accountBean.getPassword());
                authentication.setCustomer_code(custno);
                authentication.initInsertMember(session);
                authentication.setEnt_id(accountBean.getEnt_id());
                authentication.setSerialno(UniqueID.getUniqueID((boolean)true));
                this.mongoTemplate.insert((Object)authentication);
                try {
                    this.onTokenSync(authentication);
                }
                catch (Exception e) {
                    this.getLogger().info((Object)String.format("signInNoEnt->%1$s -> %2$s -> %3$s", "\u6267\u884c\u4ee4\u724c\u5199\u5165\u5f02\u5e38:\u8bf7\u68c0\u67e5Redis\u662f\u5426\u5df2\u7ecf\u542f\u52a8", e.getMessage(), this.jedisPool.getJedisPoolInfo()));
                    return ServiceResponse.buildFailure(session, "50000", "\u6267\u884c\u4ee4\u724c\u5199\u5165\u5f02\u5e38:{0}\u8bf7\u68c0\u67e5Redis\u662f\u5426\u5df2\u7ecf\u542f\u52a8", e.getMessage());
                }
                JSONObject response = new JSONObject();
                response.put("token", (Object)authentication.getToken());
                response.put("expires", (Object)authentication.getExpires());
                response.put("extData", (Object)authentication.getExtData());
                response.put("customer_code", (Object)authentication.getCustomer_code());
                return ServiceResponse.buildSuccess(response);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return ServiceResponse.buildFailure(session, ex.getMessage());
            }
        }
        catch (ServiceException se) {
            return ServiceResponse.buildFailure(session, se.getErrorCode(), se.getMessage(), se.getErrorArgs());
        }
    }

    public ServiceResponse signInNoEnt(ServiceSession session, String params) {
        try {
            this.AssertNotNullSession(session, "\u901a\u7528\u4f01\u4e1a\u767b\u5f55\u64cd\u4f5c");
            this.AssertNotNullParams(params, "\u901a\u7528\u4f01\u4e1a\u767b\u5f55\u64cd\u4f5c");
            this.AssertInformation(session, params, "\u901a\u7528\u4f01\u4e1a\u767b\u5f55\u64cd\u4f5c\u4fe1\u606f");
            AuthenticationBean authentication = null;
            try {
                authentication = (AuthenticationBean)JSON.parseObject((String)params, AuthenticationBean.class);
            }
            catch (Exception e) {
                return ServiceResponse.buildFailure(session, "50000", "\u901a\u7528\u4f01\u4e1a\u767b\u5f55\u64cd\u4f5c\u767b\u5f55\u89e3\u6790JSON\u5931\u8d25:{0}\uff0c\u8bf7\u6c42\u53c2\u6570:{1}", e.getMessage(), params);
            }
            this.getLogger().info((Object)String.format("signInNoEnt->%1$s", "params parse successful."));
            if (StringUtils.isEmpty((Object)authentication.getPassword())) {
                authentication.setPassword("#");
            }
            String password = authentication.getPassword();
            String tag = authentication.getTag();
            Criteria criteria = Criteria.where((String)"code").is((Object)authentication.getCode());
            criteria.and("password").is((Object)password);
            if (!StringUtils.isEmpty((Object)tag)) {
                criteria.and("tag").is((Object)tag);
            }
            Query query = new Query((CriteriaDefinition)criteria);
            query.fields().include("aid");
            query.fields().include("code");
            query.fields().include("name");
            query.fields().include("password");
            query.fields().include("expires");
            query.fields().include("customer_code");
            query.fields().include("ent_id");
            Sort order = new Sort(Sort.Direction.DESC, new String[]{"code"});
            query.with((Pageable)new PageRequest(0, 1, order));
            try {
                this.onOutputDBInfo();
                Assert.notNull((Object)this.mongoTemplate, (String)"MongoTemplate must not be null!");
                this.getLogger().info((Object)String.format("signInNoEnt->%1$s", "output database information successful."));
                List dataList = this.mongoTemplate.find(query, AccountBean.class);
                if (dataList == null || dataList.size() < 1) {
                    this.getLogger().info((Object)String.format("signInNoEnt->%1$s", "\u767b\u5f55\u8ba4\u8bc1\u7528\u6237\u6216\u5bc6\u7801\u4e0d\u6b63\u786e"));
                    return ServiceResponse.buildFailure(session, "50000", "\u767b\u5f55\u8ba4\u8bc1\u7528\u6237\u6216\u5bc6\u7801\u4e0d\u6b63\u786e", new Object[0]);
                }
                this.getLogger().info((Object)String.format("signInNoEnt->%1$s", "\u767b\u5f55\u8ba4\u8bc1\u901a\u8fc7"));
                AccountBean accountBean = (AccountBean)dataList.get(0);
                String custno = accountBean.getCustomer_code();
                if (StringUtils.isEmpty((Object)custno)) {
                    custno = "";
                }
                try {
                    session.setEnt_id(accountBean.getEnt_id());
                }
                catch (Exception e) {
                    authentication.setEnt_id(accountBean.getEnt_id());
                }
                authentication.setToken(Long.toString(UniqueID.getUniqueID()));
                authentication.initInsertMember(session);
                authentication.setAuthid(accountBean.getAid());
                authentication.setCode(accountBean.getCode());
                authentication.setName(accountBean.getName());
                authentication.setPassword(accountBean.getPassword());
                authentication.setCustomer_code(custno);
                authentication.initInsertMember(session);
                authentication.setEnt_id(accountBean.getEnt_id());
                authentication.setExpires(this.getExpires());
                authentication.setSerialno(UniqueID.getUniqueID((boolean)true));
                this.getLogger().info((Object)String.format("signInNoEnt->%1$s", "\u63d2\u5165\u8ba4\u8bc1\u4fe1\u606f\u524d"));
                this.mongoTemplate.insert((Object)authentication);
                this.getLogger().info((Object)String.format("signInNoEnt->%1$s", "\u63d2\u5165\u8ba4\u8bc1\u4fe1\u606f\u540e"));
                try {
                    this.onTokenSync(authentication);
                }
                catch (Exception e) {
                    this.getLogger().info((Object)String.format("signInNoEnt->%1$s -> %2$s -> %3$s", "\u6267\u884c\u4ee4\u724c\u5199\u5165\u5f02\u5e38:\u8bf7\u68c0\u67e5Redis\u662f\u5426\u5df2\u7ecf\u542f\u52a8", e.getMessage(), this.jedisPool.getJedisPoolInfo()));
                    return ServiceResponse.buildFailure(session, "50000", "\u6267\u884c\u4ee4\u724c\u5199\u5165\u5f02\u5e38:{0}\u8bf7\u68c0\u67e5Redis\u662f\u5426\u5df2\u7ecf\u542f\u52a8", e.getMessage());
                }
                JSONObject response = new JSONObject();
                response.put("token", (Object)authentication.getToken());
                response.put("expires", (Object)authentication.getExpires());
                response.put("extData", (Object)authentication.getExtData());
                response.put("customer_code", (Object)authentication.getCustomer_code());
                this.getLogger().info((Object)String.format("signInNoEnt->%1$s", "\u8fd4\u56de\u767b\u5f55\u6210\u529f"));
                return ServiceResponse.buildSuccess(response);
            }
            catch (Exception ex) {
                this.getLogger().info((Object)String.format("signInNoEnt->%1$s -> %2$s", "\u8fd4\u56de\u767b\u5f55\u5f02\u5e38", ex.getMessage()));
                return ServiceResponse.buildFailure(session, ex.getMessage());
            }
        }
        catch (ServiceException se) {
            this.getLogger().info((Object)String.format("signInNoEnt->%1$s -> %s$s", "\u8fd4\u56de\u767b\u5f55\u5f02\u5e382", se.getMessage()));
            return ServiceResponse.buildFailure(session, se.getErrorCode(), se.getMessage(), se.getErrorArgs());
        }
    }

    public ServiceResponse signOut(ServiceSession session, String params) {
        try {
            if (StringUtils.isEmpty((Object)params)) {
                params = "{}";
            }
            this.AssertNotNullSession(session, "\u901a\u7528\u4f01\u4e1a\u767b\u51fa\u64cd\u4f5c");
            this.AssertNotNullParams(params, "\u901a\u7528\u4f01\u4e1a\u767b\u51fa\u64cd\u4f5c");
            this.AssertInformation(session, params, "\u901a\u7528\u4f01\u4e1a\u767b\u51fa\u64cd\u4f5c\u4fe1\u606f");
            AuthenticationBean authenticationBean = (AuthenticationBean)JSON.parseObject((String)params, AuthenticationBean.class);
            authenticationBean.validateBeanForSpecified("token");
            Criteria criteria = Criteria.where((String)"token").is((Object)authenticationBean.getToken());
            Query query = new Query((CriteriaDefinition)criteria);
            query.fields().include("authid");
            query.fields().include("code");
            query.fields().include("name");
            query.fields().include("password");
            query.fields().include("expires");
            Sort order = new Sort(Sort.Direction.DESC, new String[]{"code"});
            query.with((Pageable)new PageRequest(0, 1, order));
            this.onOutputDBInfo();
            Assert.notNull((Object)this.mongoTemplate, (String)"MongoTemplate must not be null!");
            List dataList = this.mongoTemplate.find(query, AuthenticationBean.class);
            if (dataList == null || dataList.size() < 1) {
                return ServiceResponse.buildFailure(session, "50000", "\u7cfb\u7edf\u767b\u5f55\u4ee4\u724c\u65e0\u6548", new Object[0]);
            }
            this.mongoTemplate.remove(query, AuthenticationBean.class);
            JSONObject response = new JSONObject();
            response.put("token", (Object)authenticationBean.getToken());
            return ServiceResponse.buildSuccess(response);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    public ServiceResponse checkState(ServiceSession session, String params) {
        try {
            if (StringUtils.isEmpty((Object)params)) {
                params = "{}";
            }
            this.AssertNotNullSession(session, "\u901a\u7528\u4f01\u4e1a\u4ee4\u724c\u68c0\u67e5\u64cd\u4f5c");
            this.AssertNotNullParams(params, "\u901a\u7528\u4f01\u4e1a\u4ee4\u724c\u68c0\u67e5\u64cd\u4f5c");
            this.AssertInformation(session, params, "\u901a\u7528\u4f01\u4e1a\u4ee4\u724c\u68c0\u67e5\u64cd\u4f5c\u4fe1\u606f");
            AuthenticationBean authenticationBean = (AuthenticationBean)JSON.parseObject((String)params, AuthenticationBean.class);
            authenticationBean.validateBeanForSpecified("token");
            Criteria criteria = Criteria.where((String)"token").is((Object)authenticationBean.getToken());
            Query query = new Query((CriteriaDefinition)criteria);
            query.fields().include("authid");
            query.fields().include("token");
            query.fields().include("code");
            query.fields().include("name");
            query.fields().include("ent_id");
            query.fields().include("extData");
            query.fields().include("expires");
            Sort order = new Sort(Sort.Direction.DESC, new String[]{"code"});
            query.with((Pageable)new PageRequest(0, 1, order));
            this.mongoTemplate = (MongoTemplate)SpringContext.getContext().getBean(MongoTemplate.class);
            Assert.notNull((Object)this.mongoTemplate, (String)"MongoTemplate must not be null!");
            System.out.println("------------>checkState:" + query.toString());
            List dataList = this.mongoTemplate.find(query, AuthenticationBean.class);
            if (dataList == null || dataList.size() < 1) {
                return ServiceResponse.buildFailure(session, "50000", "\u7cfb\u7edf\u767b\u5f55\u4ee4\u724c\u65e0\u6548", new Object[0]);
            }
            SimplePropertyFilter filter = new SimplePropertyFilter(new String[]{"token", "authid", "code", "name", "ent_id", "extData", "expires"}){

                @Override
                public Object process(Object object, String name, Object value) {
                    if ("authid".equals(name)) {
                        return value.toString();
                    }
                    return value;
                }
            };
            authenticationBean = (AuthenticationBean)dataList.get(0);
            String jsonParam = JSON.toJSONString((Object)authenticationBean, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
            return ServiceResponse.buildSuccess(JSON.parse((String)jsonParam));
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    public ServiceResponse changePassword(ServiceSession session, String params) {
        Assert.notNull((Object)this.accountservice, (String)"AccountServiceImpl must not be null!");
        return this.accountservice.changePassword(session, params);
    }
}

