/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.wx.api;

import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.api.BasePayService;
import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.PayOutMessage;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.bean.TransferOrder;
import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.util.MatrixToImageWriter;
import com.egzosn.pay.common.util.XML;
import com.egzosn.pay.common.util.sign.SignUtils;
import com.egzosn.pay.common.util.str.StringUtils;
import com.egzosn.pay.wx.bean.WxPayError;
import com.egzosn.pay.wx.bean.WxTransactionType;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WxPayService
extends BasePayService {
    protected final Log LOG = LogFactory.getLog(WxPayService.class);
    public static final String URI = "https://api.mch.weixin.qq.com/";
    public static final String SANDBOXNEW = "sandboxnew/";
    public static final String SUCCESS = "SUCCESS";
    public static final String RETURN_CODE = "return_code";
    public static final String SIGN = "sign";

    public WxPayService(PayConfigStorage payConfigStorage) {
        super(payConfigStorage);
    }

    public WxPayService(PayConfigStorage payConfigStorage, HttpConfigStorage configStorage) {
        super(payConfigStorage, configStorage);
    }

    private String getUrl(TransactionType transactionType) {
        return URI + (this.payConfigStorage.isTest() ? SANDBOXNEW : "") + transactionType.getMethod();
    }

    public boolean verify(Map<String, Object> params) {
        if (!SUCCESS.equals(params.get(RETURN_CODE))) {
            this.LOG.debug((Object)String.format("\u5fae\u4fe1\u652f\u4ed8\u5f02\u5e38\uff1areturn_code=%s,\u53c2\u6570\u96c6=%s", params.get(RETURN_CODE), params));
            return false;
        }
        if (null == params.get(SIGN)) {
            this.LOG.debug((Object)("\u5fae\u4fe1\u652f\u4ed8\u5f02\u5e38\uff1a\u7b7e\u540d\u4e3a\u7a7a\uff01out_trade_no=" + params.get("out_trade_no")));
            return false;
        }
        try {
            return this.signVerify(params, (String)params.get(SIGN)) && this.verifySource((String)params.get("out_trade_no"));
        }
        catch (PayErrorException e) {
            this.LOG.error((Object)e);
            return false;
        }
    }

    public boolean verifySource(String id) {
        return true;
    }

    public boolean signVerify(Map<String, Object> params, String sign) {
        return SignUtils.valueOf((String)this.payConfigStorage.getSignType()).verify(params, sign, "&key=" + this.payConfigStorage.getKeyPrivate(), this.payConfigStorage.getInputCharset());
    }

    private Map<String, Object> getPublicParameters() {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("appid", this.payConfigStorage.getAppid());
        parameters.put("mch_id", this.payConfigStorage.getPid());
        parameters.put("nonce_str", SignUtils.randomStr());
        return parameters;
    }

    public JSONObject unifiedOrder(PayOrder order) {
        Map<String, Object> parameters = this.getPublicParameters();
        parameters.put("body", order.getSubject());
        parameters.put("out_trade_no", order.getOutTradeNo());
        parameters.put("spbill_create_ip", StringUtils.isEmpty((CharSequence)order.getSpbillCreateIp()) ? "192.168.1.150" : order.getSpbillCreateIp());
        parameters.put("total_fee", this.conversion(order.getPrice()));
        parameters.put("attach", order.getBody());
        parameters.put("notify_url", this.payConfigStorage.getNotifyUrl());
        parameters.put("trade_type", order.getTransactionType().getType());
        ((WxTransactionType)order.getTransactionType()).setAttribute(parameters, order);
        String sign = this.createSign(SignUtils.parameterText(parameters), this.payConfigStorage.getInputCharset());
        parameters.put(SIGN, sign);
        String requestXML = XML.getMap2Xml(parameters);
        this.LOG.debug((Object)("requestXML\uff1a" + requestXML));
        JSONObject result = (JSONObject)this.requestTemplate.postForObject(this.getUrl(order.getTransactionType()), (Object)requestXML, JSONObject.class, new Object[0]);
        if (!SUCCESS.equals(result.get((Object)RETURN_CODE))) {
            throw new PayErrorException((PayError)new WxPayError(result.getString(RETURN_CODE), result.getString("return_msg"), result.toJSONString()));
        }
        return result;
    }

    public Map<String, Object> orderInfo(PayOrder order) {
        JSONObject result = this.unifiedOrder(order);
        if (this.verify((Map<String, Object>)result)) {
            if (WxTransactionType.NATIVE == order.getTransactionType() || WxTransactionType.MICROPAY == order.getTransactionType() || WxTransactionType.MWEB == order.getTransactionType()) {
                return result;
            }
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            if (WxTransactionType.JSAPI == order.getTransactionType()) {
                params.put("signType", this.payConfigStorage.getSignType());
                params.put("appId", this.payConfigStorage.getAppid());
                params.put("timeStamp", System.currentTimeMillis() / 1000L);
                params.put("nonceStr", result.get((Object)"nonce_str"));
                params.put("package", "prepay_id=" + result.get((Object)"prepay_id"));
            } else if (WxTransactionType.APP == order.getTransactionType()) {
                params.put("partnerid", this.payConfigStorage.getPid());
                params.put("appid", this.payConfigStorage.getAppid());
                params.put("prepayid", result.get((Object)"prepay_id"));
                params.put("timestamp", System.currentTimeMillis() / 1000L);
                params.put("noncestr", result.get((Object)"nonce_str"));
                params.put("package", "Sign=WXPay");
            }
            String paySign = this.createSign(SignUtils.parameterText(params), this.payConfigStorage.getInputCharset());
            params.put(SIGN, paySign);
            return params;
        }
        throw new PayErrorException((PayError)new WxPayError(result.getString(RETURN_CODE), result.getString("return_msg"), "Invalid sign value"));
    }

    private Map<String, Object> setSign(Map<String, Object> parameters) {
        parameters.put("sign_type", this.payConfigStorage.getSignType());
        String sign = this.createSign(SignUtils.parameterText(parameters, (String)"&", (String[])new String[]{SIGN, "appId"}), this.payConfigStorage.getInputCharset());
        parameters.put(SIGN, sign);
        return parameters;
    }

    public String createSign(String content, String characterEncoding) {
        return SignUtils.valueOf((String)this.payConfigStorage.getSignType().toUpperCase()).createSign(content, "&key=" + this.payConfigStorage.getKeyPrivate(), characterEncoding).toUpperCase();
    }

    public Map<String, Object> getParameter2Map(Map<String, String[]> parameterMap, InputStream is) {
        TreeMap map = new TreeMap();
        try {
            return XML.inputStream2Map((InputStream)is, map);
        }
        catch (IOException e) {
            throw new PayErrorException((PayError)new PayException("IOException", e.getMessage()));
        }
    }

    public PayOutMessage getPayOutMessage(String code, String message) {
        return PayOutMessage.XML().code(code.toUpperCase()).content(message).build();
    }

    public PayOutMessage successPayOutMessage(PayMessage payMessage) {
        return PayOutMessage.XML().code("Success").content("\u6210\u529f").build();
    }

    public String buildRequest(Map<String, Object> orderInfo, MethodType method) {
        if (!SUCCESS.equals(orderInfo.get(RETURN_CODE))) {
            throw new PayErrorException((PayError)new WxPayError((String)orderInfo.get(RETURN_CODE), (String)orderInfo.get("return_msg")));
        }
        if (WxTransactionType.MWEB.name().equals(orderInfo.get("trade_type"))) {
            return String.format("<script type=\"text/javascript\">location.href=\"%s%s\"</script>", orderInfo.get("mweb_url"), StringUtils.isEmpty((CharSequence)this.payConfigStorage.getReturnUrl()) ? "" : "&redirect_url=" + URLEncoder.encode(this.payConfigStorage.getReturnUrl()));
        }
        throw new UnsupportedOperationException();
    }

    public BufferedImage genQrPay(PayOrder order) {
        Map<String, Object> orderInfo = this.orderInfo(order);
        if (!SUCCESS.equals(orderInfo.get("result_code"))) {
            throw new PayErrorException((PayError)new WxPayError("-1", (String)orderInfo.get("err_code")));
        }
        return MatrixToImageWriter.writeInfoToJpgBuff((String)((String)orderInfo.get("code_url")));
    }

    public Map<String, Object> microPay(PayOrder order) {
        return this.orderInfo(order);
    }

    public Map<String, Object> query(String transactionId, String outTradeNo) {
        return this.secondaryInterface(transactionId, outTradeNo, WxTransactionType.QUERY);
    }

    public Map<String, Object> close(String transactionId, String outTradeNo) {
        return this.secondaryInterface(transactionId, outTradeNo, WxTransactionType.CLOSE);
    }

    @Deprecated
    public Map<String, Object> refund(String transactionId, String outTradeNo, BigDecimal refundAmount, BigDecimal totalAmount) {
        return this.refund(new RefundOrder(transactionId, outTradeNo, refundAmount, totalAmount));
    }

    public Map<String, Object> refund(RefundOrder refundOrder) {
        Map<String, Object> parameters = this.getPublicParameters();
        if (null != refundOrder.getTradeNo()) {
            parameters.put("transaction_id", refundOrder.getTradeNo());
        } else {
            parameters.put("out_trade_no", refundOrder.getOutTradeNo());
        }
        parameters.put("out_refund_no", refundOrder.getRefundNo());
        parameters.put("total_fee", this.conversion(refundOrder.getTotalAmount()));
        parameters.put("refund_fee", this.conversion(refundOrder.getRefundAmount()));
        parameters.put("op_user_id", this.payConfigStorage.getPid());
        this.setSign(parameters);
        return (Map)this.requestTemplate.postForObject(this.getUrl(WxTransactionType.REFUND), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
    }

    public Map<String, Object> refundquery(String transactionId, String outTradeNo) {
        return this.secondaryInterface(transactionId, outTradeNo, WxTransactionType.REFUNDQUERY);
    }

    public Map<String, Object> downloadbill(Date billDate, String billType) {
        Map<String, Object> parameters = this.getPublicParameters();
        parameters.put("bill_type", billType);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        parameters.put("bill_date", df.format(billDate));
        this.setSign(parameters);
        String respStr = (String)this.requestTemplate.postForObject(this.getUrl(WxTransactionType.DOWNLOADBILL), (Object)XML.getMap2Xml(parameters), String.class, new Object[0]);
        if (respStr.indexOf("<") == 0) {
            return XML.toJSONObject((String)respStr);
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(RETURN_CODE, SUCCESS);
        ret.put("return_msg", "ok");
        ret.put("data", respStr);
        return ret;
    }

    public Map<String, Object> secondaryInterface(Object transactionIdOrBillDate, String outTradeNoBillType, TransactionType transactionType) {
        if (transactionType == WxTransactionType.REFUND) {
            throw new PayErrorException((PayError)new PayException("failure", "\u901a\u7528\u63a5\u53e3\u4e0d\u652f\u6301:" + transactionType));
        }
        if (transactionType == WxTransactionType.DOWNLOADBILL) {
            if (transactionIdOrBillDate instanceof Date) {
                return this.downloadbill((Date)transactionIdOrBillDate, outTradeNoBillType);
            }
            throw new PayErrorException((PayError)new PayException("failure", "\u975e\u6cd5\u7c7b\u578b\u5f02\u5e38:" + transactionIdOrBillDate.getClass()));
        }
        if (null != transactionIdOrBillDate && !(transactionIdOrBillDate instanceof String)) {
            throw new PayErrorException((PayError)new PayException("failure", "\u975e\u6cd5\u7c7b\u578b\u5f02\u5e38:" + transactionIdOrBillDate.getClass()));
        }
        Map<String, Object> parameters = this.getPublicParameters();
        if (StringUtils.isEmpty((CharSequence)((String)transactionIdOrBillDate))) {
            parameters.put("out_trade_no", outTradeNoBillType);
        } else {
            parameters.put("transaction_id", transactionIdOrBillDate);
        }
        this.setSign(parameters);
        return (Map)this.requestTemplate.postForObject(this.getUrl(transactionType), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
    }

    public Map<String, Object> transfer(TransferOrder order) {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("mch_id", this.payConfigStorage.getPid());
        parameters.put("partner_trade_no", order.getOutNo());
        parameters.put("nonce_str", SignUtils.randomStr());
        parameters.put("enc_bank_no", this.keyPublic(order.getPayeeAccount()));
        parameters.put("enc_true_name", this.keyPublic(order.getPayeeName()));
        parameters.put("bank_code", order.getBank().getCode());
        parameters.put("amount", this.conversion(order.getAmount()));
        if (!StringUtils.isEmpty((CharSequence)order.getRemark())) {
            parameters.put("desc", order.getRemark());
        }
        parameters.put(SIGN, SignUtils.valueOf((String)this.payConfigStorage.getSignType()).sign(parameters, this.payConfigStorage.getKeyPrivate(), this.payConfigStorage.getInputCharset()));
        return (Map)this.getHttpRequestTemplate().postForObject(this.getUrl(WxTransactionType.BANK), parameters, JSONObject.class, new Object[0]);
    }

    public Map<String, Object> transferQuery(String outNo, String tradeNo) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("mch_id", this.payConfigStorage.getPid());
        parameters.put("partner_trade_no", StringUtils.isEmpty((CharSequence)outNo) ? tradeNo : outNo);
        parameters.put("nonce_str", SignUtils.randomStr());
        parameters.put(SIGN, SignUtils.valueOf((String)this.payConfigStorage.getSignType()).sign(parameters, this.payConfigStorage.getKeyPrivate(), this.payConfigStorage.getInputCharset()));
        return (Map)this.getHttpRequestTemplate().postForObject(this.getUrl(WxTransactionType.QUERY_BANK), parameters, JSONObject.class, new Object[0]);
    }

    public int conversion(BigDecimal amount) {
        return amount.multiply(new BigDecimal(100)).setScale(0, 4).intValue();
    }

    public String keyPublic(String content) {
        return SignUtils.RSA.createSign(content, this.payConfigStorage.getKeyPublic(), this.payConfigStorage.getInputCharset());
    }
}

