/*
 * Decompiled with CFR 0.152.
 */
package me.eleme.anubis.openapi.api.service;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import me.eleme.anubis.openapi.api.annotation.Service;
import me.eleme.anubis.openapi.api.base.BaseBizApiService;
import me.eleme.anubis.openapi.api.entity.order.AddTipReq;
import me.eleme.anubis.openapi.api.entity.order.AddTipRes;
import me.eleme.anubis.openapi.api.entity.order.CancelOrderReq;
import me.eleme.anubis.openapi.api.entity.order.CancelOrderRes;
import me.eleme.anubis.openapi.api.entity.order.CancelReasonListReq;
import me.eleme.anubis.openapi.api.entity.order.CancelReasonListRes;
import me.eleme.anubis.openapi.api.entity.order.ChainstoreRangeReq;
import me.eleme.anubis.openapi.api.entity.order.ChainstoreRangeRes;
import me.eleme.anubis.openapi.api.entity.order.ClaimOrderReq;
import me.eleme.anubis.openapi.api.entity.order.ClaimOrderRes;
import me.eleme.anubis.openapi.api.entity.order.ComplaintOrderReq;
import me.eleme.anubis.openapi.api.entity.order.ComplaintOrderRes;
import me.eleme.anubis.openapi.api.entity.order.CreateOrderReq;
import me.eleme.anubis.openapi.api.entity.order.CreateOrderRes;
import me.eleme.anubis.openapi.api.entity.order.GetAmountRes;
import me.eleme.anubis.openapi.api.entity.order.GetKnightInfoReq;
import me.eleme.anubis.openapi.api.entity.order.GetKnightInfoRes;
import me.eleme.anubis.openapi.api.entity.order.GetOrderDetailReq;
import me.eleme.anubis.openapi.api.entity.order.GetOrderDetailRes;
import me.eleme.anubis.openapi.api.entity.order.PreCancelOrderReq;
import me.eleme.anubis.openapi.api.entity.order.PreCancelOrderRes;
import me.eleme.anubis.openapi.api.entity.order.PreCreateOrderReq;
import me.eleme.anubis.openapi.api.entity.order.PreCreateOrderRes;
import me.eleme.anubis.openapi.api.exception.ServiceException;
import me.eleme.anubis.openapi.config.Config;
import me.eleme.anubis.openapi.config.oauth.response.Token;

@Service(value="me.ele.order")
public class OrderService
extends BaseBizApiService {
    private static final String CHAINSTORE_RANGE_API_CODE = "chainstoreRange";
    private static final String PRE_CREATE_ORDER_API_CODE = "preCreateOrder";
    private static final String CREATE_ORDER_API_CODE = "createOrder";
    private static final String GET_AMOUNT_API_CODE = "getAmount";
    private static final String ORDER_DETAIL_API_CODE = "getOrderDetail";
    private static final String KNIGHT_INFO_API_CODE = "getKnightInfo";
    private static final String ADD_TIP_API_CODE = "addTip";
    private static final String CANCEL_REASON_LIST_API_CODE = "getCancelReasonList";
    private static final String PRE_CANCEL_ORDER_API_CODE = "preCancelOrder";
    private static final String CANCEL_ORDER_API_CODE = "cancelOrder";
    private static final String COMPLAINT_ORDER_API_CODE = "complaintOrder";
    private static final String CLAIM_ORDER_API_CODE = "claimOrder";

    public OrderService(Config config, Token token) {
        super(config, token, OrderService.class);
    }

    public ChainstoreRangeRes chainstoreRange(ChainstoreRangeReq chainstoreRangeReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("chain_store_id", chainstoreRangeReq.getChainStoreId());
        params.put("out_shop_code", chainstoreRangeReq.getOutShopCode());
        params.put("basic_goods_id", chainstoreRangeReq.getBasicGoodsId());
        return (ChainstoreRangeRes)this.call(CHAINSTORE_RANGE_API_CODE, params);
    }

    public PreCreateOrderRes preCreateOrder(PreCreateOrderReq preCreateOrderReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(32);
        params.put("partner_order_code", preCreateOrderReq.getPartnerOrderCode());
        params.put("out_shop_code", preCreateOrderReq.getOutShopCode());
        params.put("chain_store_id", preCreateOrderReq.getChainStoreId());
        params.put("order_source", preCreateOrderReq.getOrderSource());
        params.put("service_goods_id", preCreateOrderReq.getServiceGoodsId());
        params.put("base_goods_id", preCreateOrderReq.getBaseGoodsId());
        params.put("order_type", preCreateOrderReq.getOrderType());
        params.put("require_receive_time", preCreateOrderReq.getRequireReceiveTime());
        params.put("order_add_time", preCreateOrderReq.getOrderAddTime());
        params.put("use_coupon", preCreateOrderReq.getUseCoupon());
        params.put("expect_fetch_time", preCreateOrderReq.getExpectFetchTime());
        params.put("transport_address", preCreateOrderReq.getTransportAddress());
        params.put("position_source", preCreateOrderReq.getPositionSource());
        params.put("receiver_address", preCreateOrderReq.getReceiverAddress());
        params.put("receiver_longitude", preCreateOrderReq.getReceiverLongitude());
        params.put("receiver_latitude", preCreateOrderReq.getReceiverLatitude());
        params.put("goods_total_amount_cent", preCreateOrderReq.getGoodsTotalAmountCent());
        params.put("goods_actual_amount_cent", preCreateOrderReq.getGoodsActualAmountCent());
        params.put("order_tip_amount_cent", preCreateOrderReq.getOrderTipAmountCent());
        params.put("goods_weight", preCreateOrderReq.getGoodsWeight());
        params.put("goods_count", preCreateOrderReq.getGoodsCount());
        params.put("goods_item_list", preCreateOrderReq.getGoodsItemList());
        return (PreCreateOrderRes)this.call(PRE_CREATE_ORDER_API_CODE, params);
    }

    public CreateOrderRes createOrder(CreateOrderReq createOrderReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(32);
        params.put("partner_order_code", createOrderReq.getPartnerOrderCode());
        params.put("out_shop_code", createOrderReq.getOutShopCode());
        params.put("chain_store_id", createOrderReq.getChainStoreId());
        params.put("order_source", createOrderReq.getOrderSource());
        params.put("service_goods_id", createOrderReq.getServiceGoodsId());
        params.put("base_goods_id", createOrderReq.getBaseGoodsId());
        params.put("order_type", createOrderReq.getOrderType());
        params.put("require_receive_time", createOrderReq.getRequireReceiveTime());
        params.put("order_add_time", createOrderReq.getOrderAddTime());
        params.put("use_coupon", createOrderReq.getUseCoupon());
        params.put("expect_fetch_time", createOrderReq.getExpectFetchTime());
        params.put("transport_address", createOrderReq.getTransportAddress());
        params.put("position_source", createOrderReq.getPositionSource());
        params.put("receiver_address", createOrderReq.getReceiverAddress());
        params.put("receiver_longitude", createOrderReq.getReceiverLongitude());
        params.put("receiver_latitude", createOrderReq.getReceiverLatitude());
        params.put("goods_total_amount_cent", createOrderReq.getGoodsTotalAmountCent());
        params.put("goods_actual_amount_cent", createOrderReq.getGoodsActualAmountCent());
        params.put("order_tip_amount_cent", createOrderReq.getOrderTipAmountCent());
        params.put("goods_weight", createOrderReq.getGoodsWeight());
        params.put("goods_count", createOrderReq.getGoodsCount());
        params.put("goods_item_list", createOrderReq.getGoodsItemList());
        params.put("serial_number", createOrderReq.getSerialNumber());
        params.put("order_source_order_id", createOrderReq.getOrderSourceOrderId());
        params.put("receiver_name", createOrderReq.getReceiverName());
        params.put("receiver_primary_phone", createOrderReq.getReceiverPrimaryPhone());
        params.put("receiver_second_phone", createOrderReq.getReceiverSecondPhone());
        params.put("customer_ext_tel", createOrderReq.getCustomerExtTel());
        params.put("order_remark", createOrderReq.getOrderRemark());
        params.put("pre_create_order_t_index_id", createOrderReq.getPreCreateOrderTIndexId());
        params.put("warehouse_id", createOrderReq.getWarehouseId());
        params.put("actual_delivery_amount_cent", createOrderReq.getActualDeliveryAmountCent());
        params.put("write_off_code", createOrderReq.getWriteOffCode());
        params.put("cancel_code", createOrderReq.getCancelCode());
        params.put("fetch_code", createOrderReq.getFetchCode());
        return (CreateOrderRes)this.call(CREATE_ORDER_API_CODE, params);
    }

    public GetAmountRes getAmount() throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        return (GetAmountRes)this.call(GET_AMOUNT_API_CODE, params);
    }

    public GetOrderDetailRes getOrderDetail(GetOrderDetailReq getOrderDetailReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("order_id", getOrderDetailReq.getOrderId());
        params.put("partner_order_code", getOrderDetailReq.getPartnerOrderCode());
        return (GetOrderDetailRes)this.call(ORDER_DETAIL_API_CODE, params);
    }

    public GetKnightInfoRes getKnightInfo(GetKnightInfoReq knightInfoReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("order_id", knightInfoReq.getOrderId());
        params.put("partner_order_code", knightInfoReq.getPartnerOrderCode());
        return (GetKnightInfoRes)this.call(KNIGHT_INFO_API_CODE, params);
    }

    public AddTipRes addTip(AddTipReq addTipReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("order_id", addTipReq.getOrderId());
        params.put("partner_order_code", addTipReq.getPartnerOrderCode());
        params.put("add_tip_amount_cent", addTipReq.getAddTipAmountCent());
        params.put("third_index_id", addTipReq.getThirdIndexId());
        return (AddTipRes)this.call(ADD_TIP_API_CODE, params);
    }

    public CancelReasonListRes getCancelReasonList(CancelReasonListReq cancelReasonListReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("order_id", cancelReasonListReq.getOrderId());
        params.put("partner_order_code", cancelReasonListReq.getPartnerOrderCode());
        return (CancelReasonListRes)this.call(CANCEL_REASON_LIST_API_CODE, params);
    }

    public PreCancelOrderRes preCancelOrder(PreCancelOrderReq preCancelOrderReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("order_id", preCancelOrderReq.getOrderId());
        params.put("partner_order_code", preCancelOrderReq.getPartnerOrderCode());
        params.put("order_cancel_code", preCancelOrderReq.getOrderCancelCode());
        return (PreCancelOrderRes)this.call(PRE_CANCEL_ORDER_API_CODE, params);
    }

    public CancelOrderRes cancelOrder(CancelOrderReq cancelOrderReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("order_id", cancelOrderReq.getOrderId());
        params.put("partner_order_code", cancelOrderReq.getPartnerOrderCode());
        params.put("order_cancel_code", cancelOrderReq.getOrderCancelCode());
        params.put("actual_cancel_cost_cent", cancelOrderReq.getActualCancelCostCent());
        params.put("order_cancel_other_reason", cancelOrderReq.getOrderCancelOtherReason());
        params.put("order_cancel_role", cancelOrderReq.getOrderCancelRole());
        params.put("need_reverse_order", cancelOrderReq.isNeedReverseOrder());
        return (CancelOrderRes)this.call(CANCEL_ORDER_API_CODE, params);
    }

    public ComplaintOrderRes complaintOrder(ComplaintOrderReq complaintOrderReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("order_id", complaintOrderReq.getOrderId());
        params.put("partner_order_code", complaintOrderReq.getPartnerOrderCode());
        params.put("order_complaint_code", complaintOrderReq.getOrderComplaintCode());
        params.put("order_complaint_desc", complaintOrderReq.getOrderComplaintDesc());
        return (ComplaintOrderRes)this.call(COMPLAINT_ORDER_API_CODE, params);
    }

    public ClaimOrderRes claimOrder(ClaimOrderReq claimOrderReq) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("order_id", claimOrderReq.getOrderId());
        params.put("partner_order_code", claimOrderReq.getPartnerOrderCode());
        params.put("order_claim_code", claimOrderReq.getOrderClaimCode());
        params.put("order_claim_desc", claimOrderReq.getOrderClaimDesc());
        params.put("order_claim_price_cent", claimOrderReq.getOrderClaimPriceCent());
        params.put("order_claim_sk", JSON.toJSONString(claimOrderReq.getOrderClaimSku()));
        return (ClaimOrderRes)this.call(CLAIM_ORDER_API_CODE, params);
    }
}

