/*
 * Decompiled with CFR 0.152.
 */
package me.eleme.anubis.openapi.demo;

import com.alibaba.fastjson.JSON;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import me.eleme.anubis.openapi.api.exception.ServiceException;
import me.eleme.anubis.openapi.config.Config;
import me.eleme.anubis.openapi.config.oauth.response.Token;
import me.eleme.anubis.openapi.oauth.OauthClient;
import me.eleme.anubis.openapi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerDemo {
    private static final Logger log = LoggerFactory.getLogger(HttpServerDemo.class);
    private static final Config CONFIG;
    private static Token TOKEN;
    private static final OauthClient CLIENT;
    private static final boolean IS_SANDBOX = false;
    private static final String AND_STR = "&";
    private static final String EQUAL_STR = "=";
    private static final String CHARSET_NAME = "UTF-8";
    private static final String APP_ID = "app id";
    private static final String SECRET_KEY = "secret key";
    private static final String CALLBACK_URL = "your callback url";

    public static void main(String[] args) {
        try {
            HttpServerDemo.start(8899);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void start(Integer port) throws IOException {
        InetSocketAddress address = new InetSocketAddress(port);
        HttpServer server = HttpServer.create(address, 0);
        if (server != null) {
            server.createContext("/demo", new DemoHandler());
            server.setExecutor(null);
            server.start();
        }
    }

    private static void response(HttpExchange t, String responseMsg) {
        try {
            t.sendResponseHeaders(200, responseMsg.getBytes().length);
            OutputStream os = t.getResponseBody();
            os.write(responseMsg.getBytes(CHARSET_NAME));
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String rtnHtml() throws IOException {
        int length;
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("page/demo.html");
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = resourceAsStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(CHARSET_NAME);
    }

    private static Map<String, String> queryToMap(String query) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        for (String param : query.split(AND_STR)) {
            String[] pair = param.split(EQUAL_STR);
            if (pair.length > 1) {
                result.put(pair[0], pair[1]);
                continue;
            }
            result.put(pair[0], "");
        }
        return result;
    }

    static {
        TOKEN = null;
        CONFIG = new Config(false, APP_ID, SECRET_KEY);
        CLIENT = new OauthClient(CONFIG);
        try {
            TOKEN = CLIENT.getTokenByCode("code", "", "https://localhost:8899/demo");
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    private static class ResponseResult {
        private Result result;

        private ResponseResult() {
        }

        public Result getResult() {
            return this.result;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        static class Result {
            private String oauthUrl;
            private String shopName;

            Result() {
            }

            public String getOauthUrl() {
                return this.oauthUrl;
            }

            public void setOauthUrl(String oauthUrl) {
                this.oauthUrl = oauthUrl;
            }

            public String getShopName() {
                return this.shopName;
            }

            public void setShopName(String shopName) {
                this.shopName = shopName;
            }
        }
    }

    static class DemoHandler
    implements HttpHandler {
        DemoHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String query = t.getRequestURI().getQuery();
            String initHtml = HttpServerDemo.rtnHtml();
            if (StringUtils.isEmpty(query)) {
                HttpServerDemo.response(t, initHtml);
                return;
            }
            Map stringStringMap = HttpServerDemo.queryToMap(t.getRequestURI().getQuery());
            String code = (String)stringStringMap.get("code");
            if (StringUtils.isEmpty(code)) {
                HttpServerDemo.response(t, initHtml);
                return;
            }
            Token token = null;
            try {
                token = CLIENT.getTokenByCode("Mh8FqMk2zbUZg5GQ7sZizI", "11111", "https://localhost:8899/demo");
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            log.error("token\uff1a[}", (Object)JSON.toJSONString((Object)token));
        }
    }
}

