/*
 * Decompiled with CFR 0.152.
 */
package me.eleme.anubis.openapi.oauth;

import java.util.Map;
import java.util.UUID;
import me.eleme.anubis.openapi.config.oauth.response.ErrorResponse;
import me.eleme.anubis.openapi.oauth.OauthRequest;
import me.eleme.anubis.openapi.utils.Base64Util;
import me.eleme.anubis.openapi.utils.EleHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOauthRequest<T extends ErrorResponse>
implements OauthRequest<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseOauthRequest.class);
    protected Map<String, String> headerMap;
    protected Map<String, String> bodyMap;
    protected EleHashMap customParams;

    protected void setAuthorization(String appKey, String appSecret, String sign) {
        String headOauthKey = "Authorization";
        this.putHeaderParam(headOauthKey, this.getBasic(appKey, appSecret), sign);
    }

    public void putHeaderParam(String key, String value, String sign) {
        if (this.headerMap == null) {
            this.headerMap = new EleHashMap();
        }
        this.headerMap.put(key, value);
        String reqId = BaseOauthRequest.getReqId();
        this.headerMap.put("x-eleme-requestid", reqId);
        log.info("{} request id is:{}", (Object)sign, (Object)reqId);
    }

    public void putBodyParam(String key, String value) {
        if (this.bodyMap == null) {
            this.bodyMap = new EleHashMap();
        }
        this.bodyMap.put(key, value);
    }

    private String getBasic(String appKey, String appSecret) {
        StringBuilder sb = new StringBuilder();
        StringBuilder basicContent = new StringBuilder();
        basicContent.append(appKey).append(":").append(appSecret);
        String encodeToString = Base64Util.encode(basicContent.toString().getBytes());
        sb.append("Basic").append(" ").append(encodeToString);
        return sb.toString();
    }

    private static String getReqId() {
        String rid;
        try {
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            if (uuid.length() > 32) {
                uuid = uuid.substring(0, 32);
            }
            rid = uuid.toUpperCase();
        }
        catch (Exception e) {
            rid = "00112233445566778899AABBCCDDEEFF";
        }
        return rid + "|" + System.currentTimeMillis();
    }
}

