/*
 * Decompiled with CFR 0.152.
 */
package me.eleme.anubis.openapi.oauth.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.lang.reflect.Type;
import me.eleme.anubis.openapi.api.entity.base.BaseBizResponse;
import me.eleme.anubis.openapi.api.exception.ServerErrorException;
import me.eleme.anubis.openapi.api.exception.ServiceException;
import me.eleme.anubis.openapi.config.Config;
import me.eleme.anubis.openapi.oauth.IoauthClient;
import me.eleme.anubis.openapi.oauth.OauthRequest;
import me.eleme.anubis.openapi.utils.StringUtils;
import me.eleme.anubis.openapi.utils.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOauthClient
implements IoauthClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultOauthClient.class);
    private final int connectTimeout = 15000;
    private final int readTimeout = 30000;
    private final String serverHostUrl;
    private final Config context;

    public DefaultOauthClient(Config context, String suffix) {
        this.context = context;
        this.serverHostUrl = context.getOauthApiUrl() + suffix;
    }

    @Override
    public <T> T execute(OauthRequest request, Type type) throws ServiceException {
        try {
            String respJson = WebUtils.doPost(this.context, this.serverHostUrl, request.getBodyMap(), "UTF-8", WebUtils.getReqId(), 15000, 30000, request.getHeaderMap());
            log.debug("\u54cd\u5e94\u7ed3\u679c:{}", (Object)respJson);
            BaseBizResponse bizResponse = (BaseBizResponse)JSON.parseObject((String)respJson, BaseBizResponse.class);
            if (bizResponse != null && !"200".equals(bizResponse.getCode())) {
                ServiceException serviceException = DefaultOauthClient.toException(bizResponse);
                if (serviceException != null) {
                    throw serviceException;
                }
                throw new ServerErrorException();
            }
            if (type == Void.TYPE) {
                return null;
            }
            String s2 = bizResponse.getBusinessData();
            return (T)JSON.parseObject((String)s2, (Type)type, (Feature[])new Feature[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ServiceException toException(BaseBizResponse error) throws ServiceException {
        String code = error.getCode();
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        String message = error.getMsg();
        return new ServiceException(message);
    }
}

