/*
 * Decompiled with CFR 0.152.
 */
package me.eleme.anubis.openapi.oauth.request;

import java.util.Map;
import me.eleme.anubis.openapi.config.Config;
import me.eleme.anubis.openapi.config.oauth.response.Token;
import me.eleme.anubis.openapi.oauth.BaseOauthRequest;

public class ServerTokenRequest
extends BaseOauthRequest {
    private final Config context;
    private String code;
    private String redirectUri;
    private String merchantId;
    private String timestamp;
    private String signature;

    public ServerTokenRequest(Config context) {
        this.context = context;
    }

    @Override
    public Class<Token> getResponseClass() {
        return Token.class;
    }

    @Override
    public Map<String, String> getHeaderMap() {
        this.setAuthorization(this.context.getAppId(), this.context.getSecretKey(), "oauth");
        return this.headerMap;
    }

    @Override
    public Map<String, String> getBodyMap() {
        this.putBodyParam("grant_type", "authorization_code");
        this.putBodyParam("code", this.code);
        this.putBodyParam("merchant_id", this.getMerchantId());
        this.putBodyParam("app_id", this.context.getAppId());
        this.putBodyParam("timestamp", this.getTimestamp());
        this.putBodyParam("signature", this.getSignature());
        return this.bodyMap;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }
}

