/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.sunchenbin.mybatis.actable.manager.common;

import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import com.gitee.sunchenbin.mybatis.actable.command.PageResultCommand;
import com.gitee.sunchenbin.mybatis.actable.command.SaveOrUpdateDataCommand;
import com.gitee.sunchenbin.mybatis.actable.dao.common.BaseMysqlCRUDMapper;
import com.gitee.sunchenbin.mybatis.actable.manager.common.BaseMysqlCRUDManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="baseMysqlCRUDManager")
public class BaseMysqlCRUDManagerImpl
implements BaseMysqlCRUDManager {
    private static final Logger log = LoggerFactory.getLogger(BaseMysqlCRUDManagerImpl.class);
    private static final String KEYFIELDMAP = "keyFieldMap";
    @Autowired
    private BaseMysqlCRUDMapper baseMysqlCRUDMapper;

    @Override
    public <T> Integer save(T obj) {
        SaveOrUpdateDataCommand saveOrUpdateDataCommand;
        boolean isSave = true;
        Table tableName = obj.getClass().getAnnotation(Table.class);
        if (tableName == null || tableName.name() == null || tableName.name() == "") {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            return null;
        }
        Field[] declaredFields = this.getAllFields(obj);
        HashMap<Object, Map<Object, Object>> tableMap = new HashMap<Object, Map<Object, Object>>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, Object> keyFieldMap = new HashMap<String, Object>();
        Integer updateId = null;
        for (Field field : declaredFields) {
            try {
                field.setAccessible(true);
                Column column = field.getAnnotation(Column.class);
                if (column == null) {
                    log.info("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                    continue;
                }
                if (column.isKey() && field.get(obj) != null && new Integer(field.get(obj).toString()) > 0) {
                    isSave = false;
                    keyFieldMap.put(field.getName(), field.get(obj));
                    updateId = (Integer)field.get(obj);
                }
                if (isSave && column.isAutoIncrement()) {
                    log.info("\u5b57\u6bb5\uff1a" + field.getName() + "\u662f\u81ea\u589e\u7684\u4e0d\u9700\u8981\u6dfb\u52a0\u5230map\u4e2d");
                    continue;
                }
                dataMap.put(column.name(), field.get(obj));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (isSave) {
            tableMap.put(tableName.name(), dataMap);
            saveOrUpdateDataCommand = new SaveOrUpdateDataCommand(tableMap);
            this.baseMysqlCRUDMapper.save(saveOrUpdateDataCommand);
            return saveOrUpdateDataCommand.getId();
        }
        dataMap.put(KEYFIELDMAP, keyFieldMap);
        tableMap.put(tableName.name(), dataMap);
        saveOrUpdateDataCommand = new SaveOrUpdateDataCommand(tableMap);
        this.baseMysqlCRUDMapper.update(saveOrUpdateDataCommand);
        return updateId;
    }

    private <T> Field[] getAllFields(T obj) {
        Field[] declaredFields = obj.getClass().getDeclaredFields();
        declaredFields = this.recursionParents(obj.getClass(), declaredFields);
        return declaredFields;
    }

    @Override
    public <T> void delete(T obj) {
        Table tableName = obj.getClass().getAnnotation(Table.class);
        if (tableName == null || tableName.name() == null || tableName.name() == "") {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            return;
        }
        Field[] declaredFields = this.getAllFields(obj);
        HashMap<Object, Map<Object, Object>> tableMap = new HashMap<Object, Map<Object, Object>>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            Column column = field.getAnnotation(Column.class);
            if (column == null) {
                log.info("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                continue;
            }
            try {
                dataMap.put(column.name(), field.get(obj));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        tableMap.put(tableName.name(), dataMap);
        this.baseMysqlCRUDMapper.delete(tableMap);
    }

    @Override
    public <T> PageResultCommand<T> query(T obj) {
        String startKey = "start";
        String sizeKey = "pageSize";
        String currentPageKey = "currentPage";
        String orderFieldKey = "orderField";
        String sortKey = "sortStr";
        Integer startVal = null;
        Integer sizeVal = null;
        Integer currentPageVal = null;
        String orderFieldVal = null;
        String sortVal = null;
        PageResultCommand pageResultCommand = new PageResultCommand();
        Table tableName = obj.getClass().getAnnotation(Table.class);
        if (tableName == null || tableName.name() == null || tableName.name() == "") {
            log.error("\u5fc5\u987b\u4f7f\u7528model\u4e2d\u7684\u5bf9\u8c61\uff01");
            return pageResultCommand;
        }
        Field[] declaredFields = this.getAllFields(obj);
        HashMap<Object, Object> tableMap = new HashMap<Object, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (Field field : declaredFields) {
            try {
                Column column;
                field.setAccessible(true);
                if (startKey.equals(field.getName())) {
                    startVal = (Integer)field.get(obj);
                }
                if (sizeKey.equals(field.getName())) {
                    sizeVal = (Integer)field.get(obj);
                }
                if (currentPageKey.equals(field.getName())) {
                    currentPageVal = (Integer)field.get(obj);
                }
                if (orderFieldKey.equals(field.getName())) {
                    orderFieldVal = (String)field.get(obj);
                }
                if (sortKey.equals(field.getName())) {
                    sortVal = (String)field.get(obj);
                }
                if ((column = field.getAnnotation(Column.class)) == null) {
                    log.info("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                    continue;
                }
                if (field.get(obj) instanceof String && field.get(obj) != null && "".equals(field.get(obj))) {
                    dataMap.put(column.name(), null);
                    continue;
                }
                dataMap.put(column.name(), field.get(obj));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        tableMap.put(tableName.name(), dataMap);
        if (currentPageVal != null && currentPageVal > 0) {
            tableMap.put(startKey, startVal);
            tableMap.put(sizeKey, sizeVal);
        }
        if (orderFieldVal != null && orderFieldVal != "") {
            tableMap.put(orderFieldKey, orderFieldVal);
            tableMap.put(sortKey, sortVal);
        }
        List<Map<String, Object>> query = this.baseMysqlCRUDMapper.query(tableMap);
        ArrayList list = new ArrayList();
        try {
            for (Map<String, Object> map : query) {
                Field[] declaredFields2;
                Object newInstance = obj.getClass().newInstance();
                for (Field field : declaredFields2 = newInstance.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    Column column = field.getAnnotation(Column.class);
                    if (column == null) {
                        log.info("\u8be5field\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u4e0d\u662f\u8868\u4e2d\u5728\u5b57\u6bb5\uff01");
                        continue;
                    }
                    String name = column.name();
                    field.set(newInstance, map.get(name));
                }
                list.add(newInstance);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (null != list) {
            pageResultCommand.setData(list);
            int queryCount = this.baseMysqlCRUDMapper.queryCount(tableMap);
            pageResultCommand.setRecordsFiltered(queryCount);
            pageResultCommand.setRecordsTotal(queryCount);
        }
        return pageResultCommand;
    }

    private Field[] recursionParents(Class<?> clas, Field[] fields) {
        if (clas.getSuperclass() != null) {
            Class<?> clsSup = clas.getSuperclass();
            fields = (Field[])ArrayUtils.addAll((Object[])fields, (Object[])clsSup.getDeclaredFields());
            fields = this.recursionParents(clsSup, fields);
        }
        return fields;
    }
}

