/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.sunchenbin.mybatis.actable.manager.system;

import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import com.gitee.sunchenbin.mybatis.actable.annotation.LengthCount;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import com.gitee.sunchenbin.mybatis.actable.command.CreateTableParam;
import com.gitee.sunchenbin.mybatis.actable.command.SysMysqlColumns;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlTypeConstant;
import com.gitee.sunchenbin.mybatis.actable.dao.system.CreateMysqlTablesMapper;
import com.gitee.sunchenbin.mybatis.actable.manager.system.SysMysqlCreateTableManager;
import com.gitee.sunchenbin.mybatis.actable.utils.ClassTools;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="sysMysqlCreateTableManager")
public class SysMysqlCreateTableManagerImpl
implements SysMysqlCreateTableManager {
    private static final Logger log = LoggerFactory.getLogger(SysMysqlCreateTableManagerImpl.class);
    @Autowired
    private CreateMysqlTablesMapper createMysqlTablesMapper;
    @Value(value="#{configProperties['mybatis.model.pack']}")
    private String pack;
    @Value(value="#{configProperties['mybatis.table.auto']}")
    private String tableAuto;

    @Override
    public void createMysqlTable() {
        if ("none".equals(this.tableAuto)) {
            log.info("\u914d\u7f6emybatis.table.auto=none\uff0c\u4e0d\u9700\u8981\u505a\u4efb\u4f55\u4e8b\u60c5");
            return;
        }
        Map<String, Object> mySqlTypeAndLengthMap = this.mySqlTypeAndLengthMap();
        Set<Class<?>> classes = ClassTools.getClasses(this.pack);
        HashMap<String, List<Object>> newTableMap = new HashMap<String, List<Object>>();
        HashMap<String, List<Object>> modifyTableMap = new HashMap<String, List<Object>>();
        HashMap<String, List<Object>> addTableMap = new HashMap<String, List<Object>>();
        HashMap<String, List<Object>> removeTableMap = new HashMap<String, List<Object>>();
        HashMap<String, List<Object>> dropKeyTableMap = new HashMap<String, List<Object>>();
        HashMap<String, List<Object>> dropUniqueTableMap = new HashMap<String, List<Object>>();
        this.allTableMapConstruct(mySqlTypeAndLengthMap, classes, newTableMap, modifyTableMap, addTableMap, removeTableMap, dropKeyTableMap, dropUniqueTableMap);
        this.createOrModifyTableConstruct(newTableMap, modifyTableMap, addTableMap, removeTableMap, dropKeyTableMap, dropUniqueTableMap);
    }

    private void allTableMapConstruct(Map<String, Object> mySqlTypeAndLengthMap, Set<Class<?>> classes, Map<String, List<Object>> newTableMap, Map<String, List<Object>> modifyTableMap, Map<String, List<Object>> addTableMap, Map<String, List<Object>> removeTableMap, Map<String, List<Object>> dropKeyTableMap, Map<String, List<Object>> dropUniqueTableMap) {
        for (Class<?> clas : classes) {
            int exist;
            Table table = clas.getAnnotation(Table.class);
            if (null == table) continue;
            ArrayList<Object> newFieldList = new ArrayList<Object>();
            ArrayList<Object> removeFieldList = new ArrayList<Object>();
            ArrayList<Object> addFieldList = new ArrayList<Object>();
            ArrayList<Object> modifyFieldList = new ArrayList<Object>();
            ArrayList<Object> dropKeyFieldList = new ArrayList<Object>();
            ArrayList<Object> dropUniqueFieldList = new ArrayList<Object>();
            this.tableFieldsConstruct(mySqlTypeAndLengthMap, clas, newFieldList);
            if ("create".equals(this.tableAuto)) {
                this.createMysqlTablesMapper.dorpTableByName(table.name());
            }
            if ((exist = this.createMysqlTablesMapper.findTableCountByTableName(table.name())) == 0) {
                newTableMap.put(table.name(), newFieldList);
                continue;
            }
            List<SysMysqlColumns> tableColumnList = this.createMysqlTablesMapper.findTableEnsembleByTableName(table.name());
            List<String> columnNames = ClassTools.getPropertyValueList(tableColumnList, "column_name");
            this.buildAddAndRemoveAndModifyFields(mySqlTypeAndLengthMap, modifyTableMap, addTableMap, removeTableMap, dropKeyTableMap, dropUniqueTableMap, table, newFieldList, removeFieldList, addFieldList, modifyFieldList, dropKeyFieldList, dropUniqueFieldList, tableColumnList, columnNames);
        }
    }

    private void buildAddAndRemoveAndModifyFields(Map<String, Object> mySqlTypeAndLengthMap, Map<String, List<Object>> modifyTableMap, Map<String, List<Object>> addTableMap, Map<String, List<Object>> removeTableMap, Map<String, List<Object>> dropKeyTableMap, Map<String, List<Object>> dropUniqueTableMap, Table table, List<Object> newFieldList, List<Object> removeFieldList, List<Object> addFieldList, List<Object> modifyFieldList, List<Object> dropKeyFieldList, List<Object> dropUniqueFieldList, List<SysMysqlColumns> tableColumnList, List<String> columnNames) {
        this.buildNewFields(addTableMap, table, newFieldList, addFieldList, columnNames);
        HashMap<String, CreateTableParam> fieldMap = new HashMap<String, CreateTableParam>();
        for (Object obj : newFieldList) {
            CreateTableParam createTableParam = (CreateTableParam)obj;
            fieldMap.put(createTableParam.getFieldName(), createTableParam);
        }
        this.buildRemoveFields(removeTableMap, table, removeFieldList, columnNames, fieldMap);
        this.buildModifyFields(mySqlTypeAndLengthMap, modifyTableMap, dropKeyTableMap, dropUniqueTableMap, table, modifyFieldList, dropKeyFieldList, dropUniqueFieldList, tableColumnList, fieldMap);
    }

    private void buildModifyFields(Map<String, Object> mySqlTypeAndLengthMap, Map<String, List<Object>> modifyTableMap, Map<String, List<Object>> dropKeyTableMap, Map<String, List<Object>> dropUniqueTableMap, Table table, List<Object> modifyFieldList, List<Object> dropKeyFieldList, List<Object> dropUniqueFieldList, List<SysMysqlColumns> tableColumnList, Map<String, CreateTableParam> fieldMap) {
        for (SysMysqlColumns sysColumn : tableColumnList) {
            CreateTableParam createTableParam = fieldMap.get(sysColumn.getColumn_name());
            if (createTableParam == null) continue;
            if ("PRI".equals(sysColumn.getColumn_key()) && !createTableParam.isFieldIsKey()) {
                dropKeyFieldList.add(createTableParam);
            }
            if ("UNI".equals(sysColumn.getColumn_key()) && !createTableParam.isFieldIsUnique()) {
                dropUniqueFieldList.add(createTableParam);
            }
            if (!sysColumn.getData_type().toLowerCase().equals(createTableParam.getFieldType().toLowerCase())) {
                modifyFieldList.add(createTableParam);
                continue;
            }
            int length = (Integer)mySqlTypeAndLengthMap.get(createTableParam.getFieldType().toLowerCase());
            String typeAndLength = createTableParam.getFieldType().toLowerCase();
            if (length == 1) {
                typeAndLength = typeAndLength + "(" + createTableParam.getFieldLength() + ")";
            } else if (length == 2) {
                typeAndLength = typeAndLength + "(" + createTableParam.getFieldLength() + "," + createTableParam.getFieldDecimalLength() + ")";
            }
            if (!sysColumn.getColumn_type().toLowerCase().equals(typeAndLength)) {
                modifyFieldList.add(createTableParam);
                continue;
            }
            if (!"PRI".equals(sysColumn.getColumn_key()) && createTableParam.isFieldIsKey()) {
                modifyFieldList.add(createTableParam);
                continue;
            }
            if ("auto_increment".equals(sysColumn.getExtra()) && !createTableParam.isFieldIsAutoIncrement()) {
                modifyFieldList.add(createTableParam);
                continue;
            }
            if (sysColumn.getColumn_default() == null || sysColumn.getColumn_default().equals("")) {
                if (!"NULL".equals(createTableParam.getFieldDefaultValue())) {
                    modifyFieldList.add(createTableParam);
                    continue;
                }
            } else if (!sysColumn.getColumn_default().equals(createTableParam.getFieldDefaultValue())) {
                modifyFieldList.add(createTableParam);
                continue;
            }
            if (sysColumn.getIs_nullable().equals("NO") && !createTableParam.isFieldIsKey()) {
                if (createTableParam.isFieldIsNull()) {
                    modifyFieldList.add(createTableParam);
                    continue;
                }
            } else if (sysColumn.getIs_nullable().equals("YES") && !createTableParam.isFieldIsKey() && !createTableParam.isFieldIsNull()) {
                modifyFieldList.add(createTableParam);
                continue;
            }
            if ("UNI".equals(sysColumn.getColumn_key()) || !createTableParam.isFieldIsUnique()) continue;
            modifyFieldList.add(createTableParam);
        }
        if (modifyFieldList.size() > 0) {
            modifyTableMap.put(table.name(), modifyFieldList);
        }
        if (dropKeyFieldList.size() > 0) {
            dropKeyTableMap.put(table.name(), dropKeyFieldList);
        }
        if (dropUniqueFieldList.size() > 0) {
            dropUniqueTableMap.put(table.name(), dropUniqueFieldList);
        }
    }

    private void buildRemoveFields(Map<String, List<Object>> removeTableMap, Table table, List<Object> removeFieldList, List<String> columnNames, Map<String, CreateTableParam> fieldMap) {
        for (String fieldNm : columnNames) {
            if (fieldMap.get(fieldNm) != null) continue;
            removeFieldList.add(fieldNm);
        }
        if (removeFieldList.size() > 0) {
            removeTableMap.put(table.name(), removeFieldList);
        }
    }

    private void buildNewFields(Map<String, List<Object>> addTableMap, Table table, List<Object> newFieldList, List<Object> addFieldList, List<String> columnNames) {
        for (Object obj : newFieldList) {
            CreateTableParam createTableParam = (CreateTableParam)obj;
            if (columnNames.contains(createTableParam.getFieldName())) continue;
            addFieldList.add(obj);
        }
        if (addFieldList.size() > 0) {
            addTableMap.put(table.name(), addFieldList);
        }
    }

    private void tableFieldsConstruct(Map<String, Object> mySqlTypeAndLengthMap, Class<?> clas, List<Object> newFieldList) {
        Field[] fields = clas.getDeclaredFields();
        for (Field field : fields = this.recursionParents(clas, fields)) {
            boolean hasAnnotation = field.isAnnotationPresent(Column.class);
            if (!hasAnnotation) continue;
            Column column = field.getAnnotation(Column.class);
            CreateTableParam param = new CreateTableParam();
            param.setFieldName(column.name());
            param.setFieldType(column.type().toLowerCase());
            param.setFieldLength(column.length());
            param.setFieldDecimalLength(column.decimalLength());
            if (column.isKey() || column.isUnique()) {
                param.setFieldIsNull(false);
            } else {
                param.setFieldIsNull(column.isNull());
            }
            param.setFieldIsKey(column.isKey());
            param.setFieldIsAutoIncrement(column.isAutoIncrement());
            param.setFieldDefaultValue(column.defaultValue());
            param.setFieldIsUnique(column.isUnique());
            int length = (Integer)mySqlTypeAndLengthMap.get(column.type().toLowerCase());
            param.setFileTypeLength(length);
            newFieldList.add(param);
        }
    }

    private Field[] recursionParents(Class<?> clas, Field[] fields) {
        if (clas.getSuperclass() != null) {
            Class<?> clsSup = clas.getSuperclass();
            fields = (Field[])ArrayUtils.addAll((Object[])fields, (Object[])clsSup.getDeclaredFields());
            fields = this.recursionParents(clsSup, fields);
        }
        return fields;
    }

    private void createOrModifyTableConstruct(Map<String, List<Object>> newTableMap, Map<String, List<Object>> modifyTableMap, Map<String, List<Object>> addTableMap, Map<String, List<Object>> removeTableMap, Map<String, List<Object>> dropKeyTableMap, Map<String, List<Object>> dropUniqueTableMap) {
        this.createTableByMap(newTableMap);
        this.dropFieldsKeyByMap(dropKeyTableMap);
        this.dropFieldsUniqueByMap(dropUniqueTableMap);
        this.addFieldsByMap(addTableMap);
        this.removeFieldsByMap(removeTableMap);
        this.modifyFieldsByMap(modifyTableMap);
    }

    private void modifyFieldsByMap(Map<String, List<Object>> modifyTableMap) {
        if (modifyTableMap.size() > 0) {
            for (Map.Entry<String, List<Object>> entry : modifyTableMap.entrySet()) {
                for (Object obj : entry.getValue()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(entry.getKey(), obj);
                    CreateTableParam fieldProperties = (CreateTableParam)obj;
                    log.info("\u5f00\u59cb\u4fee\u6539\u8868" + entry.getKey() + "\u4e2d\u7684\u5b57\u6bb5" + fieldProperties.getFieldName());
                    this.createMysqlTablesMapper.modifyTableField(map);
                    log.info("\u5b8c\u6210\u4fee\u6539\u8868" + entry.getKey() + "\u4e2d\u7684\u5b57\u6bb5" + fieldProperties.getFieldName());
                }
            }
        }
    }

    private void removeFieldsByMap(Map<String, List<Object>> removeTableMap) {
        if (removeTableMap.size() > 0) {
            for (Map.Entry<String, List<Object>> entry : removeTableMap.entrySet()) {
                for (Object obj : entry.getValue()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(entry.getKey(), obj);
                    String fieldName = (String)obj;
                    log.info("\u5f00\u59cb\u5220\u9664\u8868" + entry.getKey() + "\u4e2d\u7684\u5b57\u6bb5" + fieldName);
                    this.createMysqlTablesMapper.removeTableField(map);
                    log.info("\u5b8c\u6210\u5220\u9664\u8868" + entry.getKey() + "\u4e2d\u7684\u5b57\u6bb5" + fieldName);
                }
            }
        }
    }

    private void addFieldsByMap(Map<String, List<Object>> addTableMap) {
        if (addTableMap.size() > 0) {
            for (Map.Entry<String, List<Object>> entry : addTableMap.entrySet()) {
                for (Object obj : entry.getValue()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(entry.getKey(), obj);
                    CreateTableParam fieldProperties = (CreateTableParam)obj;
                    log.info("\u5f00\u59cb\u4e3a\u8868" + entry.getKey() + "\u589e\u52a0\u5b57\u6bb5" + fieldProperties.getFieldName());
                    this.createMysqlTablesMapper.addTableField(map);
                    log.info("\u5b8c\u6210\u4e3a\u8868" + entry.getKey() + "\u589e\u52a0\u5b57\u6bb5" + fieldProperties.getFieldName());
                }
            }
        }
    }

    private void dropFieldsKeyByMap(Map<String, List<Object>> dropKeyTableMap) {
        if (dropKeyTableMap.size() > 0) {
            for (Map.Entry<String, List<Object>> entry : dropKeyTableMap.entrySet()) {
                for (Object obj : entry.getValue()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(entry.getKey(), obj);
                    CreateTableParam fieldProperties = (CreateTableParam)obj;
                    log.info("\u5f00\u59cb\u4e3a\u8868" + entry.getKey() + "\u5220\u9664\u4e3b\u952e" + fieldProperties.getFieldName());
                    this.createMysqlTablesMapper.dropKeyTableField(map);
                    log.info("\u5b8c\u6210\u4e3a\u8868" + entry.getKey() + "\u5220\u9664\u4e3b\u952e" + fieldProperties.getFieldName());
                }
            }
        }
    }

    private void dropFieldsUniqueByMap(Map<String, List<Object>> dropUniqueTableMap) {
        if (dropUniqueTableMap.size() > 0) {
            for (Map.Entry<String, List<Object>> entry : dropUniqueTableMap.entrySet()) {
                for (Object obj : entry.getValue()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(entry.getKey(), obj);
                    CreateTableParam fieldProperties = (CreateTableParam)obj;
                    log.info("\u5f00\u59cb\u4e3a\u8868" + entry.getKey() + "\u5220\u9664\u552f\u4e00\u7ea6\u675f" + fieldProperties.getFieldName());
                    this.createMysqlTablesMapper.dropUniqueTableField(map);
                    log.info("\u5b8c\u6210\u4e3a\u8868" + entry.getKey() + "\u5220\u9664\u552f\u4e00\u7ea6\u675f" + fieldProperties.getFieldName());
                    log.info("\u5f00\u59cb\u4fee\u6539\u8868" + entry.getKey() + "\u4e2d\u7684\u5b57\u6bb5" + fieldProperties.getFieldName());
                    this.createMysqlTablesMapper.modifyTableField(map);
                    log.info("\u5b8c\u6210\u4fee\u6539\u8868" + entry.getKey() + "\u4e2d\u7684\u5b57\u6bb5" + fieldProperties.getFieldName());
                }
            }
        }
    }

    private void createTableByMap(Map<String, List<Object>> newTableMap) {
        if (newTableMap.size() > 0) {
            for (Map.Entry<String, List<Object>> entry : newTableMap.entrySet()) {
                HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
                map.put(entry.getKey(), entry.getValue());
                log.info("\u5f00\u59cb\u521b\u5efa\u8868\uff1a" + entry.getKey());
                this.createMysqlTablesMapper.createTable(map);
                log.info("\u5b8c\u6210\u521b\u5efa\u8868\uff1a" + entry.getKey());
            }
        }
    }

    public Map<String, Object> mySqlTypeAndLengthMap() {
        Field[] fields = MySqlTypeConstant.class.getDeclaredFields();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields) {
            LengthCount lengthCount = field.getAnnotation(LengthCount.class);
            map.put(field.getName().toLowerCase(), lengthCount.LengthCount());
        }
        return map;
    }
}

