/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.support.expirekey;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import weixin.popular.support.ExpireKey;

public class JedisExpireKey
implements ExpireKey {
    private JedisPool pool;
    private static final String DEFAULT_VALUE = "";
    private String perfix = "WP_ExpireKey_";

    public JedisExpireKey() {
    }

    public JedisExpireKey(JedisPool pool) {
        this.pool = pool;
    }

    public void setPerfix(String perfix) {
        this.perfix = perfix;
    }

    public void setPool(JedisPool pool) {
        this.pool = pool;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean add(String key, int expire) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.set(this.perfix + key, DEFAULT_VALUE);
            jedis.expire(this.perfix + key, expire);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean add(String key) {
        return this.add(key, DEFAULT_EXPIRE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists(String key) {
        try (Jedis jedis = this.pool.getResource();){
            boolean bl = jedis.exists(this.perfix + key);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

