/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.jdbc;

import com.highgo.jdbc.jdbc.HGClobOutputStream;
import com.highgo.jdbc.jdbc.HGClobWriter;
import com.highgo.jdbc.util.GT;
import com.highgo.jdbc.util.PSQLException;
import com.highgo.jdbc.util.PSQLState;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HGClob
implements Clob {
    private String value;
    private long length = -1L;
    private boolean isClosed = false;

    public HGClob(String paramValue) {
        if (paramValue != null) {
            this.length = paramValue.length();
        }
        this.value = paramValue;
    }

    @Override
    public synchronized long length() throws SQLException {
        this.checkFreed();
        return this.length;
    }

    @Override
    public synchronized String getSubString(long pos, int length) throws SQLException {
        this.checkFreed();
        if (pos < 1L) {
            throw new PSQLException(GT.tr("The position can not less than 1.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("The data's length is invalid..", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (--pos > this.length) {
            pos = this.length;
        }
        if ((long)length > this.length - pos) {
            length = (int)(this.length - pos);
        }
        return this.value.substring((int)pos, (int)pos + length);
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        this.checkFreed();
        if (this.value == null) {
            return null;
        }
        StringReader returnReader = new StringReader(this.value);
        return returnReader;
    }

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        this.checkFreed();
        ByteArrayInputStream returnInputStream = null;
        try {
            returnInputStream = new ByteArrayInputStream(this.value.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(HGClob.class.getName()).log(Level.SEVERE, null, ex);
        }
        return returnInputStream;
    }

    @Override
    public synchronized long position(String searchstr, long start) throws SQLException {
        this.checkFreed();
        if (start < 1L) {
            throw new PSQLException(GT.tr("The position can not less than 1.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (searchstr == null) {
            return -1L;
        }
        int i = this.value.indexOf(searchstr, (int)(start - 1L));
        if (i != -1) {
            return i + 1;
        }
        return -1L;
    }

    @Override
    public synchronized long position(Clob searchstr, long start) throws SQLException {
        this.checkFreed();
        if (searchstr == null) {
            return -1L;
        }
        return this.position(searchstr.getSubString(1L, (int)searchstr.length()), start);
    }

    @Override
    public synchronized int setString(long pos, String str) throws SQLException {
        this.checkFreed();
        if (str == null) {
            throw new PSQLException(GT.tr("The value is null.", new Object[0]), PSQLState.DATA_ERROR);
        }
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public synchronized int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkFreed();
        if (str == null) {
            throw new PSQLException(GT.tr("The value is null.", new Object[0]), PSQLState.DATA_ERROR);
        }
        if (offset < 0 || (long)offset > this.length) {
            throw new PSQLException(GT.tr("Invlid offset parameter.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (len < 0 || len > str.length() - offset) {
            throw new PSQLException(GT.tr("Invlid length parameter.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (pos < 1L || pos > this.length + 1L) {
            throw new PSQLException(GT.tr("The position can not less than 1.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if ((long)len + --pos >= this.length) {
            if ((long)len + pos > Integer.MAX_VALUE) {
                throw new PSQLException(GT.tr("The data is too large.", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
            }
            StringBuilder newStr = new StringBuilder();
            newStr.append(this.value.substring(0, (int)pos));
            newStr.append(str.substring(offset, offset + len));
            this.value = newStr.toString();
        } else {
            StringBuilder newStr = new StringBuilder();
            newStr.append(this.value.substring(0, (int)pos));
            newStr.append(str.substring(offset, offset + len));
            newStr.append(this.value.substring(len + (int)pos));
            this.value = newStr.toString();
        }
        this.length = this.value.length();
        return len;
    }

    @Override
    public synchronized OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkFreed();
        if (pos < 1L) {
            throw new PSQLException(GT.tr("The position can not less than 1.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return new HGClobOutputStream(this, pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkFreed();
        if (pos < 1L) {
            throw new PSQLException(GT.tr("The position can not less than 1.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return new HGClobWriter(this, pos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkFreed();
        if (len < 0L) {
            throw new PSQLException(GT.tr("Invlid length parameter.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (len > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("The data is too large.", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (len < this.length) {
            this.value = this.value.substring(0, (int)len);
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        this.value = null;
        this.isClosed = true;
    }

    protected void checkFreed() throws SQLException {
        if (this.isClosed) {
            throw new PSQLException(GT.tr("free() was called on this LOB previously", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        if (this.value == null) {
            throw new PSQLException(GT.tr("Value of LOB may be null,please check it.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    @Override
    public synchronized Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkFreed();
        if (pos < 0L || pos > this.length - 1L) {
            throw new PSQLException(GT.tr("Invlid position parameter.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (length > this.length || pos + length > this.length) {
            throw new PSQLException(GT.tr("Invlid length parameter.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return new StringReader(this.value.substring((int)(--pos), (int)(pos + length)));
    }

    public String toString() {
        return this.value;
    }
}

