/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.RepeatableRequestEntity;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.HttpMethodReleaseInputStream;
import com.obs.services.internal.service.AbstractRequestConvertor;
import com.obs.services.internal.service.ObsMultipartObjectService;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AppendObjectRequest;
import com.obs.services.model.AppendObjectResult;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.ModifyObjectRequest;
import com.obs.services.model.ModifyObjectResult;
import com.obs.services.model.ObjectTagResult;
import com.obs.services.model.ObjectTaggingRequest;
import com.obs.services.model.RenameObjectRequest;
import com.obs.services.model.RenameObjectResult;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RestoreObjectResult;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.TruncateObjectRequest;
import com.obs.services.model.TruncateObjectResult;
import com.obs.services.model.symlink.GetSymlinkRequest;
import com.obs.services.model.symlink.GetSymlinkResult;
import com.obs.services.model.symlink.PutSymlinkRequest;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import shade.okhttp3.Response;

public abstract class ObsObjectService
extends ObsMultipartObjectService {
    private static final ILogger log = LoggerBuilder.getLogger(ObsObjectService.class);

    protected TruncateObjectResult truncateObjectImpl(TruncateObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TRUNCATE.getOriginalStringCode(), "");
        requestParameters.put("length", String.valueOf(request.getNewLength()));
        Map<String, String> headers = this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName()));
        NewTransResult transResult = this.transObjectRequest(request);
        transResult.setHeaders(headers);
        transResult.setParams(requestParameters);
        Response response = this.performRequest(transResult);
        TruncateObjectResult result = new TruncateObjectResult();
        this.setHeadersAndStatus(result, response);
        return result;
    }

    protected RenameObjectResult renameObjectImpl(RenameObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.RENAME.getOriginalStringCode(), "");
        requestParams.put("name", request.getNewObjectKey());
        Map<String, String> headers = this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName()));
        NewTransResult transResult = this.transObjectRequest(request);
        transResult.setParams(requestParams);
        transResult.setHeaders(headers);
        Response response = this.performRequest(transResult);
        RenameObjectResult result = new RenameObjectResult();
        this.setHeadersAndStatus(result, response);
        return result;
    }

    protected RestoreObjectRequest.RestoreObjectStatus restoreObjectImpl(RestoreObjectRequest restoreObjectRequest) throws ServiceException {
        RestoreObjectResult restoreObjectResult = this.restoreObjectV2Impl(restoreObjectRequest);
        return this.transRestoreObjectResultToRestoreObjectStatus(restoreObjectResult);
    }

    protected RestoreObjectResult restoreObjectV2Impl(RestoreObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.RESTORE.getOriginalStringCode(), "");
        if (request.getVersionId() != null) {
            requestParams.put("versionId", request.getVersionId());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        String xml = this.getIConvertor(request.getBucketName()).transRestoreObjectRequest(request);
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult transResult = this.transObjectRequest(request);
        transResult.setParams(requestParams);
        transResult.setHeaders(headers);
        transResult.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(transResult);
        RestoreObjectResult ret = new RestoreObjectResult(request.getBucketName(), request.getObjectKey(), request.getVersionId());
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppendObjectResult appendObjectImpl(AppendObjectRequest request) throws ServiceException {
        AppendObjectResult ret;
        AbstractRequestConvertor.TransResult result;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transAppendObjectRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(request.getBucketName(), result.getHeaders(), acl);
                NewTransResult newTransResult = this.transObjectRequestWithResult(result, request);
                response = this.performRequest(newTransResult);
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose()) {
                    RepeatableRequestEntity entity = (RepeatableRequestEntity)result.getBody();
                    ServiceUtils.closeStream(entity);
                }
            }
            String nextPosition = response.header(this.getIHeaders(request.getBucketName()).nextPositionHeader());
            ret = new AppendObjectResult(request.getBucketName(), request.getObjectKey(), response.header("ETag"), nextPosition != null ? Long.parseLong(nextPosition) : -1L, StorageClassEnum.getValueFromCode(response.header(this.getIHeaders(request.getBucketName()).storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey(), request.getIsIgnorePort()));
            this.setHeadersAndStatus(ret, response);
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        ret.setClientCalculatedCRC64(result.getCalculatedCrc64());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModifyObjectResult modifyObjectImpl(ModifyObjectRequest request) throws ServiceException {
        ModifyObjectResult ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            AbstractRequestConvertor.TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transModifyObjectRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(request.getBucketName(), result.getHeaders(), acl);
                NewTransResult newTransResult = this.transObjectRequestWithResult(result, request);
                response = this.performRequest(newTransResult);
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose() && result.getBody() instanceof Closeable) {
                    ServiceUtils.closeStream((Closeable)((Object)result.getBody()));
                }
            }
            ret = new ModifyObjectResult();
            this.setHeadersAndStatus(ret, response, request.isEncodeHeaders());
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    protected ObjectTagResult getObjectTaggingImpl(ObjectTaggingRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        if (request.getObjectVersionId() != null && !request.getObjectVersionId().equals("")) {
            requestParams.put("versionId", request.getObjectVersionId());
        }
        Response httpResponse = this.performRestGet(request.getBucketName(), request.getObjectKey(), requestParams, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        ObjectTagResult result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ObjectTagInfoHandler.class, false).getObjectTagInfo();
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected HeaderResponse setObjectTaggingImpl(ObjectTaggingRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        if (request.getObjectVersionId() != null && !request.getObjectVersionId().equals("")) {
            requestParams.put("versionId", request.getObjectVersionId());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        String xml = this.getIConvertor(request.getBucketName()).transObjectTagInfo(request.getObjectTagInfo());
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult result = this.transObjectRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected HeaderResponse deleteObjectTaggingImpl(ObjectTaggingRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        if (request.getObjectVersionId() != null && !request.getObjectVersionId().equals("")) {
            requestParams.put("versionId", request.getObjectVersionId());
        }
        Response response = this.performRestDelete(request.getBucketName(), request.getObjectKey(), requestParams, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        return this.build(response);
    }

    protected HeaderResponse putSymlinkImpl(PutSymlinkRequest request) throws ServiceException {
        Response response = this.performRequest(this.transPutSymlinkRequest(request));
        return this.build(response);
    }

    protected GetSymlinkResult getSymlinkImpl(GetSymlinkRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.SYM_LINK.getOriginalStringCode(), "");
        if (request.getVersionId() != null && !request.getVersionId().isEmpty()) {
            requestParams.put("versionId", request.getVersionId());
        }
        Response httpResponse = this.performRestGet(request.getBucketName(), request.getObjectKey(), requestParams, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        httpResponse.close();
        String symlinkHeader = httpResponse.header(this.getIHeaders(request.getBucketName()).headerPrefix() + "symlink-target");
        GetSymlinkResult getSymlinkResult = new GetSymlinkResult();
        this.setHeadersAndStatus(getSymlinkResult, httpResponse);
        getSymlinkResult.setSymlinkTarget(symlinkHeader);
        return getSymlinkResult;
    }
}

