/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.prettier.internal;

import com.hubspot.maven.plugins.prettier.internal.FileUtils;
import com.hubspot.maven.plugins.prettier.internal.NodeInstall;
import com.hubspot.maven.plugins.prettier.internal.OperatingSystemFamily;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class NodeDownloader {
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient();
    private final Optional<String> customDownloadUrl;
    private final Path installDirectory;
    private final Log log;

    public NodeDownloader(Optional<String> customDownloadUrl, Path installDirectory, Log log) {
        this.customDownloadUrl = customDownloadUrl;
        this.installDirectory = installDirectory;
        this.log = log;
    }

    public NodeInstall download(String version) throws MojoExecutionException, IOException {
        OperatingSystemFamily os = OperatingSystemFamily.current();
        this.log.debug((CharSequence)("Determined os: " + os));
        return this.download(version, os);
    }

    public NodeInstall download(String version, OperatingSystemFamily os) throws MojoExecutionException, IOException {
        Path targetDirectory = this.installDirectory.resolve(os.getNodeDirectoryName(version));
        if (Files.exists(targetDirectory, new LinkOption[0])) {
            this.log.debug((CharSequence)("Reusing cached node at: " + targetDirectory));
        } else {
            String downloadUrl = this.customDownloadUrl.orElseGet(() -> os.getNodeDownloadUrl(version));
            this.log.debug((CharSequence)("Downloading node from url: " + downloadUrl));
            Optional<Path> maybeNodeArchive = this.downloadToTmpFile(downloadUrl);
            if (!maybeNodeArchive.isPresent()) {
                Optional<OperatingSystemFamily> fallback = os.getFallback();
                if (fallback.isPresent()) {
                    return this.download(version, fallback.get());
                }
                throw new MojoExecutionException("Got 404 when trying to download node from: " + downloadUrl);
            }
            Path nodeArchive = maybeNodeArchive.get();
            this.log.debug((CharSequence)("Downloaded node to: " + nodeArchive));
            Path tmpDir = os.extractToTmpDir(this.installDirectory, nodeArchive);
            Files.delete(nodeArchive);
            this.log.debug((CharSequence)("Extracted node to: " + tmpDir));
            Path nodeDir = tmpDir.resolve(os.getNodeDirectoryName(version));
            if (os != OperatingSystemFamily.WINDOWS_X64) {
                NodeInstall nodeInstall = os.toNodeInstall(nodeDir);
                os.setGlobalPermissions(Paths.get(nodeInstall.getNodePath(), new String[0]));
            }
            FileUtils.move(nodeDir, targetDirectory);
            Files.delete(tmpDir);
            this.log.debug((CharSequence)("Moved node to: " + targetDirectory));
        }
        return os.toNodeInstall(targetDirectory);
    }

    private Optional<Path> downloadToTmpFile(String downloadUrl) throws MojoExecutionException, IOException {
        Request request = new Request.Builder().url(downloadUrl).build();
        try (Response response = HTTP_CLIENT.newCall(request).execute();){
            Optional<Path> optional;
            block17: {
                InputStream responseStream;
                block15: {
                    Optional<Path> optional2;
                    block16: {
                        responseStream = NodeDownloader.responseStream(response);
                        try {
                            if (response.code() != 404) break block15;
                            this.log.debug((CharSequence)("Got 404 when trying to download node from: " + downloadUrl));
                            optional2 = Optional.empty();
                            if (responseStream == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (responseStream != null) {
                                try {
                                    responseStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        responseStream.close();
                    }
                    return optional2;
                }
                if (!response.isSuccessful()) {
                    throw new MojoExecutionException("Got response code " + response.code() + " when trying to download node from: " + downloadUrl);
                }
                Path tempFile = Files.createTempFile(this.installDirectory, "node-", ".tmp", new FileAttribute[0]);
                Files.copy(responseStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
                tempFile.toFile().deleteOnExit();
                optional = Optional.of(tempFile);
                if (responseStream == null) break block17;
                responseStream.close();
            }
            return optional;
        }
    }

    private static InputStream responseStream(Response response) throws IOException {
        ResponseBody body = response.body();
        if (body == null) {
            throw new IOException("Null body returned for response: " + response);
        }
        return body.byteStream();
    }
}

