/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.internal;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.config.LogConfig;
import com.jayway.restassured.config.RestAssuredConfig;
import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.ResponseParserRegistrar;
import com.jayway.restassured.internal.ResponseSpecificationImpl;
import com.jayway.restassured.internal.assertion.AssertParameter;
import com.jayway.restassured.internal.log.LogRepository;
import com.jayway.restassured.internal.print.ResponsePrinter;
import com.jayway.restassured.internal.util.SafeExceptionRethrower;
import com.jayway.restassured.matcher.ResponseAwareMatcher;
import com.jayway.restassured.parsing.Parser;
import com.jayway.restassured.response.ExtractableResponse;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.response.ResponseBody;
import com.jayway.restassured.response.ResponseOptions;
import com.jayway.restassured.response.ValidatableResponseLogSpec;
import com.jayway.restassured.response.ValidatableResponseOptions;
import com.jayway.restassured.specification.Argument;
import com.jayway.restassured.specification.ResponseSpecification;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValidatableResponseOptionsImpl<T extends ValidatableResponseOptions<T, R>, R extends ResponseBody<R> & ResponseOptions<R>>
implements ValidatableResponseLogSpec<T, R> {
    private final ResponseSpecificationImpl responseSpec;
    private final ExtractableResponse<R> extractableResponse;
    protected final Response response;
    private final RestAssuredConfig config;

    public ValidatableResponseOptionsImpl(String contentType, ResponseParserRegistrar rpr, RestAssuredConfig config, Response response, ExtractableResponse<R> extractableResponse, LogRepository logRepository) {
        this.config = config == null ? RestAssuredConfig.config() : config;
        this.response = response;
        this.responseSpec = new ResponseSpecificationImpl(RestAssured.rootPath, contentType, RestAssured.responseSpecification, rpr, this.config, response, logRepository);
        this.extractableResponse = extractableResponse;
    }

    public T content(List<Argument> arguments, ResponseAwareMatcher<R> responseAwareMatcher) {
        return this.content(arguments, this.getMatcherFromResponseAwareMatcher(responseAwareMatcher), new Object[0]);
    }

    public T body(List<Argument> arguments, ResponseAwareMatcher<R> responseAwareMatcher) {
        return this.body(arguments, this.getMatcherFromResponseAwareMatcher(responseAwareMatcher), new Object[0]);
    }

    public T body(String key, List<Argument> arguments, ResponseAwareMatcher<R> responseAwareMatcher) {
        return this.body(key, arguments, this.getMatcherFromResponseAwareMatcher(responseAwareMatcher), new Object[0]);
    }

    public T body(String key, ResponseAwareMatcher<R> responseAwareMatcher) {
        AssertParameter.notNull(responseAwareMatcher, ResponseAwareMatcher.class);
        return this.body(key, this.getMatcherFromResponseAwareMatcher(responseAwareMatcher), new Object[0]);
    }

    public T content(String path, List<Argument> arguments, ResponseAwareMatcher<R> responseAwareMatcher) {
        AssertParameter.notNull(responseAwareMatcher, ResponseAwareMatcher.class);
        return this.content(path, arguments, this.getMatcherFromResponseAwareMatcher(responseAwareMatcher), new Object[0]);
    }

    public T content(String path, ResponseAwareMatcher<R> responseAwareMatcher) {
        AssertParameter.notNull(responseAwareMatcher, ResponseAwareMatcher.class);
        return this.content(path, this.getMatcherFromResponseAwareMatcher(responseAwareMatcher), new Object[0]);
    }

    public T content(Matcher<?> matcher, Matcher<?> ... additionalMatchers) {
        this.responseSpec.content((Matcher)matcher, (Matcher[])additionalMatchers);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T content(List<Argument> arguments, Matcher matcher, Object ... additionalKeyMatcherPairs) {
        this.responseSpec.content(arguments, matcher, additionalKeyMatcherPairs);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T content(String key, Matcher<?> matcher, Object ... additionalKeyMatcherPairs) {
        this.responseSpec.content(key, (Matcher)matcher, additionalKeyMatcherPairs);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T body(String path, List<Argument> arguments, Matcher matcher, Object ... additionalKeyMatcherPairs) {
        this.responseSpec.body(path, arguments, matcher, additionalKeyMatcherPairs);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T body(List<Argument> arguments, Matcher matcher, Object ... additionalKeyMatcherPairs) {
        this.responseSpec.body(arguments, matcher, additionalKeyMatcherPairs);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T statusCode(Matcher<? super Integer> expectedStatusCode) {
        this.responseSpec.statusCode(expectedStatusCode);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T statusCode(int expectedStatusCode) {
        this.responseSpec.statusCode(expectedStatusCode);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T statusLine(Matcher<? super String> expectedStatusLine) {
        this.responseSpec.statusLine(expectedStatusLine);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T statusLine(String expectedStatusLine) {
        this.responseSpec.statusLine(expectedStatusLine);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T headers(Map<String, ?> expectedHeaders) {
        this.responseSpec.headers((Map)expectedHeaders);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T headers(String firstExpectedHeaderName, Object firstExpectedHeaderValue, Object ... expectedHeaders) {
        this.responseSpec.headers(firstExpectedHeaderName, firstExpectedHeaderValue, expectedHeaders);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T header(String headerName, Matcher<?> expectedValueMatcher) {
        this.responseSpec.header(headerName, (Matcher)expectedValueMatcher);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T header(String headerName, String expectedValue) {
        this.responseSpec.header(headerName, expectedValue);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T cookies(Map<String, ?> expectedCookies) {
        this.responseSpec.cookies((Map)expectedCookies);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T cookie(String cookieName) {
        this.responseSpec.cookie(cookieName);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T cookies(String firstExpectedCookieName, Object firstExpectedCookieValue, Object ... expectedCookieNameValuePairs) {
        this.responseSpec.cookies(firstExpectedCookieName, firstExpectedCookieValue, expectedCookieNameValuePairs);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T cookie(String cookieName, Matcher<?> expectedValueMatcher) {
        this.responseSpec.cookie(cookieName, (Matcher)expectedValueMatcher);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T cookie(String cookieName, Object expectedValue) {
        this.responseSpec.cookie(cookieName, expectedValue);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T rootPath(String rootPath) {
        this.responseSpec.rootPath(rootPath);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T rootPath(String rootPath, List<Argument> arguments) {
        this.responseSpec.rootPath(rootPath, arguments);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T root(String rootPath, List<Argument> arguments) {
        this.responseSpec.root(rootPath, arguments);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T root(String rootPath) {
        this.responseSpec.root(rootPath);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T noRoot() {
        this.responseSpec.noRoot();
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T noRootPath() {
        this.responseSpec.noRootPath();
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T appendRoot(String pathToAppend) {
        this.responseSpec.appendRoot(pathToAppend);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T appendRoot(String pathToAppend, List<Argument> arguments) {
        this.responseSpec.appendRoot(pathToAppend, arguments);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T detachRoot(String pathToDetach) {
        this.responseSpec.detachRoot(pathToDetach);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T contentType(ContentType contentType) {
        this.responseSpec.contentType(contentType);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T contentType(String contentType) {
        this.responseSpec.contentType(contentType);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T contentType(Matcher<? super String> contentType) {
        this.responseSpec.contentType(contentType);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T body(Matcher<?> matcher, Matcher<?> ... additionalMatchers) {
        this.responseSpec.body((Matcher)matcher, (Matcher[])additionalMatchers);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T body(String path, Matcher<?> matcher, Object ... additionalKeyMatcherPairs) {
        this.responseSpec.body(path, (Matcher)matcher, additionalKeyMatcherPairs);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T content(String path, List<Argument> arguments, Matcher matcher, Object ... additionalKeyMatcherPairs) {
        this.responseSpec.content(path, arguments, matcher, additionalKeyMatcherPairs);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T and() {
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T using() {
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T assertThat() {
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T spec(ResponseSpecification responseSpecification) {
        return this.specification(responseSpecification);
    }

    public T specification(ResponseSpecification responseSpecification) {
        AssertParameter.notNull((Object)responseSpecification, ResponseSpecification.class);
        this.response.asString();
        if (responseSpecification instanceof ResponseSpecificationImpl) {
            ResponseSpecificationImpl impl = (ResponseSpecificationImpl)responseSpecification;
            LogConfig globalLogConfig = this.responseSpec.getConfig().getLogConfig();
            if (globalLogConfig.isLoggingOfRequestAndResponseIfValidationFailsEnabled()) {
                impl.setConfig(impl.getConfig().logConfig(globalLogConfig));
                impl.setLogRepository(this.responseSpec.getLogRepository());
            }
        }
        responseSpecification.validate(this.response);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T parser(String contentType, Parser parser) {
        this.responseSpec.parser(contentType, parser);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public T defaultParser(Parser parser) {
        this.responseSpec.defaultParser(parser);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public ExtractableResponse<R> extract() {
        return this.extractableResponse;
    }

    public ValidatableResponseLogSpec log() {
        return this;
    }

    @Override
    public T status() {
        return this.logResponse(LogDetail.STATUS);
    }

    @Override
    public T ifError() {
        if (this.response.statusCode() >= 400) {
            return this.logResponse(LogDetail.ALL);
        }
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    @Override
    public T ifStatusCodeIsEqualTo(int statusCode) {
        if (this.response.statusCode() == statusCode) {
            return this.logResponse(LogDetail.ALL);
        }
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    @Override
    public T ifStatusCodeMatches(Matcher<Integer> matcher) {
        AssertParameter.notNull(matcher, (String)"Matcher");
        if (matcher.matches((Object)this.response.statusCode())) {
            return this.logResponse(LogDetail.ALL);
        }
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    @Override
    public T body() {
        return this.logResponse(LogDetail.BODY);
    }

    @Override
    public T body(boolean shouldPrettyPrint) {
        return this.logResponse(LogDetail.BODY, shouldPrettyPrint);
    }

    @Override
    public T all() {
        return this.logResponse(LogDetail.ALL);
    }

    @Override
    public T all(boolean shouldPrettyPrint) {
        return this.logResponse(LogDetail.ALL, shouldPrettyPrint);
    }

    @Override
    public T everything() {
        return this.all();
    }

    @Override
    public T everything(boolean shouldPrettyPrint) {
        return this.all(shouldPrettyPrint);
    }

    @Override
    public T headers() {
        return this.logResponse(LogDetail.HEADERS);
    }

    @Override
    public T cookies() {
        return this.logResponse(LogDetail.COOKIES);
    }

    @Override
    public T ifValidationFails() {
        return this.ifValidationFails(LogDetail.ALL);
    }

    @Override
    public T ifValidationFails(LogDetail logDetail) {
        return this.ifValidationFails(logDetail, this.config.getLogConfig().isPrettyPrintingEnabled());
    }

    @Override
    public T ifValidationFails(LogDetail logDetail, boolean shouldPrettyPrint) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.responseSpec.getLogRepository().registerResponseLog(baos);
        return this.logResponse(logDetail, shouldPrettyPrint, ps);
    }

    private T logResponse(LogDetail logDetail) {
        return this.logResponse(logDetail, this.config.getLogConfig().isPrettyPrintingEnabled());
    }

    private T logResponse(LogDetail logDetail, boolean shouldPrettyPrint) {
        return this.logResponse(logDetail, shouldPrettyPrint, this.config.getLogConfig().defaultStream());
    }

    private T logResponse(LogDetail logDetail, boolean shouldPrettyPrint, PrintStream printStream) {
        ResponsePrinter.print(this.response, this.response, printStream, logDetail, shouldPrettyPrint);
        return (T)((ValidatableResponseOptions)((Object)this));
    }

    public abstract R originalResponse();

    private Matcher<?> getMatcherFromResponseAwareMatcher(ResponseAwareMatcher<R> responseAwareMatcher) {
        AssertParameter.notNull(responseAwareMatcher, ResponseAwareMatcher.class);
        try {
            return responseAwareMatcher.matcher(this.originalResponse());
        }
        catch (Exception e) {
            return (Matcher)SafeExceptionRethrower.safeRethrow(e);
        }
    }
}

