/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.codec.Base16;
import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.ScriptOutputType;
import com.lambdaworks.redis.SortArgs;
import com.lambdaworks.redis.ZStoreArgs;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.BooleanListOutput;
import com.lambdaworks.redis.output.BooleanOutput;
import com.lambdaworks.redis.output.ByteArrayOutput;
import com.lambdaworks.redis.output.DateOutput;
import com.lambdaworks.redis.output.DoubleOutput;
import com.lambdaworks.redis.output.IntegerOutput;
import com.lambdaworks.redis.output.KeyListOutput;
import com.lambdaworks.redis.output.KeyOutput;
import com.lambdaworks.redis.output.KeyValueOutput;
import com.lambdaworks.redis.output.MapOutput;
import com.lambdaworks.redis.output.MultiOutput;
import com.lambdaworks.redis.output.NestedMultiOutput;
import com.lambdaworks.redis.output.ScoredValueListOutput;
import com.lambdaworks.redis.output.StatusOutput;
import com.lambdaworks.redis.output.StringListOutput;
import com.lambdaworks.redis.output.ValueListOutput;
import com.lambdaworks.redis.output.ValueOutput;
import com.lambdaworks.redis.output.ValueSetOutput;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandOutput;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.ConnectionWatchdog;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class RedisAsyncConnection<K, V>
extends SimpleChannelUpstreamHandler {
    protected BlockingQueue<Command<K, V, ?>> queue;
    protected RedisCodec<K, V> codec;
    protected Channel channel;
    protected long timeout;
    protected TimeUnit unit;
    protected MultiOutput<K, V> multi;
    private String password;
    private int db;
    private boolean closed;

    public RedisAsyncConnection(BlockingQueue<Command<K, V, ?>> queue, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        this.queue = queue;
        this.codec = codec;
        this.timeout = timeout;
        this.unit = unit;
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    public Future<Long> append(K key, V value) {
        return this.dispatch(CommandType.APPEND, new IntegerOutput<K, V>(this.codec), key, value);
    }

    public String auth(String password) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(password);
        Command cmd = this.dispatch(CommandType.AUTH, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
        String status = (String)this.await(cmd, this.timeout, this.unit);
        if ("OK".equals(status)) {
            this.password = password;
        }
        return status;
    }

    public Future<String> bgrewriteaof() {
        return this.dispatch(CommandType.BGREWRITEAOF, new StatusOutput<K, V>(this.codec));
    }

    public Future<String> bgsave() {
        return this.dispatch(CommandType.BGSAVE, new StatusOutput<K, V>(this.codec));
    }

    public Future<Long> bitcount(K key) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key);
        return this.dispatch(CommandType.BITCOUNT, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Long> bitcount(K key, long start, long end) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.addKey(key).add(start).add(end);
        return this.dispatch(CommandType.BITCOUNT, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Long> bitopAnd(K destination, K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.add(CommandKeyword.AND).addKey(destination).addKeys(keys);
        return this.dispatch(CommandType.BITOP, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Long> bitopNot(K destination, K source) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.add(CommandKeyword.NOT).addKey(destination).addKey(source);
        return this.dispatch(CommandType.BITOP, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Long> bitopOr(K destination, K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.add(CommandKeyword.OR).addKey(destination).addKeys(keys);
        return this.dispatch(CommandType.BITOP, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Long> bitopXor(K destination, K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.add(CommandKeyword.XOR).addKey(destination).addKeys(keys);
        return this.dispatch(CommandType.BITOP, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<KeyValue<K, V>> blpop(long timeout, K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKeys(keys).add(timeout);
        return this.dispatch(CommandType.BLPOP, (CommandOutput)new KeyValueOutput<K, V>(this.codec), args);
    }

    public Future<KeyValue<K, V>> brpop(long timeout, K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKeys(keys).add(timeout);
        return this.dispatch(CommandType.BRPOP, (CommandOutput)new KeyValueOutput<K, V>(this.codec), args);
    }

    public Future<V> brpoplpush(long timeout, K source, K destination) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.addKey(source).addKey(destination).add(timeout);
        return this.dispatch(CommandType.BRPOPLPUSH, (CommandOutput)new ValueOutput<K, V>(this.codec), args);
    }

    public Future<K> clientGetname() {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.GETNAME);
        return this.dispatch(CommandType.CLIENT, (CommandOutput)new KeyOutput<K, V>(this.codec), args);
    }

    public Future<String> clientSetname(K name) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.SETNAME).addKey(name);
        return this.dispatch(CommandType.CLIENT, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<String> clientKill(String addr) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.KILL).add(addr);
        return this.dispatch(CommandType.CLIENT, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<String> clientList() {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.LIST);
        return this.dispatch(CommandType.CLIENT, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<List<String>> configGet(String parameter) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandType.GET).add(parameter);
        return this.dispatch(CommandType.CONFIG, (CommandOutput)new StringListOutput<K, V>(this.codec), args);
    }

    public Future<String> configResetstat() {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.RESETSTAT);
        return this.dispatch(CommandType.CONFIG, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<String> configSet(String parameter, String value) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandType.SET).add(parameter).add(value);
        return this.dispatch(CommandType.CONFIG, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<Long> dbsize() {
        return this.dispatch(CommandType.DBSIZE, new IntegerOutput<K, V>(this.codec));
    }

    public Future<String> debugObject(K key) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandType.OBJECT).addKey(key);
        return this.dispatch(CommandType.DEBUG, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<Long> decr(K key) {
        return this.dispatch(CommandType.DECR, new IntegerOutput<K, V>(this.codec), key);
    }

    public Future<Long> decrby(K key, long amount) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(amount);
        return this.dispatch(CommandType.DECRBY, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Long> del(K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKeys(keys);
        return this.dispatch(CommandType.DEL, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<String> discard() {
        this.multi = null;
        return this.dispatch(CommandType.DISCARD, new StatusOutput<K, V>(this.codec));
    }

    public Future<byte[]> dump(K key) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key);
        return this.dispatch(CommandType.DUMP, (CommandOutput)new ByteArrayOutput<K, V>(this.codec), args);
    }

    public Future<V> echo(V msg) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addValue(msg);
        return this.dispatch(CommandType.ECHO, (CommandOutput)new ValueOutput<K, V>(this.codec), args);
    }

    public <T> Future<T> eval(V script, ScriptOutputType type, K[] keys, V ... values) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.addValue(script).add(keys.length).addKeys(keys).addValues(values);
        CommandOutput<K, V, T> output = this.newScriptOutput(this.codec, type);
        return this.dispatch(CommandType.EVAL, output, args);
    }

    public <T> Future<T> evalsha(String digest, ScriptOutputType type, K[] keys, V ... values) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.add(digest).add(keys.length).addKeys(keys).addValues(values);
        CommandOutput<K, V, T> output = this.newScriptOutput(this.codec, type);
        return this.dispatch(CommandType.EVALSHA, output, args);
    }

    public Future<Boolean> exists(K key) {
        return this.dispatch(CommandType.EXISTS, new BooleanOutput<K, V>(this.codec), key);
    }

    public Future<Boolean> expire(K key, long seconds) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(seconds);
        return this.dispatch(CommandType.EXPIRE, (CommandOutput)new BooleanOutput<K, V>(this.codec), args);
    }

    public Future<Boolean> expireat(K key, Date timestamp) {
        return this.expireat(key, timestamp.getTime() / 1000L);
    }

    public Future<Boolean> expireat(K key, long timestamp) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(timestamp);
        return this.dispatch(CommandType.EXPIREAT, (CommandOutput)new BooleanOutput<K, V>(this.codec), args);
    }

    public Future<List<Object>> exec() {
        MultiOutput<K, V> multi = this.multi;
        this.multi = null;
        if (multi == null) {
            multi = new MultiOutput<K, V>(this.codec);
        }
        return this.dispatch(CommandType.EXEC, multi);
    }

    public Future<String> flushall() throws Exception {
        return this.dispatch(CommandType.FLUSHALL, new StatusOutput<K, V>(this.codec));
    }

    public Future<String> flushdb() throws Exception {
        return this.dispatch(CommandType.FLUSHDB, new StatusOutput<K, V>(this.codec));
    }

    public Future<V> get(K key) {
        return this.dispatch(CommandType.GET, new ValueOutput<K, V>(this.codec), key);
    }

    public Future<Long> getbit(K key, long offset) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(offset);
        return this.dispatch(CommandType.GETBIT, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<V> getrange(K key, long start, long end) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(start).add(end);
        return this.dispatch(CommandType.GETRANGE, (CommandOutput)new ValueOutput<K, V>(this.codec), args);
    }

    public Future<V> getset(K key, V value) {
        return this.dispatch(CommandType.GETSET, new ValueOutput<K, V>(this.codec), key, value);
    }

    public Future<Long> hdel(K key, K ... fields) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addKeys(fields);
        return this.dispatch(CommandType.HDEL, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Boolean> hexists(K key, K field) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addKey(field);
        return this.dispatch(CommandType.HEXISTS, (CommandOutput)new BooleanOutput<K, V>(this.codec), args);
    }

    public Future<V> hget(K key, K field) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addKey(field);
        return this.dispatch(CommandType.HGET, (CommandOutput)new ValueOutput<K, V>(this.codec), args);
    }

    public Future<Long> hincrby(K key, K field, long amount) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addKey(field).add(amount);
        return this.dispatch(CommandType.HINCRBY, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Double> hincrbyfloat(K key, K field, double amount) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addKey(field).add(amount);
        return this.dispatch(CommandType.HINCRBYFLOAT, (CommandOutput)new DoubleOutput<K, V>(this.codec), args);
    }

    public Future<Map<K, V>> hgetall(K key) {
        return this.dispatch(CommandType.HGETALL, new MapOutput<K, V>(this.codec), key);
    }

    public Future<List<K>> hkeys(K key) {
        return this.dispatch(CommandType.HKEYS, new KeyListOutput<K, V>(this.codec), key);
    }

    public Future<Long> hlen(K key) {
        return this.dispatch(CommandType.HLEN, new IntegerOutput<K, V>(this.codec), key);
    }

    public Future<List<V>> hmget(K key, K ... fields) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addKeys(fields);
        return this.dispatch(CommandType.HMGET, (CommandOutput)new ValueListOutput<K, V>(this.codec), args);
    }

    public Future<String> hmset(K key, Map<K, V> map) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(map);
        return this.dispatch(CommandType.HMSET, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<Boolean> hset(K key, K field, V value) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addKey(field).addValue(value);
        return this.dispatch(CommandType.HSET, (CommandOutput)new BooleanOutput<K, V>(this.codec), args);
    }

    public Future<Boolean> hsetnx(K key, K field, V value) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addKey(field).addValue(value);
        return this.dispatch(CommandType.HSETNX, (CommandOutput)new BooleanOutput<K, V>(this.codec), args);
    }

    public Future<List<V>> hvals(K key) {
        return this.dispatch(CommandType.HVALS, new ValueListOutput<K, V>(this.codec), key);
    }

    public Future<Long> incr(K key) {
        return this.dispatch(CommandType.INCR, new IntegerOutput<K, V>(this.codec), key);
    }

    public Future<Long> incrby(K key, long amount) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(amount);
        return this.dispatch(CommandType.INCRBY, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Double> incrbyfloat(K key, double amount) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(amount);
        return this.dispatch(CommandType.INCRBYFLOAT, (CommandOutput)new DoubleOutput<K, V>(this.codec), args);
    }

    public Future<String> info() {
        return this.dispatch(CommandType.INFO, new StatusOutput<K, V>(this.codec));
    }

    public Future<String> info(String section) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(section);
        return this.dispatch(CommandType.INFO, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<List<K>> keys(K pattern) {
        return this.dispatch(CommandType.KEYS, new KeyListOutput<K, V>(this.codec), pattern);
    }

    public Future<Date> lastsave() {
        return this.dispatch(CommandType.LASTSAVE, new DateOutput<K, V>(this.codec));
    }

    public Future<V> lindex(K key, long index) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(index);
        return this.dispatch(CommandType.LINDEX, (CommandOutput)new ValueOutput<K, V>(this.codec), args);
    }

    public Future<Long> linsert(K key, boolean before, V pivot, V value) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.addKey(key).add(before ? CommandKeyword.BEFORE : CommandKeyword.AFTER).addValue(pivot).addValue(value);
        return this.dispatch(CommandType.LINSERT, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Long> llen(K key) {
        return this.dispatch(CommandType.LLEN, new IntegerOutput<K, V>(this.codec), key);
    }

    public Future<V> lpop(K key) {
        return this.dispatch(CommandType.LPOP, new ValueOutput<K, V>(this.codec), key);
    }

    public Future<Long> lpush(K key, V ... values) {
        return this.dispatch(CommandType.LPUSH, (CommandOutput)new IntegerOutput<K, V>(this.codec), key, values);
    }

    public Future<Long> lpushx(K key, V value) {
        return this.dispatch(CommandType.LPUSHX, new IntegerOutput<K, V>(this.codec), key, value);
    }

    public Future<List<V>> lrange(K key, long start, long stop) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(start).add(stop);
        return this.dispatch(CommandType.LRANGE, (CommandOutput)new ValueListOutput<K, V>(this.codec), args);
    }

    public Future<Long> lrem(K key, long count, V value) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(count).addValue(value);
        return this.dispatch(CommandType.LREM, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<String> lset(K key, long index, V value) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(index).addValue(value);
        return this.dispatch(CommandType.LSET, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<String> ltrim(K key, long start, long stop) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(start).add(stop);
        return this.dispatch(CommandType.LTRIM, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<String> migrate(String host, int port, K key, int db, long timeout) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.add(host).add(port).addKey(key).add(db).add(timeout);
        return this.dispatch(CommandType.MIGRATE, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<List<V>> mget(K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKeys(keys);
        return this.dispatch(CommandType.MGET, (CommandOutput)new ValueListOutput<K, V>(this.codec), args);
    }

    public Future<Boolean> move(K key, int db) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(db);
        return this.dispatch(CommandType.MOVE, (CommandOutput)new BooleanOutput<K, V>(this.codec), args);
    }

    public Future<String> multi() {
        Command cmd = this.dispatch(CommandType.MULTI, new StatusOutput<K, V>(this.codec));
        this.multi = this.multi == null ? new MultiOutput<K, V>(this.codec) : this.multi;
        return cmd;
    }

    public Future<String> mset(Map<K, V> map) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(map);
        return this.dispatch(CommandType.MSET, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<Boolean> msetnx(Map<K, V> map) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(map);
        return this.dispatch(CommandType.MSETNX, (CommandOutput)new BooleanOutput<K, V>(this.codec), args);
    }

    public Future<String> objectEncoding(K key) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.ENCODING).addKey(key);
        return this.dispatch(CommandType.OBJECT, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<Long> objectIdletime(K key) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.IDLETIME).addKey(key);
        return this.dispatch(CommandType.OBJECT, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Long> objectRefcount(K key) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.REFCOUNT).addKey(key);
        return this.dispatch(CommandType.OBJECT, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Boolean> persist(K key) {
        return this.dispatch(CommandType.PERSIST, new BooleanOutput<K, V>(this.codec), key);
    }

    public Future<Boolean> pexpire(K key, long milliseconds) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(milliseconds);
        return this.dispatch(CommandType.PEXPIRE, (CommandOutput)new BooleanOutput<K, V>(this.codec), args);
    }

    public Future<Boolean> pexpireat(K key, Date timestamp) {
        return this.pexpireat(key, timestamp.getTime());
    }

    public Future<Boolean> pexpireat(K key, long timestamp) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(timestamp);
        return this.dispatch(CommandType.PEXPIREAT, (CommandOutput)new BooleanOutput<K, V>(this.codec), args);
    }

    public Future<String> ping() {
        return this.dispatch(CommandType.PING, new StatusOutput<K, V>(this.codec));
    }

    public Future<Long> pttl(K key) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key);
        return this.dispatch(CommandType.PTTL, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Long> publish(K channel, V message) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(channel).addValue(message);
        return this.dispatch(CommandType.PUBLISH, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<String> quit() {
        return this.dispatch(CommandType.QUIT, new StatusOutput<K, V>(this.codec));
    }

    public Future<V> randomkey() {
        return this.dispatch(CommandType.RANDOMKEY, new ValueOutput<K, V>(this.codec));
    }

    public Future<String> rename(K key, K newKey) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addKey(newKey);
        return this.dispatch(CommandType.RENAME, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<Boolean> renamenx(K key, K newKey) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addKey(newKey);
        return this.dispatch(CommandType.RENAMENX, (CommandOutput)new BooleanOutput<K, V>(this.codec), args);
    }

    public Future<String> restore(K key, long ttl, byte[] value) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(ttl).add(value);
        return this.dispatch(CommandType.RESTORE, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<V> rpop(K key) {
        return this.dispatch(CommandType.RPOP, new ValueOutput<K, V>(this.codec), key);
    }

    public Future<V> rpoplpush(K source, K destination) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(source).addKey(destination);
        return this.dispatch(CommandType.RPOPLPUSH, (CommandOutput)new ValueOutput<K, V>(this.codec), args);
    }

    public Future<Long> rpush(K key, V ... values) {
        return this.dispatch(CommandType.RPUSH, (CommandOutput)new IntegerOutput<K, V>(this.codec), key, values);
    }

    public Future<Long> rpushx(K key, V value) {
        return this.dispatch(CommandType.RPUSHX, new IntegerOutput<K, V>(this.codec), key, value);
    }

    public Future<Long> sadd(K key, V ... members) {
        return this.dispatch(CommandType.SADD, (CommandOutput)new IntegerOutput<K, V>(this.codec), key, members);
    }

    public Future<String> save() {
        return this.dispatch(CommandType.SAVE, new StatusOutput<K, V>(this.codec));
    }

    public Future<Long> scard(K key) {
        return this.dispatch(CommandType.SCARD, new IntegerOutput<K, V>(this.codec), key);
    }

    public Future<List<Boolean>> scriptExists(String ... digests) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandType.EXISTS);
        for (String sha : digests) {
            args.add(sha);
        }
        return this.dispatch(CommandType.SCRIPT, (CommandOutput)new BooleanListOutput<K, V>(this.codec), args);
    }

    public Future<String> scriptFlush() {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.FLUSH);
        return this.dispatch(CommandType.SCRIPT, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<String> scriptKill() {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.KILL);
        return this.dispatch(CommandType.SCRIPT, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<String> scriptLoad(V script) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.LOAD).addValue(script);
        return this.dispatch(CommandType.SCRIPT, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<Set<V>> sdiff(K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKeys(keys);
        return this.dispatch(CommandType.SDIFF, (CommandOutput)new ValueSetOutput<K, V>(this.codec), args);
    }

    public Future<Long> sdiffstore(K destination, K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(destination).addKeys(keys);
        return this.dispatch(CommandType.SDIFFSTORE, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public String select(int db) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(db);
        Command cmd = this.dispatch(CommandType.SELECT, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
        String status = (String)this.await(cmd, this.timeout, this.unit);
        if ("OK".equals(status)) {
            this.db = db;
        }
        return status;
    }

    public Future<String> set(K key, V value) {
        return this.dispatch(CommandType.SET, new StatusOutput<K, V>(this.codec), key, value);
    }

    public Future<Long> setbit(K key, long offset, int value) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(offset).add(value);
        return this.dispatch(CommandType.SETBIT, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<String> setex(K key, long seconds, V value) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(seconds).addValue(value);
        return this.dispatch(CommandType.SETEX, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<Boolean> setnx(K key, V value) {
        return this.dispatch(CommandType.SETNX, new BooleanOutput<K, V>(this.codec), key, value);
    }

    public Future<Long> setrange(K key, long offset, V value) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(offset).addValue(value);
        return this.dispatch(CommandType.SETRANGE, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    @Deprecated
    public void shutdown() {
        this.dispatch(CommandType.SHUTDOWN, new StatusOutput<K, V>(this.codec));
    }

    public void shutdown(boolean save) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        this.dispatch(CommandType.SHUTDOWN, (CommandOutput)new StatusOutput<K, V>(this.codec), save ? args.add(CommandType.SAVE) : args.add(CommandKeyword.NOSAVE));
    }

    public Future<Set<V>> sinter(K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKeys(keys);
        return this.dispatch(CommandType.SINTER, (CommandOutput)new ValueSetOutput<K, V>(this.codec), args);
    }

    public Future<Long> sinterstore(K destination, K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(destination).addKeys(keys);
        return this.dispatch(CommandType.SINTERSTORE, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Boolean> sismember(K key, V member) {
        return this.dispatch(CommandType.SISMEMBER, new BooleanOutput<K, V>(this.codec), key, member);
    }

    public Future<Boolean> smove(K source, K destination, V member) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(source).addKey(destination).addValue(member);
        return this.dispatch(CommandType.SMOVE, (CommandOutput)new BooleanOutput<K, V>(this.codec), args);
    }

    public Future<String> slaveof(String host, int port) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(host).add(port);
        return this.dispatch(CommandType.SLAVEOF, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<String> slaveofNoOne() {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.NO).add(CommandKeyword.ONE);
        return this.dispatch(CommandType.SLAVEOF, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<List<Object>> slowlogGet() {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandType.GET);
        return this.dispatch(CommandType.SLOWLOG, (CommandOutput)new NestedMultiOutput<K, V>(this.codec), args);
    }

    public Future<List<Object>> slowlogGet(int count) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandType.GET).add(count);
        return this.dispatch(CommandType.SLOWLOG, (CommandOutput)new NestedMultiOutput<K, V>(this.codec), args);
    }

    public Future<Long> slowlogLen() {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.LEN);
        return this.dispatch(CommandType.SLOWLOG, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<String> slowlogReset() {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).add(CommandKeyword.RESET);
        return this.dispatch(CommandType.SLOWLOG, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<Set<V>> smembers(K key) {
        return this.dispatch(CommandType.SMEMBERS, new ValueSetOutput<K, V>(this.codec), key);
    }

    public Future<List<V>> sort(K key) {
        return this.dispatch(CommandType.SORT, new ValueListOutput<K, V>(this.codec), key);
    }

    public Future<List<V>> sort(K key, SortArgs sortArgs) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key);
        sortArgs.build(args, null);
        return this.dispatch(CommandType.SORT, (CommandOutput)new ValueListOutput<K, V>(this.codec), args);
    }

    public Future<Long> sortStore(K key, SortArgs sortArgs, K destination) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key);
        sortArgs.build(args, destination);
        return this.dispatch(CommandType.SORT, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<V> spop(K key) {
        return this.dispatch(CommandType.SPOP, new ValueOutput<K, V>(this.codec), key);
    }

    public Future<V> srandmember(K key) {
        return this.dispatch(CommandType.SRANDMEMBER, new ValueOutput<K, V>(this.codec), key);
    }

    public Future<Set<V>> srandmember(K key, long count) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(count);
        return this.dispatch(CommandType.SRANDMEMBER, (CommandOutput)new ValueSetOutput<K, V>(this.codec), args);
    }

    public Future<Long> srem(K key, V ... members) {
        return this.dispatch(CommandType.SREM, (CommandOutput)new IntegerOutput<K, V>(this.codec), key, members);
    }

    public Future<Set<V>> sunion(K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKeys(keys);
        return this.dispatch(CommandType.SUNION, (CommandOutput)new ValueSetOutput<K, V>(this.codec), args);
    }

    public Future<Long> sunionstore(K destination, K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(destination).addKeys(keys);
        return this.dispatch(CommandType.SUNIONSTORE, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<String> sync() {
        return this.dispatch(CommandType.SYNC, new StatusOutput<K, V>(this.codec));
    }

    public Future<Long> strlen(K key) {
        return this.dispatch(CommandType.STRLEN, new IntegerOutput<K, V>(this.codec), key);
    }

    public Future<Long> ttl(K key) {
        return this.dispatch(CommandType.TTL, new IntegerOutput<K, V>(this.codec), key);
    }

    public Future<String> type(K key) {
        return this.dispatch(CommandType.TYPE, new StatusOutput<K, V>(this.codec), key);
    }

    public Future<String> watch(K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKeys(keys);
        return this.dispatch(CommandType.WATCH, (CommandOutput)new StatusOutput<K, V>(this.codec), args);
    }

    public Future<String> unwatch() {
        return this.dispatch(CommandType.UNWATCH, new StatusOutput<K, V>(this.codec));
    }

    public Future<Long> zadd(K key, double score, V member) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(score).addValue(member);
        return this.dispatch(CommandType.ZADD, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Long> zadd(K key, Object ... scoresAndValues) {
        CommandArgs<K, Object> args = new CommandArgs<K, V>(this.codec).addKey(key);
        for (int i = 0; i < scoresAndValues.length; i += 2) {
            args.add((Double)scoresAndValues[i]);
            args.addValue(scoresAndValues[i + 1]);
        }
        return this.dispatch(CommandType.ZADD, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Long> zcard(K key) {
        return this.dispatch(CommandType.ZCARD, new IntegerOutput<K, V>(this.codec), key);
    }

    public Future<Long> zcount(K key, double min, double max) {
        return this.zcount(key, this.string(min), this.string(max));
    }

    public Future<Long> zcount(K key, String min, String max) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(min).add(max);
        return this.dispatch(CommandType.ZCOUNT, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Double> zincrby(K key, double amount, K member) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(amount).addKey(member);
        return this.dispatch(CommandType.ZINCRBY, (CommandOutput)new DoubleOutput<K, V>(this.codec), args);
    }

    public Future<Long> zinterstore(K destination, K ... keys) {
        return this.zinterstore(destination, new ZStoreArgs(), keys);
    }

    public Future<Long> zinterstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(destination).add(keys.length).addKeys(keys);
        storeArgs.build(args);
        return this.dispatch(CommandType.ZINTERSTORE, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<List<V>> zrange(K key, long start, long stop) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(start).add(stop);
        return this.dispatch(CommandType.ZRANGE, (CommandOutput)new ValueListOutput<K, V>(this.codec), args);
    }

    public Future<List<ScoredValue<V>>> zrangeWithScores(K key, long start, long stop) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.addKey(key).add(start).add(stop).add(CommandKeyword.WITHSCORES);
        return this.dispatch(CommandType.ZRANGE, (CommandOutput)new ScoredValueListOutput<K, V>(this.codec), args);
    }

    public Future<List<V>> zrangebyscore(K key, double min, double max) {
        return this.zrangebyscore(key, this.string(min), this.string(max));
    }

    public Future<List<V>> zrangebyscore(K key, String min, String max) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(min).add(max);
        return this.dispatch(CommandType.ZRANGEBYSCORE, (CommandOutput)new ValueListOutput<K, V>(this.codec), args);
    }

    public Future<List<V>> zrangebyscore(K key, double min, double max, long offset, long count) {
        return this.zrangebyscore(key, this.string(min), this.string(max), offset, count);
    }

    public Future<List<V>> zrangebyscore(K key, String min, String max, long offset, long count) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.addKey(key).add(min).add(max).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.dispatch(CommandType.ZRANGEBYSCORE, (CommandOutput)new ValueListOutput<K, V>(this.codec), args);
    }

    public Future<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, double min, double max) {
        return this.zrangebyscoreWithScores(key, this.string(min), this.string(max));
    }

    public Future<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, String min, String max) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.addKey(key).add(min).add(max).add(CommandKeyword.WITHSCORES);
        return this.dispatch(CommandType.ZRANGEBYSCORE, (CommandOutput)new ScoredValueListOutput<K, V>(this.codec), args);
    }

    public Future<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, double min, double max, long offset, long count) {
        return this.zrangebyscoreWithScores(key, this.string(min), this.string(max), offset, count);
    }

    public Future<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, String min, String max, long offset, long count) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.addKey(key).add(min).add(max).add(CommandKeyword.WITHSCORES).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.dispatch(CommandType.ZRANGEBYSCORE, (CommandOutput)new ScoredValueListOutput<K, V>(this.codec), args);
    }

    public Future<Long> zrank(K key, V member) {
        return this.dispatch(CommandType.ZRANK, new IntegerOutput<K, V>(this.codec), key, member);
    }

    public Future<Long> zrem(K key, V ... members) {
        return this.dispatch(CommandType.ZREM, (CommandOutput)new IntegerOutput<K, V>(this.codec), key, members);
    }

    public Future<Long> zremrangebyrank(K key, long start, long stop) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(start).add(stop);
        return this.dispatch(CommandType.ZREMRANGEBYRANK, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<Long> zremrangebyscore(K key, double min, double max) {
        return this.zremrangebyscore(key, this.string(min), this.string(max));
    }

    public Future<Long> zremrangebyscore(K key, String min, String max) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(min).add(max);
        return this.dispatch(CommandType.ZREMRANGEBYSCORE, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public Future<List<V>> zrevrange(K key, long start, long stop) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(start).add(stop);
        return this.dispatch(CommandType.ZREVRANGE, (CommandOutput)new ValueListOutput<K, V>(this.codec), args);
    }

    public Future<List<ScoredValue<V>>> zrevrangeWithScores(K key, long start, long stop) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.addKey(key).add(start).add(stop).add(CommandKeyword.WITHSCORES);
        return this.dispatch(CommandType.ZREVRANGE, (CommandOutput)new ScoredValueListOutput<K, V>(this.codec), args);
    }

    public Future<List<V>> zrevrangebyscore(K key, double max, double min) {
        return this.zrevrangebyscore(key, this.string(max), this.string(min));
    }

    public Future<List<V>> zrevrangebyscore(K key, String max, String min) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).add(max).add(min);
        return this.dispatch(CommandType.ZREVRANGEBYSCORE, (CommandOutput)new ValueListOutput<K, V>(this.codec), args);
    }

    public Future<List<V>> zrevrangebyscore(K key, double max, double min, long offset, long count) {
        return this.zrevrangebyscore(key, this.string(max), this.string(min), offset, count);
    }

    public Future<List<V>> zrevrangebyscore(K key, String max, String min, long offset, long count) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.addKey(key).add(max).add(min).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.dispatch(CommandType.ZREVRANGEBYSCORE, (CommandOutput)new ValueListOutput<K, V>(this.codec), args);
    }

    public Future<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, double max, double min) {
        return this.zrevrangebyscoreWithScores(key, this.string(max), this.string(min));
    }

    public Future<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, String max, String min) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.addKey(key).add(max).add(min).add(CommandKeyword.WITHSCORES);
        return this.dispatch(CommandType.ZREVRANGEBYSCORE, (CommandOutput)new ScoredValueListOutput<K, V>(this.codec), args);
    }

    public Future<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, double max, double min, long offset, long count) {
        return this.zrevrangebyscoreWithScores(key, this.string(max), this.string(min), offset, count);
    }

    public Future<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, String max, String min, long offset, long count) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.addKey(key).add(max).add(min).add(CommandKeyword.WITHSCORES).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.dispatch(CommandType.ZREVRANGEBYSCORE, (CommandOutput)new ScoredValueListOutput<K, V>(this.codec), args);
    }

    public Future<Long> zrevrank(K key, V member) {
        return this.dispatch(CommandType.ZREVRANK, new IntegerOutput<K, V>(this.codec), key, member);
    }

    public Future<Double> zscore(K key, V member) {
        return this.dispatch(CommandType.ZSCORE, new DoubleOutput<K, V>(this.codec), key, member);
    }

    public Future<Long> zunionstore(K destination, K ... keys) {
        return this.zunionstore(destination, new ZStoreArgs(), keys);
    }

    public Future<Long> zunionstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec);
        args.addKey(destination).add(keys.length).addKeys(keys);
        storeArgs.build(args);
        return this.dispatch(CommandType.ZUNIONSTORE, (CommandOutput)new IntegerOutput<K, V>(this.codec), args);
    }

    public boolean awaitAll(Future<?> ... futures) {
        return this.awaitAll(this.timeout, this.unit, futures);
    }

    public boolean awaitAll(long timeout, TimeUnit unit, Future<?> ... futures) {
        boolean complete;
        try {
            long nanos = unit.toNanos(timeout);
            long time = System.nanoTime();
            for (Future<?> f : futures) {
                if (nanos < 0L) {
                    return false;
                }
                f.get(nanos, TimeUnit.NANOSECONDS);
                long now = System.nanoTime();
                nanos -= now - time;
                time = now;
            }
            complete = true;
        }
        catch (TimeoutException e) {
            complete = false;
        }
        catch (Exception e) {
            throw new RedisCommandInterruptedException(e);
        }
        return complete;
    }

    public synchronized void close() {
        if (!this.closed && this.channel != null) {
            ConnectionWatchdog watchdog = (ConnectionWatchdog)this.channel.getPipeline().get(ConnectionWatchdog.class);
            watchdog.setReconnect(false);
            this.closed = true;
            this.channel.close();
        }
    }

    public String digest(V script) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(this.codec.encodeValue(script));
            return new String(Base16.encode(md.digest(), false));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RedisException("JVM does not support SHA1");
        }
    }

    public synchronized void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        CommandArgs<K, V> args;
        this.channel = ctx.getChannel();
        ArrayList tmp = new ArrayList(this.queue.size() + 2);
        if (this.password != null) {
            args = new CommandArgs<K, V>(this.codec).add(this.password);
            tmp.add(new Command(CommandType.AUTH, new StatusOutput<K, V>(this.codec), args, false));
        }
        if (this.db != 0) {
            args = new CommandArgs<K, V>(this.codec).add(this.db);
            tmp.add(new Command(CommandType.SELECT, new StatusOutput<K, V>(this.codec), args, false));
        }
        tmp.addAll(this.queue);
        this.queue.clear();
        for (Command command : tmp) {
            if (command.isCancelled()) continue;
            this.queue.add(command);
            this.channel.write((Object)command);
        }
        tmp.clear();
    }

    public synchronized void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.closed) {
            for (Command command : this.queue) {
                command.getOutput().setError("Connection closed");
                command.complete();
            }
            this.queue.clear();
            this.queue = null;
            this.channel = null;
        }
    }

    public <T> Command<K, V, T> dispatch(CommandType type, CommandOutput<K, V, T> output) {
        return this.dispatch(type, output, (CommandArgs)null);
    }

    public <T> Command<K, V, T> dispatch(CommandType type, CommandOutput<K, V, T> output, K key) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key);
        return this.dispatch(type, output, args);
    }

    public <T> Command<K, V, T> dispatch(CommandType type, CommandOutput<K, V, T> output, K key, V value) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addValue(value);
        return this.dispatch(type, output, args);
    }

    public <T> Command<K, V, T> dispatch(CommandType type, CommandOutput<K, V, T> output, K key, V[] values) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addValues(values);
        return this.dispatch(type, output, args);
    }

    public synchronized <T> Command<K, V, T> dispatch(CommandType type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        Command<K, V, T> cmd = new Command<K, V, T>(type, output, args, this.multi != null);
        try {
            if (this.multi != null) {
                this.multi.add(cmd);
            }
            this.queue.put(cmd);
            if (this.channel != null) {
                this.channel.write(cmd);
            }
        }
        catch (NullPointerException e) {
            throw new RedisException("Connection is closed");
        }
        catch (InterruptedException e) {
            throw new RedisCommandInterruptedException(e);
        }
        return cmd;
    }

    public <T> T await(Command<K, V, T> cmd, long timeout, TimeUnit unit) {
        if (!cmd.await(timeout, unit)) {
            cmd.cancel(true);
            throw new RedisException("Command timed out");
        }
        CommandOutput<K, V, T> output = cmd.getOutput();
        if (output.hasError()) {
            throw new RedisException(output.getError());
        }
        return output.get();
    }

    protected <K, V, T> CommandOutput<K, V, T> newScriptOutput(RedisCodec<K, V> codec, ScriptOutputType type) {
        switch (type) {
            case BOOLEAN: {
                return new BooleanOutput<K, V>(codec);
            }
            case INTEGER: {
                return new IntegerOutput<K, V>(codec);
            }
            case STATUS: {
                return new StatusOutput<K, V>(codec);
            }
            case MULTI: {
                return new NestedMultiOutput<K, V>(codec);
            }
            case VALUE: {
                return new ValueOutput<K, V>(codec);
            }
        }
        throw new RedisException("Unsupported script output type");
    }

    public String string(double n) {
        if (Double.isInfinite(n)) {
            return n > 0.0 ? "+inf" : "-inf";
        }
        return Double.toString(n);
    }
}

