/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;
import java.util.ArrayList;
import java.util.List;

public class SortArgs {
    private String by;
    private Long offset;
    private Long count;
    private List<String> get;
    private CommandKeyword order;
    private boolean alpha;

    public SortArgs by(String pattern) {
        this.by = pattern;
        return this;
    }

    public SortArgs limit(long offset, long count) {
        this.offset = offset;
        this.count = count;
        return this;
    }

    public SortArgs get(String pattern) {
        if (this.get == null) {
            this.get = new ArrayList<String>();
        }
        this.get.add(pattern);
        return this;
    }

    public SortArgs asc() {
        this.order = CommandKeyword.ASC;
        return this;
    }

    public SortArgs desc() {
        this.order = CommandKeyword.DESC;
        return this;
    }

    public SortArgs alpha() {
        this.alpha = true;
        return this;
    }

    <K, V> void build(CommandArgs<K, V> args, K store) {
        if (this.by != null) {
            args.add(CommandKeyword.BY);
            args.add(this.by);
        }
        if (this.get != null) {
            for (String pattern : this.get) {
                args.add(CommandType.GET);
                args.add(pattern);
            }
        }
        if (this.offset != null) {
            args.add(CommandKeyword.LIMIT);
            args.add(this.offset);
            args.add(this.count);
        }
        if (this.order != null) {
            args.add(this.order);
        }
        if (this.alpha) {
            args.add(CommandKeyword.ALPHA);
        }
        if (store != null) {
            args.add(CommandKeyword.STORE);
            args.addKey(store);
        }
    }

    public static class Builder {
        public static SortArgs by(String pattern) {
            return new SortArgs().by(pattern);
        }

        public static SortArgs limit(long offset, long count) {
            return new SortArgs().limit(offset, count);
        }

        public static SortArgs get(String pattern) {
            return new SortArgs().get(pattern);
        }

        public static SortArgs asc() {
            return new SortArgs().asc();
        }

        public static SortArgs desc() {
            return new SortArgs().desc();
        }

        public static SortArgs alpha() {
            return new SortArgs().alpha();
        }
    }
}

