/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.CommandOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class NestedMultiOutput<K, V>
extends CommandOutput<K, V, List<Object>> {
    private LinkedList<List<Object>> stack = new LinkedList();
    private int depth = 1;

    public NestedMultiOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
    }

    @Override
    public void set(long integer) {
        ((List)this.output).add(integer);
    }

    @Override
    public void set(ByteBuffer bytes) {
        ((List)this.output).add(bytes == null ? null : (Object)this.codec.decodeValue(bytes));
    }

    @Override
    public void setError(ByteBuffer error) {
        ((List)this.output).add(new RedisException(this.decodeAscii(error)));
    }

    @Override
    public void complete(int depth) {
        if (depth > this.depth) {
            Object o = ((List)this.output).remove(((List)this.output).size() - 1);
            this.stack.push((List<Object>)this.output);
            this.output = new ArrayList();
            ((List)this.output).add(o);
        } else if (depth > 0 && depth < this.depth) {
            this.stack.peek().add(this.output);
            this.output = this.stack.pop();
        }
        this.depth = depth;
    }
}

