/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.CommandOutput;
import com.lambdaworks.redis.pubsub.PubSubOutput;
import java.util.concurrent.BlockingQueue;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;

public class PubSubCommandHandler<K, V>
extends CommandHandler<K, V> {
    private RedisCodec<K, V> codec;
    private PubSubOutput<K, V> output;

    public PubSubCommandHandler(BlockingQueue<Command<K, V, ?>> queue, RedisCodec<K, V> codec) {
        super(queue);
        this.codec = codec;
        this.output = new PubSubOutput<K, V>(codec);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ChannelBuffer buffer) throws InterruptedException {
        while (this.output.type() == null && !this.queue.isEmpty()) {
            CommandOutput output = ((Command)this.queue.peek()).getOutput();
            if (!this.rsm.decode(buffer, output)) {
                return;
            }
            ((Command)this.queue.take()).complete();
            if (!(output instanceof PubSubOutput)) continue;
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, output);
        }
        while (this.rsm.decode(buffer, this.output)) {
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, this.output);
            this.output = new PubSubOutput<K, V>(this.codec);
        }
    }
}

