/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.pubsub.PubSubOutput;
import com.lambdaworks.redis.pubsub.RedisPubSubListener;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;

public class RedisPubSubConnection<K, V>
extends RedisAsyncConnection<K, V> {
    private List<RedisPubSubListener<K, V>> listeners = new CopyOnWriteArrayList<RedisPubSubListener<K, V>>();
    private Set<K> channels = new HashSet<K>();
    private Set<K> patterns = new HashSet<K>();

    public RedisPubSubConnection(BlockingQueue<Command<K, V, ?>> queue, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        super(queue, codec, timeout, unit);
    }

    public void addListener(RedisPubSubListener<K, V> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.listeners.remove(listener);
    }

    public void psubscribe(K ... patterns) {
        this.dispatch(CommandType.PSUBSCRIBE, new PubSubOutput(this.codec), this.args(patterns));
    }

    public void punsubscribe(K ... patterns) {
        this.dispatch(CommandType.PUNSUBSCRIBE, new PubSubOutput(this.codec), this.args(patterns));
    }

    public void subscribe(K ... channels) {
        this.dispatch(CommandType.SUBSCRIBE, new PubSubOutput(this.codec), this.args(channels));
    }

    public void unsubscribe(K ... channels) {
        this.dispatch(CommandType.UNSUBSCRIBE, new PubSubOutput(this.codec), this.args(channels));
    }

    @Override
    public synchronized void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelConnected(ctx, e);
        if (this.channels.size() > 0) {
            this.subscribe(this.toArray(this.channels));
            this.channels.clear();
        }
        if (this.patterns.size() > 0) {
            this.psubscribe(this.toArray(this.patterns));
            this.patterns.clear();
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        PubSubOutput output = (PubSubOutput)e.getMessage();
        for (RedisPubSubListener redisPubSubListener : this.listeners) {
            switch (output.type()) {
                case message: {
                    redisPubSubListener.message(output.channel(), output.get());
                    break;
                }
                case pmessage: {
                    redisPubSubListener.message(output.pattern(), output.channel(), output.get());
                    break;
                }
                case psubscribe: {
                    this.patterns.add(output.pattern());
                    redisPubSubListener.psubscribed(output.pattern(), output.count());
                    break;
                }
                case punsubscribe: {
                    this.patterns.remove(output.pattern());
                    redisPubSubListener.punsubscribed(output.pattern(), output.count());
                    break;
                }
                case subscribe: {
                    this.channels.add(output.channel());
                    redisPubSubListener.subscribed(output.channel(), output.count());
                    break;
                }
                case unsubscribe: {
                    this.channels.remove(output.channel());
                    redisPubSubListener.unsubscribed(output.channel(), output.count());
                }
            }
        }
    }

    private CommandArgs<K, V> args(K ... keys) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKeys(keys);
        return args;
    }

    private <T> T[] toArray(Collection<T> c) {
        Class<?> cls = c.iterator().next().getClass();
        Object[] array = (Object[])Array.newInstance(cls, c.size());
        return c.toArray(array);
    }
}

