/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.loadbalancer;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledNIWSServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import com.netflix.niws.loadbalancer.Eureka2Clients;
import com.netflix.niws.loadbalancer.Eureka2EnabledNIWSServerList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class CompositeEurekaEnabledNIWSServerList
extends AbstractServerList<DiscoveryEnabledServer> {
    private DiscoveryEnabledNIWSServerList eureka1ServerList;
    private final AtomicReference<Eureka2EnabledNIWSServerList> eureka2ServerListRef = new AtomicReference();
    private IClientConfig clientConfig;

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.eureka1ServerList = new DiscoveryEnabledNIWSServerList();
        this.eureka1ServerList.initWithNiwsConfig(clientConfig);
    }

    public List<DiscoveryEnabledServer> getInitialListOfServers() {
        return this.loadListOfServers();
    }

    public List<DiscoveryEnabledServer> getUpdatedListOfServers() {
        return this.loadListOfServers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DiscoveryEnabledServer> loadListOfServers() {
        if (Eureka2Clients.isUseEureka2()) {
            if (this.eureka2ServerListRef.get() == null) {
                AtomicReference<Eureka2EnabledNIWSServerList> atomicReference = this.eureka2ServerListRef;
                synchronized (atomicReference) {
                    Eureka2EnabledNIWSServerList eureka2ServerList = new Eureka2EnabledNIWSServerList();
                    eureka2ServerList.initWithNiwsConfig(this.clientConfig);
                    this.eureka2ServerListRef.set(eureka2ServerList);
                }
            }
            return this.eureka2ServerListRef.get().getUpdatedListOfServers();
        }
        Eureka2EnabledNIWSServerList eureka2ServerList = this.eureka2ServerListRef.getAndSet(null);
        if (eureka2ServerList != null) {
            eureka2ServerList.shutdown();
        }
        return this.eureka1ServerList.getUpdatedListOfServers();
    }
}

