/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.Config;
import com.netflix.spectator.api.ConfigMap;
import com.netflix.spectator.api.DefaultRegistry;
import com.netflix.spectator.api.ExtendedRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.SystemConfigMap;
import com.netflix.spectator.api.Throwables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Spectator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Spectator.class);
    private static final ConfigMap CONFIG = Spectator.newConfigMapUsingServiceLoader();
    private static final CompositeRegistry COMPOSITE_REGISTRY = new CompositeRegistry(Clock.SYSTEM);
    private static final ExtendedRegistry REGISTRY = new ExtendedRegistry(COMPOSITE_REGISTRY);

    static ConfigMap newConfigMapUsingServiceLoader() {
        ServiceLoader<ConfigMap> loader = ServiceLoader.load(ConfigMap.class);
        Iterator<ConfigMap> cfgIterator = loader.iterator();
        if (cfgIterator.hasNext()) {
            ConfigMap cfg = cfgIterator.next();
            LOGGER.info("using config impl found in classpath: {}", (Object)cfg.getClass().getName());
            return cfg;
        }
        LOGGER.warn("no config impl found in classpath, using default");
        return new SystemConfigMap();
    }

    static void addRegistriesFromServiceLoader() {
        ClassLoader cl = Spectator.pickClassLoader();
        ServiceLoader<Registry> loader = ServiceLoader.load(Registry.class, cl);
        Iterator<Registry> registryIterator = loader.iterator();
        if (registryIterator.hasNext()) {
            StringBuilder desc = new StringBuilder();
            ArrayList<Registry> rs = new ArrayList<Registry>();
            while (registryIterator.hasNext()) {
                try {
                    Registry r = registryIterator.next();
                    desc.append(' ').append(r.getClass().getName());
                    rs.add(r);
                }
                catch (ServiceConfigurationError e) {
                    LOGGER.warn("failed to load registry, it will be skipped", (Throwable)e);
                }
            }
            if (rs.isEmpty()) {
                COMPOSITE_REGISTRY.add(new DefaultRegistry());
            } else {
                for (Registry r : rs) {
                    COMPOSITE_REGISTRY.add(r);
                }
                LOGGER.info("using registries found in classpath: {}", (Object)desc.toString());
            }
        } else {
            LOGGER.warn("no registry impl found in classpath, using default");
            COMPOSITE_REGISTRY.add(new DefaultRegistry());
        }
    }

    private static ClassLoader pickClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            LOGGER.info("Thread.currentThread().getContextClassLoader() is null, using Spectator.class.getClassLoader()");
            return Spectator.class.getClassLoader();
        }
        return cl;
    }

    static void addRegistryUsingClassName(String name) {
        try {
            Class<?> c = Class.forName(name);
            COMPOSITE_REGISTRY.add((Registry)c.newInstance());
        }
        catch (Exception e) {
            String msg = "failed to instantiate registry class '" + name + "', falling back to default implementation";
            Throwables.propagate(new RuntimeException(msg, e));
            COMPOSITE_REGISTRY.add(new DefaultRegistry());
        }
    }

    static void addRegistries(String name) {
        if ("service-loader".equals(name)) {
            Spectator.addRegistriesFromServiceLoader();
        } else {
            Spectator.addRegistryUsingClassName(name);
        }
    }

    public static ConfigMap config() {
        return CONFIG;
    }

    @Deprecated
    public static void initializeUsingServiceLoader() {
        Spectator.addRegistries(Config.registryClass());
    }

    @Deprecated
    public static ExtendedRegistry registry() {
        return REGISTRY;
    }

    public static CompositeRegistry globalRegistry() {
        return COMPOSITE_REGISTRY;
    }

    private Spectator() {
    }
}

