/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.infrastructure.invoker;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.shiji.infrastructure.businessobject.ServiceSession;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SpringContext {
    private static final ThreadLocal<ServiceSession> sessionThreadLocal = new InheritableThreadLocal<ServiceSession>();
    private static final ThreadLocal<Integer> pagenoThreadLocal = new InheritableThreadLocal<Integer>();
    private static final ThreadLocal<Integer> pageSizeThreadLocal = new InheritableThreadLocal<Integer>();
    private static Boolean initComplete = false;
    static ConfigurableApplicationContext context = null;
    static String applicationName;
    static String uniqueKey;
    static String eurekaValue;
    static String dataSourcekey;
    static String redisKey;
    static String eurekaKey;

    public static boolean isInitComplete() {
        return initComplete;
    }

    public static void setInitComplete(boolean initComplete) {
        SpringContext.initComplete = initComplete;
    }

    public static ServiceSession getSession() {
        ServiceSession session = sessionThreadLocal.get();
        if (session == null) {
            session = new ServiceSession();
            session.setEnt_id(0L);
            session.setUser_id(0L);
        }
        return session;
    }

    public static void putSession(ServiceSession session) {
        sessionThreadLocal.set(session);
    }

    public static void removeSession() {
        sessionThreadLocal.remove();
    }

    public static Integer getPageSize() {
        return pageSizeThreadLocal.get();
    }

    public static void putPageSize(int pageSize) {
        pageSizeThreadLocal.set(pageSize);
    }

    public static void removePageSize() {
        pageSizeThreadLocal.remove();
    }

    public static Integer getPageno() {
        return pagenoThreadLocal.get();
    }

    public static void putPageno(int pageStart) {
        pagenoThreadLocal.set(pageStart);
    }

    public static void removePageno() {
        pagenoThreadLocal.remove();
    }

    public static ConfigurableApplicationContext run(Class<?> primarySource, String ... args) {
        SpringApplication application = new SpringApplication(new Class[]{primarySource});
        JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.DisableCircularReferenceDetect.getMask();
        context = application.run(args);
        SpringContext.setInstance(context);
        SpringContext.setInitComplete(true);
        return context;
    }

    public static Object getBean(String name) {
        return SpringContext.getContext().getBean(name);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringContext.getContext().getBean(name, clazz);
    }

    public static Object getBean(String name, Object ... args) {
        return SpringContext.getContext().getBean(name, args);
    }

    public static <T> T getBean(Class<T> requiredType, Object ... args) {
        return (T)SpringContext.getContext().getBean(requiredType, args);
    }

    public static BeanFactory getContext() {
        return context;
    }

    public static synchronized void setInstance(ConfigurableApplicationContext myContext) {
        context = myContext;
    }

    public static String getActiveProfile() {
        if (context == null || context.getEnvironment() == null) {
            return "";
        }
        String[] activeProfiles = context.getEnvironment().getActiveProfiles();
        if (activeProfiles.length == 0) {
            return "default";
        }
        return context.getEnvironment().getActiveProfiles()[0];
    }

    public static ConfigurableEnvironment getEnvironment() {
        if (context == null) {
            return null;
        }
        return context.getEnvironment();
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes ra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ra.getRequest();
        return request;
    }

    public static String getEnvironmentVar(String name) {
        if (null != SpringContext.getEnvironment()) {
            return SpringContext.getEnvironment().getProperty(name);
        }
        return "";
    }
}

