/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.infrastructure.utils.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.base.Splitter;
import com.shiji.infrastructure.utils.rest.RestRequest;
import com.shiji.infrastructure.utils.rest.RestResponse;
import com.shiji.infrastructure.utils.string.ParserUtils;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class RestSender {
    private static final Logger log = LoggerFactory.getLogger(RestSender.class);
    private RestRequest request;

    public RestSender(RestRequest request) {
        this.request = request;
    }

    private String encode(String value) {
        try {
            String response = URLEncoder.encode(value, "UTF8");
            return response;
        }
        catch (Exception e) {
            return value;
        }
    }

    public RestResponse get(String remoteURL, Map<String, Object> paramsMap, boolean append) {
        return this.get(remoteURL, paramsMap, append, false);
    }

    public RestResponse get(String remoteURL) {
        return this.get(remoteURL, new HashMap<String, Object>());
    }

    public RestResponse get(String remoteURL, Map<String, Object> paramsMap) {
        return this.get(remoteURL, paramsMap, false, false);
    }

    public RestResponse get(String remoteURL, boolean generateCurl) {
        return this.get(remoteURL, new HashMap<String, Object>(), false, generateCurl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse get(String remoteURL, Map<String, Object> paramsMap, boolean append, boolean generateCurl) {
        ArrayList<String> dataList = new ArrayList<String>();
        LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
        Map<String, Object> requestMap = this.request.getParamsMap();
        if (!requestMap.isEmpty()) {
            requestMap.entrySet().stream().forEach(p -> {
                if (!paramsMap.containsKey(p.getKey())) {
                    String value = p.getValue() == null ? "" : p.getValue().toString();
                    paramsMap.put((String)p.getKey(), value);
                }
            });
        }
        String dataQuery = "";
        if (remoteURL.indexOf("{") >= 0 && remoteURL.indexOf("}") > 0) {
            int index = remoteURL.indexOf("?");
            dataQuery = remoteURL.substring(index + 1);
        } else {
            URI modifiedUri = URI.create(remoteURL);
            dataQuery = modifiedUri.getQuery();
        }
        Map dataMap = !StringUtils.hasText((String)dataQuery) ? new LinkedHashMap() : Splitter.on((String)"&").trimResults().withKeyValueSeparator("=").split((CharSequence)dataQuery);
        if (paramsMap != null && !paramsMap.isEmpty() && append) {
            String value = paramsMap.entrySet().stream().filter(p -> !dataMap.containsKey(p.getKey())).map(p -> (String)p.getKey() + "=" + this.encode(p.getValue().toString())).collect(Collectors.joining("&"));
            remoteURL = remoteURL.indexOf("?") > 0 ? String.format("%1$s&%2$s", remoteURL, value) : String.format("%1$s?%2$s", remoteURL, value);
        }
        System.out.println(String.format("GET %1$s", remoteURL));
        try {
            if (generateCurl) {
                dataList.add("curl ");
            }
            HttpHeaders headers = new HttpHeaders();
            String contentType = "application/x-www-form-urlencoded";
            MediaType type = MediaType.parseMediaType((String)contentType);
            if (generateCurl) {
                dataList.add(String.format("-H \"Content-Type: %1$s\" ", contentType));
            }
            headers.setContentType(type);
            RestTemplate template = new RestTemplate();
            if (generateCurl) {
                this.request.getParamsMap().entrySet().forEach(p -> {
                    String value = p.getValue() == null ? "" : p.getValue().toString();
                    valueMap.put((String)p.getKey(), value);
                });
                String targetURL = ParserUtils.parseNameHolder("{", "}", remoteURL, valueMap);
                dataList.add(String.format("\"%1$s\"", targetURL));
            }
            ResponseEntity responseEntity = template.getForEntity(remoteURL, String.class, paramsMap);
            RestResponse restResponse = new RestResponse((HttpEntity<String>)responseEntity);
            return restResponse;
        }
        finally {
            if (generateCurl) {
                String targetCurl = dataList.stream().collect(Collectors.joining());
                System.out.println(targetCurl);
            }
        }
    }

    public RestResponse post(String remoteURL) {
        return this.post(remoteURL, "");
    }

    public RestResponse post(String remoteURL, JSONObject entity) {
        return this.post(remoteURL, JSON.toJSONStringWithDateFormat((Object)entity, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]));
    }

    public RestResponse post(String remoteURL, String entity) {
        return this.post(remoteURL, entity, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse post(String remoteURL, String entity, boolean generateCurl) {
        ArrayList<String> dataList = new ArrayList<String>();
        LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
        try {
            MediaType type;
            if (generateCurl) {
                dataList.add("curl -X POST ");
            }
            HttpHeaders headers = new HttpHeaders();
            String contentType = this.request.getContentType();
            if (StringUtils.hasText((String)contentType)) {
                type = MediaType.parseMediaType((String)contentType);
                headers.setContentType(type);
            } else {
                contentType = "application/json; charset=UTF-8";
                type = MediaType.parseMediaType((String)contentType);
                headers.setContentType(type);
            }
            if (generateCurl) {
                dataList.add(String.format("-H \"Content-Type: %1$s\" ", contentType));
            }
            if (this.request.getHeaderMap() != null && this.request.getHeaderMap().size() > 0) {
                Set<Map.Entry<String, String>> entrySet = this.request.getHeaderMap().entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    headers.add(entry.getKey(), entry.getValue());
                    if (!generateCurl) continue;
                    dataList.add(String.format("-H \"%1$s: %2$s\" ", entry.getKey(), entry.getValue()));
                }
            }
            HttpEntity postEntity = new HttpEntity((Object)entity, (MultiValueMap)headers);
            RestTemplate template = new RestTemplate();
            ResponseEntity responseEntity = null;
            if (this.request.getParamsMap() != null && this.request.getParamsMap().size() > 0) {
                if (generateCurl) {
                    dataList.add(String.format("-d '%1$s' ", entity));
                    this.request.getParamsMap().entrySet().forEach(p -> {
                        String name = (String)p.getKey();
                        String value = p.getValue() == null ? "" : p.getValue().toString();
                        try {
                            value = URLEncoder.encode(value, "UTF-8");
                        }
                        catch (Exception e) {
                            log.error("\u8fdb\u884c\u53c2\u6570:{} \u7f16\u7801\u53d1\u751f\u5f02\u5e38:{}", new Object[]{name, e.getMessage(), e});
                        }
                        valueMap.put(name, value);
                    });
                    String targetURL = ParserUtils.parseNameHolder("{", "}", remoteURL, valueMap);
                    dataList.add(String.format("\"%1$s\"", targetURL));
                }
                responseEntity = template.postForEntity(remoteURL, (Object)postEntity, String.class, this.request.getParamsMap());
            } else {
                if (generateCurl) {
                    dataList.add(String.format("-d '%1$s' ", entity));
                    dataList.add(String.format("\"%1$s\"", remoteURL));
                }
                responseEntity = template.postForEntity(remoteURL, (Object)postEntity, String.class, new Object[0]);
            }
            RestResponse restResponse = new RestResponse((HttpEntity<String>)responseEntity);
            return restResponse;
        }
        finally {
            if (generateCurl) {
                String targetCurl = dataList.stream().collect(Collectors.joining());
                System.out.println(targetCurl);
            }
        }
    }

    public RestResponse exchangeFormData(String remoteURL, MultiValueMap<String, Object> body) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpEntity postEntity = new HttpEntity(body, (MultiValueMap)headers);
        RestTemplate template = new RestTemplate();
        ResponseEntity responseEntity = null;
        responseEntity = this.request.getParamsMap() != null && this.request.getParamsMap().size() > 0 ? template.exchange(remoteURL, HttpMethod.POST, postEntity, String.class, this.request.getParamsMap()) : template.exchange(remoteURL, HttpMethod.POST, postEntity, String.class, new Object[0]);
        return new RestResponse((HttpEntity<String>)responseEntity);
    }

    public RestResponse submitForm(String url, Map<String, String> params) {
        RestTemplate template = new RestTemplate();
        LinkedMultiValueMap valueMap = new LinkedMultiValueMap();
        params.entrySet().forEach(arg_0 -> RestSender.lambda$submitForm$5((MultiValueMap)valueMap, arg_0));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)valueMap, (MultiValueMap)headers);
        String response = (String)template.postForObject(url, (Object)request, String.class, new Object[0]);
        ResponseEntity entity = new ResponseEntity((Object)response, HttpStatus.OK);
        return new RestResponse((HttpEntity<String>)entity);
    }

    private static /* synthetic */ void lambda$submitForm$5(MultiValueMap valueMap, Map.Entry p) {
        valueMap.add(p.getKey(), p.getValue());
    }
}

