/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.infrastructure.utils.statement;

import com.shiji.infrastructure.utils.string.StringFormat;
import com.shiji.infrastructure.utils.tools.MapAs;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class WhereCondition {
    private Map<String, Object> conditionMap = new LinkedHashMap<String, Object>();
    private String tagName = "";

    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    private WhereCondition(Map<String, Object> conf, String tagName) {
        this.conditionMap.putAll(conf);
        this.tagName = tagName;
    }

    public Map.Entry<String, Map<String, Object>> format(String left, String right, String source) {
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        ArrayList<String> dataList = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.conditionMap.entrySet()) {
            String dataKey = entry.getKey();
            Object dataVal = entry.getValue();
            if (dataVal != null) {
                if (dataVal instanceof Map.Entry) {
                    Map.Entry iEntry = (Map.Entry)dataVal;
                    Object value = iEntry.getValue();
                    dataMap.put(dataKey, value);
                    if (value == null) continue;
                    String template = StringFormat.namedFormat("[", "]", iEntry.getKey().toString(), MapAs.of("value", String.format(":%1$s", dataKey)));
                    dataList.add(template);
                    continue;
                }
                dataMap.put(dataKey, dataVal);
                dataList.add(String.format("%1$s = :%1$s", dataKey));
                continue;
            }
            dataMap.put(dataKey, dataVal);
        }
        String target = source;
        Map<String, Object> paramsMap = MapAs.of("where", "");
        if (!dataList.isEmpty()) {
            paramsMap = MapAs.of("where", String.format(" %1$s %2$s", this.tagName, dataList.stream().collect(Collectors.joining(" AND "))));
        }
        target = StringFormat.namedFormat(left, right, source, paramsMap);
        return new AbstractMap.SimpleEntry<String, Map<String, Object>>(target, dataMap);
    }

    public Map.Entry<String, Map<String, Object>> format(String source) {
        return this.format("${", "}", source);
    }

    public static class Builder {
        private Map<String, Object> conf;

        public Builder() {
            this.conf = new LinkedHashMap<String, Object>();
        }

        public Builder(Map<String, Object> conf) {
            this.conf = conf;
        }

        public Builder where(String dataKey, Object value) {
            this.conf.put(dataKey, value);
            return this;
        }

        public Builder where(String dataKey, String template, Object value) {
            this.conf.put(dataKey, new AbstractMap.SimpleEntry<String, Object>(template, value));
            return this;
        }

        public WhereCondition build(String tagName) {
            WhereCondition instance = new WhereCondition(this.conf, tagName);
            return instance;
        }

        public WhereCondition build() {
            WhereCondition instance = new WhereCondition(this.conf, "WHERE");
            return instance;
        }
    }
}

