/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.infrastructure.utils.string;

import com.shiji.infrastructure.utils.string.FormatFunction;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringFormat {
    private static final Logger log = LoggerFactory.getLogger(StringFormat.class);

    private static String parseHolderObject(String openToken, String closeToken, String message, FormatFunction callback) {
        int argsIndex = 0;
        if (message == null || message.isEmpty()) {
            return "";
        }
        char[] src = message.toCharArray();
        int offset = 0;
        int start = message.indexOf(openToken, offset);
        if (start == -1) {
            return message;
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(openToken);
                offset = start + openToken.length();
            } else {
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, start - offset);
                offset = start + openToken.length();
                int end = message.indexOf(closeToken, offset);
                while (end > -1) {
                    if (end > offset && src[end - 1] == '\\') {
                        expression.append(src, offset, end - offset - 1).append(closeToken);
                        offset = end + closeToken.length();
                        end = message.indexOf(closeToken, offset);
                        continue;
                    }
                    expression.append(src, offset, end - offset);
                    offset = end + closeToken.length();
                    break;
                }
                if (end == -1) {
                    builder.append(src, start, src.length - start);
                    offset = src.length;
                } else {
                    String original = expression.toString();
                    log.debug("original value:{}", (Object)original);
                    String value = original;
                    if (callback != null) {
                        value = callback.apply(argsIndex, original);
                    }
                    log.debug("original value:{} target value:{}", (Object)original, (Object)value);
                    builder.append(value);
                    offset = end + closeToken.length();
                    ++argsIndex;
                }
            }
            start = message.indexOf(openToken, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    public static String indexFormat(String openToken, String closeToken, String message, String ... args) {
        String response = StringFormat.parseHolderObject(openToken, closeToken, message, (index, source) -> {
            String value = index <= args.length - 1 ? (args[index] == null ? "" : args[index].toString()) : source;
            return value;
        });
        return response;
    }

    public static String namedFormat(String message, Map<String, Object> nameMap) {
        return StringFormat.namedFormat("{", "}", message, nameMap);
    }

    public static String namedFormat(String openToken, String closeToken, String message, Map<String, Object> nameMap) {
        String response = StringFormat.parseHolderObject(openToken, closeToken, message, (index, source) -> {
            if (nameMap.containsKey(source)) {
                Object value = nameMap.get(source);
                return value == null ? "" : value.toString();
            }
            return source;
        });
        return response;
    }
}

