/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.infrastructure.utils.tools;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SHA256 {
    public static Map.Entry<String, String> encryptSHA1(String appCode, String secretKey, String ts) throws NoSuchAlgorithmException, InvalidKeyException {
        String signa = SHA256.md5(String.format("%1$s%2$s", appCode, ts));
        String signature = SHA256.encryptSHA1(signa, secretKey);
        return new AbstractMap.SimpleEntry<String, String>(signa, signature);
    }

    public static String encryptMD5(String source, String secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
        return SHA256.encrypt(source, "HmacMD5", secretKey);
    }

    public static String encryptSHA1(String source, String secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
        return SHA256.encrypt(source, "HmacSHA1", secretKey);
    }

    public static String encryptSHA256(String source, String secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
        return SHA256.encrypt(source, "HmacSHA256", secretKey);
    }

    public static String encrypt(String source, String algorithm, String secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(algorithm);
        SecretKeySpec spec = new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), algorithm);
        mac.init(spec);
        byte[] hexDigits = mac.doFinal(source.getBytes(StandardCharsets.UTF_8));
        String target = Base64.getEncoder().encodeToString(hexDigits);
        return target;
    }

    public static String md5(String source) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] mdBytes = md.digest(source.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : mdBytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public static String sha256(String source) {
        String response = "";
        try {
            MessageDigest messageDigest = null;
            messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.reset();
            messageDigest.update(source.getBytes("UTF-8"));
            response = SHA256.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return response;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuilder buffer = new StringBuilder();
        for (byte aByte : bytes) {
            String temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                buffer.append("0");
            }
            buffer.append(temp);
        }
        return buffer.toString();
    }
}

