/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.product.component.BeanField;
import com.product.exception.ServiceException;
import com.product.storage.parser.QueryExtractor;
import com.product.storage.strategy.SqlSessionTemplate;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.TypeUtils;
import com.shiji.core.annotation.KeepTransient;
import com.shiji.core.util.ReflectUtils;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.Transient;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="batchinsservice")
public class BatchInsService {
    @Value(value="${efuture.batchinsert.batch_rows:1000}")
    private int BATCH_ROWS = 1000;

    public String convertToColType(QueryExtractor.DBTYPE dbtype, String colType) {
        if (dbtype == QueryExtractor.DBTYPE.ORACLE) {
            if (colType.toLowerCase().startsWith("varchar") || colType.toLowerCase().startsWith("char")) {
                return "string";
            }
            if (colType.toLowerCase().startsWith("number")) {
                return "long";
            }
            if (colType.toLowerCase().startsWith("date")) {
                return "date";
            }
        } else if (dbtype == QueryExtractor.DBTYPE.MYSQL || dbtype == QueryExtractor.DBTYPE.SQLITE) {
            if (colType.toLowerCase().startsWith("varchar") || colType.toLowerCase().startsWith("char")) {
                return "string";
            }
            if (colType.toLowerCase().startsWith("int") || colType.toLowerCase().startsWith("bigint")) {
                return "long";
            }
            if (colType.toLowerCase().startsWith("decimal")) {
                return "double";
            }
            if (colType.toLowerCase().startsWith("date")) {
                return "date";
            }
        }
        return "string";
    }

    public Object getColData(FMybatisTemplate storage, Object o, String type2) throws ParseException {
        SimpleDateFormat timefmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (type2.contains("long")) {
            o = StringUtils.isEmpty((Object)o) ? 0L : Long.parseLong(o.toString());
        } else if (type2.contains("int")) {
            o = StringUtils.isEmpty((Object)o) ? 0 : Integer.parseInt(o.toString());
        } else if (type2.contains("float")) {
            o = Float.valueOf(StringUtils.isEmpty((Object)o) ? 0.0f : Float.parseFloat(o.toString()));
        } else if (type2.contains("double")) {
            o = StringUtils.isEmpty((Object)o) ? 0.0 : Double.parseDouble(o.toString());
        } else if (type2.contains("short")) {
            o = StringUtils.isEmpty((Object)o) ? (short)0 : Short.parseShort(o.toString());
        } else if (type2.contains("boolean")) {
            if (!(o instanceof Boolean)) {
                o = StringUtils.isEmpty((Object)o) ? Boolean.valueOf(false) : Boolean.valueOf("true".equalsIgnoreCase(o.toString()) || "Y".equalsIgnoreCase(o.toString()));
            }
        } else if (type2.contains("date")) {
            if (StringUtils.isEmpty((Object)o)) {
                o = null;
            } else {
                String s = timefmt.format(o);
                o = storage.getDBType() == QueryExtractor.DBTYPE.ORACLE ? "to_date('" + s + "', 'yyyy-mm-dd hh24:mi:ss')" : "'" + s + "'";
            }
        } else if (type2.contains("string")) {
            o = o == null ? String.valueOf(o) : "'" + String.valueOf(o).replace("'", "''").replace("\"", "") + "'";
        }
        return o;
    }

    public void batchInsertWithChild(FMybatisTemplate storage, Class objClass, String collectName, List<Object> lists, int batch_rows) throws Exception {
        if (lists.size() <= 0) {
            return;
        }
        QueryExtractor.DBTYPE dbtype = storage.getDBType();
        if (dbtype != QueryExtractor.DBTYPE.ORACLE && dbtype != QueryExtractor.DBTYPE.MYSQL && dbtype != QueryExtractor.DBTYPE.SQLITE) {
            throw new Exception("unsupport DBMS Type!");
        }
        List fields = ReflectUtils.getAllFieldsFilterTransient((Class)objClass);
        Object rows = lists.get(0);
        for (Field fld : fields) {
            if (fld == null || fld.getAnnotation(Transient.class) == null) continue;
            Class<?> cls = fld.getType();
            if (cls.getName().equals(List.class.getName())) {
                System.out.println(cls.getName());
                System.out.println(cls.getTypeParameters());
            }
            Object value = fld.get(rows);
            System.out.println(fld.getName());
            System.out.println(cls.getClass().getName());
        }
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, String collectName, List<T> lists) throws Exception {
        this.batchInsert(storage, objClass, collectName, lists, this.BATCH_ROWS);
    }

    public void batchInsert(FMybatisTemplate storage, List<Map<String, Object>> lists, String tableName, int batch_rows) throws Exception {
        if (lists.size() <= 0) {
            return;
        }
        HashSet<BeanField> beanFields = new HashSet<BeanField>();
        Map<String, Object> firstRow = lists.get(0);
        Set<String> flds = firstRow.keySet();
        for (String col : flds) {
            BeanField bf = new BeanField();
            bf.setColName(col);
            if (firstRow.get(col) != null) {
                bf.setColType(firstRow.get(col).getClass().toString().toLowerCase());
            } else {
                bf.setColType("string");
            }
            beanFields.add(bf);
        }
        this.batchInsert(storage, beanFields, lists, tableName, batch_rows);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Set<BeanField> beanFields, List<T> lists, String tableName, int batch_rows) throws Exception {
        SqlSessionTemplate db = storage.getSqlSessionTemplate();
        QueryExtractor.DBTYPE dbtype = storage.getDBType();
        if (dbtype != QueryExtractor.DBTYPE.ORACLE && dbtype != QueryExtractor.DBTYPE.MYSQL && dbtype != QueryExtractor.DBTYPE.SQLITE) {
            throw new ServiceException("5000", "unsupport DBMS Type!", new Object[0]);
        }
        int tot_page = (int)Math.ceil((float)lists.size() / (float)batch_rows);
        StringBuffer tabsql = new StringBuffer();
        tabsql.append("insert into ").append(tableName).append(" (");
        for (BeanField col : beanFields) {
            tabsql.append(col.getColName()).append(",");
        }
        tabsql.deleteCharAt(tabsql.length() - 1);
        tabsql.append(")");
        for (int page = 0; page < tot_page; ++page) {
            StringBuffer sql = new StringBuffer();
            sql.append(tabsql);
            boolean firstrow = true;
            for (int row = batch_rows * page; row < Math.min(lists.size(), batch_rows * (page + 1)); ++row) {
                T bean = lists.get(row);
                if (dbtype == QueryExtractor.DBTYPE.ORACLE) {
                    if (!firstrow) {
                        sql.append(" union all ");
                    }
                    sql.append(" select ");
                    for (BeanField col : beanFields) {
                        sql.append(this.getColData(storage, col.getColValue(bean), col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" from dual");
                } else if (dbtype == QueryExtractor.DBTYPE.SQLITE) {
                    if (!firstrow) {
                        sql.append(" union all ");
                    }
                    sql.append(" select ");
                    for (BeanField col : beanFields) {
                        sql.append(this.getColData(storage, col.getColValue(bean), col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" \r\n ");
                } else if (dbtype == QueryExtractor.DBTYPE.MYSQL) {
                    if (firstrow) {
                        sql.append(" values ");
                    } else {
                        sql.append(",");
                    }
                    sql.append("(");
                    for (BeanField col : beanFields) {
                        sql.append(this.getColData(storage, col.getColValue(bean), col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(")");
                }
                firstrow = false;
            }
            db.insert("mybatis.sql.insert", sql.toString());
        }
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, String collectionName, List<T> lists, int batch_rows) throws Exception {
        SqlSessionTemplate db = storage.getSqlSessionTemplate();
        if (lists.size() <= 0) {
            return;
        }
        QueryExtractor.DBTYPE dbtype = storage.getDBType();
        if (dbtype != QueryExtractor.DBTYPE.ORACLE && dbtype != QueryExtractor.DBTYPE.MYSQL && dbtype != QueryExtractor.DBTYPE.SQLITE) {
            throw new Exception("unsupport DBMS Type!");
        }
        List fields = ReflectUtils.getAllFieldsFilterTransient(objClass);
        HashSet<Object> beanFields = new HashSet<Object>();
        for (Field fld : fields) {
            if (fld == null || fld.getAnnotation(Transient.class) != null || fld.getAnnotation(KeepTransient.class) != null) continue;
            BeanField bf = new BeanField();
            bf.setColName(fld.getName());
            bf.setField(fld);
            bf.setColType(fld.getType().getName().toLowerCase());
            beanFields.add(bf);
        }
        int tot_page = (int)Math.ceil((float)lists.size() / (float)batch_rows);
        StringBuffer tabsql = new StringBuffer();
        tabsql.append("insert into ").append(collectionName).append(" (");
        for (BeanField beanField : beanFields) {
            tabsql.append(beanField.getColName()).append(",");
        }
        tabsql.deleteCharAt(tabsql.length() - 1);
        tabsql.append(")");
        for (int page = 0; page < tot_page; ++page) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(tabsql);
            boolean firstrow = true;
            for (int row = batch_rows * page; row < Math.min(lists.size(), batch_rows * (page + 1)); ++row) {
                T bean = lists.get(row);
                JSONObject rowjson = TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
                if (dbtype == QueryExtractor.DBTYPE.ORACLE) {
                    if (!firstrow) {
                        stringBuffer.append(" union all ");
                    }
                    stringBuffer.append(" select ");
                    for (BeanField beanField : beanFields) {
                        stringBuffer.append(this.getColData(storage, rowjson.get((Object)beanField.getColName()), beanField.getColType()));
                        stringBuffer.append(",");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    stringBuffer.append(" from dual");
                } else if (dbtype == QueryExtractor.DBTYPE.SQLITE) {
                    if (!firstrow) {
                        stringBuffer.append(" union all ");
                    }
                    stringBuffer.append(" select ");
                    for (BeanField beanField : beanFields) {
                        stringBuffer.append(this.getColData(storage, rowjson.get((Object)beanField.getColName()), beanField.getColType()));
                        stringBuffer.append(",");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    stringBuffer.append(" \r\n ");
                } else if (dbtype == QueryExtractor.DBTYPE.MYSQL) {
                    if (firstrow) {
                        stringBuffer.append(" values ");
                    } else {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("(");
                    for (BeanField beanField : beanFields) {
                        stringBuffer.append(this.getColData(storage, rowjson.get((Object)beanField.getColName()), beanField.getColType()));
                        stringBuffer.append(",");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    stringBuffer.append(")");
                }
                firstrow = false;
            }
            db.insert("mybatis.sql.insert", stringBuffer.toString());
        }
    }
}

