/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.base.filter;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.fastjson.JSONObject;
import com.product.storage.base.filter.CollectionSelectWrapper;
import com.product.util.SpringContext;
import com.product.util.UniqueID;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;

public abstract class BaseExecutorWrapper
extends CollectionSelectWrapper
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(BaseExecutorWrapper.class);
    private StringRedisTemplate redisTemplate;

    public StringRedisTemplate getRedisTemplate() {
        if (StringUtils.isEmpty((Object)this.redisTemplate)) {
            this.redisTemplate = (StringRedisTemplate)SpringContext.getContext().getBean(StringRedisTemplate.class);
        }
        return this.redisTemplate;
    }

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        long interceptID = UniqueID.getUniqueID();
        long startTime = System.currentTimeMillis();
        log.info("{}:1\u3001---->\u8fdb\u5165\u5230BaseExecutorWrapper\u62e6\u622a\u5668", (Object)interceptID);
        if (!this.isIntercept()) {
            log.info("{}:2\u3001---->BaseExecutorWrapper\u4e0d\u62e6\u622a", (Object)interceptID);
            return invocation.proceed();
        }
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String sqlStatement = "";
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[1];
        }
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        sqlStatement = boundSql.getSql();
        if (invocation.getArgs().length == 6) {
            boundSql = (BoundSql)invocation.getArgs()[5];
        }
        sqlStatement = boundSql.getSql();
        log.info("{}:3\u3001---->BaseExecutorWrapper\u83b7\u53d6SQL:{}", (Object)interceptID, (Object)sqlStatement.replaceAll("[\\s]+", " "));
        if (!this.isIntercept(sqlStatement)) {
            log.info("{}:4\u3001---->BaseExecutorWrapper\u4e0d\u62e6\u622aSQL:{}", (Object)interceptID, (Object)sqlStatement.replaceAll("[\\s]+", " "));
            return invocation.proceed();
        }
        try {
            JSONObject logJson = new JSONObject();
            List statementList = SQLUtils.toStatementList((String)sqlStatement, (String)this.getDbType());
            for (SQLStatement stmt : statementList) {
                logJson.put("selectSql", (Object)sqlStatement);
                if (!(stmt instanceof SQLSelectStatement)) continue;
                log.info("{}:5\u3001---->BaseExecutorWrapper\u5f00\u59cb\u6570\u636e\u6743\u9650\u8fc7\u6ee4\u5904\u7406", (Object)interceptID);
                this.onStatement(log, sqlStatement, logJson, invocation, mappedStatement, boundSql, stmt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("{}:6\u3001---->BaseExecutorWrapper\u6267\u884c\u6570\u636e\u6743\u9650\u8fc7\u6ee4\u5f02\u5e38", (Object)interceptID);
            invocation.getArgs()[0] = mappedStatement;
            JSONObject errorJson = new JSONObject();
            errorJson.put("unresolved sql", (Object)sqlStatement);
            log.error(errorJson.toJSONString());
        }
        long endTime = System.currentTimeMillis();
        log.info("{}:7\u3001---->BaseExecutorWrapper\u7ec4\u88c5\u8017\u8d39\u65f6\u95f4:----{}", (Object)interceptID, (Object)(startTime - endTime));
        long start = System.currentTimeMillis();
        Object response = invocation.proceed();
        long end = System.currentTimeMillis();
        long execTime = end - start;
        log.info("{}:8\u3001---->BaseExecutorWrapper\u62e6\u622a\u5668\u6267\u884c\u8017\u65f6:{}", (Object)interceptID, (Object)execTime);
        return response;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String dbType = properties.getProperty("dbType");
        if (dbType == null || dbType.equals("")) {
            this.setDbType("mysql");
        } else {
            this.setDbType(dbType);
        }
    }
}

