/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.base.filter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.product.storage.base.filter.CollectionSQLWrapper;
import com.product.storage.filter.FtSqlSource;
import com.product.storage.myshop.filter.service.CollectionExecutorHandler;
import com.product.storage.slice.filter.ExecutorCallback;
import com.product.storage.slice.filter.ExecutorSliceWrapper;
import com.product.util.StaticVariable;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Invocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CollectionSelectWrapper
extends CollectionSQLWrapper
implements CollectionExecutorHandler {
    private static final Logger log = LoggerFactory.getLogger(CollectionSelectWrapper.class);
    ExecutorCallback callback = new ExecutorCallback(){

        @Override
        public void onAction(SQLSelectQueryBlock query, String collectionName, String collectionAlias) {
            SQLBinaryOpExpr newWhereExpr = new SQLBinaryOpExpr();
            String authWhereSql = CollectionSelectWrapper.this.getWhere(collectionName, collectionAlias);
            if (!StringUtils.isEmpty((String)authWhereSql)) {
                log.debug(String.format("6--->add WhereSql--->%1$s", authWhereSql));
                SQLExpr authWhereExpr = CollectionSelectWrapper.this.getWhereInfo(authWhereSql);
                if (query.getWhere() != null && query.getWhere() instanceof SQLBinaryOpExpr) {
                    SQLBinaryOpExpr whereExpr = (SQLBinaryOpExpr)query.getWhere();
                    if (whereExpr != null) {
                        newWhereExpr.setOperator(SQLBinaryOperator.BooleanAnd);
                        newWhereExpr.setLeft(authWhereExpr);
                        newWhereExpr.setRight((SQLExpr)whereExpr);
                    }
                } else {
                    newWhereExpr = authWhereExpr;
                }
                query.setWhere((SQLExpr)newWhereExpr);
            }
        }
    };

    public abstract String getWhere(String var1, String var2);

    public abstract boolean isIntercept();

    public abstract boolean isIntercept(String var1);

    @Override
    public void onStatement(Logger logger, String statement, JSONObject logJson, Invocation invocation, MappedStatement mappedStatement, BoundSql boundSql, SQLStatement stmt) throws Throwable {
        SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
        logJson.put("selectSql", (Object)statement);
        if (selectStmt.getSelect().getQuery() instanceof SQLUnionQuery) {
            logJson.put("result", (Object)this.getUnionSqlInfo((SQLUnionQuery)selectStmt.getSelect().getQuery(), 1, this.callback));
        } else {
            logJson.put("result", (Object)this.getSqlInfo((SQLSelectQuery)((SQLSelectQueryBlock)selectStmt.getSelect().getQuery()), this.callback));
        }
        StringBuffer newSql = new StringBuffer();
        MySqlOutputVisitor visitor = null;
        if (this.getDbType().equals("mysql")) {
            visitor = new MySqlOutputVisitor((Appendable)newSql);
        } else if (this.getDbType().equals("oracle")) {
            visitor = new OracleOutputVisitor((Appendable)newSql);
        } else {
            throw new Exception("\u672a\u8bc6\u522b\u7684dbType");
        }
        visitor.visit(selectStmt);
        visitor.println();
        visitor.endVisit(selectStmt);
        FtSqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql.toString(), boundSql);
        MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, sqlSource);
        invocation.getArgs()[0] = newMs;
        logJson.put("newSql", (Object)newSql.toString());
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[1];
        }
        BoundSql newBoundSql = newMs.getBoundSql(parameter);
        if (invocation.getArgs().length == 6) {
            invocation.getArgs()[ExecutorSliceWrapper.MAPPED_STATEMENT_INDEX] = newMs;
            invocation.getArgs()[ExecutorSliceWrapper.BOUNDSQL_INDEX] = newBoundSql;
        }
        logJson.put("newSql", (Object)newSql.toString());
        String newStatement = newBoundSql.getSql();
        String trace = StaticVariable.get();
        String message = String.format("nowSQL --->%1$s--->Params:%2$s--->Thread:%3$s", newStatement.replaceAll("[\\s]+", " "), parameter == null ? "<none>" : JSON.toJSONString((Object)parameter), StringUtils.isEmpty((String)trace) ? "<none>" : trace);
        logger.debug(message);
    }

    @Override
    public boolean support(String typeCode) {
        return "select".equals(typeCode);
    }
}

