/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.base.filter;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.product.model.ServiceSession;
import com.product.storage.base.filter.BaseExecutorWrapper;
import com.product.util.SpringContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class StandardExecutorWrapper
extends BaseExecutorWrapper
implements Interceptor {
    @Override
    public boolean isIntercept() {
        if (!SpringContext.isInitComplete()) {
            return false;
        }
        ServiceSession session = SpringContext.getSession();
        return session != null && session.getRoleAdmin() != null && session.getRoleAdmin() == false;
    }

    @Override
    public boolean isIntercept(String statement) {
        return true;
    }

    public boolean isIntercept(ServiceSession session) {
        return session.getRoleAdmin() == false;
    }

    public Map<String, String> onTableRangeReader(StringRedisTemplate redisTemplate, Long entId, String tableName, String moduleCode) {
        HashMap<String, String> response = new HashMap<String, String>();
        redisTemplate.setEnableTransactionSupport(false);
        String dataKey = String.format("DataRange:table:Ent%1$d", entId);
        if (redisTemplate.opsForSet().isMember((Object)dataKey, (Object)tableName).booleanValue()) {
            String tableKey = String.format("DataRange:table:ent%1$d:%2$s", entId, tableName);
            Map dataMap = redisTemplate.opsForHash().entries((Object)tableKey);
            for (Object influenceKey : dataMap.keySet()) {
                String columnName = "";
                String moduleState = "all";
                String keyValue = dataMap.get(influenceKey).toString();
                List vList = Splitter.on((String)":").omitEmptyStrings().splitToList((CharSequence)keyValue);
                if (vList.size() > 1) {
                    columnName = (String)vList.get(0);
                    moduleState = (String)vList.get(1);
                } else if (vList.size() > 0) {
                    columnName = (String)vList.get(0);
                }
                if ("def".equalsIgnoreCase(moduleState)) {
                    String moduleKey = String.format("DataRange:module:Ent%1$d:%2$s", entId, moduleCode);
                    Set influenceSet = redisTemplate.opsForSet().members((Object)moduleKey);
                    if (!influenceSet.contains(influenceKey.toString())) continue;
                    response.put(influenceKey.toString(), columnName);
                    continue;
                }
                response.put(influenceKey.toString(), columnName);
            }
        }
        return response;
    }

    public Map<String, Set<String>> getStationCondition(StringRedisTemplate redisTemplate, ServiceSession session, Map<String, String> influenceMap) {
        HashMap<String, Set<String>> response = new HashMap<String, Set<String>>();
        redisTemplate.setEnableTransactionSupport(false);
        for (String influenceCode : influenceMap.keySet()) {
            String columnName = influenceMap.get(influenceCode);
            String dataKey = String.format("DataRange:Ent%1$d:%2$d:%3$s", session.getEnt_id(), session.getStationId(), influenceCode);
            Set dataSet = redisTemplate.opsForSet().members((Object)dataKey);
            response.put(columnName, dataSet);
        }
        return response;
    }

    @Override
    public String getWhere(String collectionName, String collectionAlias) {
        String response = "";
        String tableName = collectionName.toLowerCase();
        ServiceSession session = SpringContext.getSession();
        Map<String, String> influenceMap = this.onTableRangeReader(this.getRedisTemplate(), session.getEnt_id(), tableName, session.getModuleCode());
        Map<String, Set<String>> conditionMap = this.getStationCondition(this.getRedisTemplate(), session, influenceMap);
        System.out.println(String.format("--------->\u8868\u540d:%1$s \u522b\u540d:%2$s \u6761\u4ef6:%3$s", tableName, collectionAlias, JSON.toJSONString(conditionMap)));
        ArrayList<String> condList = new ArrayList<String>();
        for (String columnName : conditionMap.keySet()) {
            Set<String> dataSet = conditionMap.get(columnName);
            if (dataSet.isEmpty()) {
                return String.format("1=2 /*%1$s \u65e0\u6743\u9650*/", columnName);
            }
            if (!StringUtils.isEmpty((Object)collectionAlias)) {
                condList.add(String.format("%1$s.%2$s in ('%3$s')", collectionAlias, columnName, Joiner.on((String)"','").join(dataSet)));
                continue;
            }
            if (dataSet.contains("ALL")) {
                condList.add(" 1=1 ");
                continue;
            }
            response = String.format("%1$s in ('%2$s')", columnName, Joiner.on((String)"','").join(dataSet));
            condList.add(response);
        }
        response = Joiner.on((String)" AND ").join(condList);
        return response;
    }
}

