/*
 * Decompiled with CFR 0.152.
 */
package com.product.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterType;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.config.AbstractMongoClientConfiguration;

@Configuration
@EnableConfigurationProperties(value={MongoProperties.class})
@ConditionalOnProperty(prefix="mongodb", name={"enabled"}, havingValue="true")
public class MongodbConfig
extends AbstractMongoClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MongodbConfig.class);
    @Autowired
    MongoProperties properties;

    protected void configureClientSettings(MongoClientSettings.Builder builder) {
        if (StringUtils.isNotBlank((String)this.properties.getUsername()) && StringUtils.isNotBlank((String)this.properties.getAuthenticationDatabase())) {
            builder.credential(MongoCredential.createCredential((String)this.properties.getUsername(), (String)this.properties.getAuthenticationDatabase(), (char[])this.properties.getPassword()));
        }
        if (StringUtils.isNotBlank((String)this.properties.getHost())) {
            builder.applyToClusterSettings(settings -> settings.hosts(Collections.singletonList(new ServerAddress(this.properties.getHost(), this.properties.getPort().intValue()))));
        } else if (StringUtils.isNotBlank((String)this.properties.getUri())) {
            log.info("uri---------------" + this.properties.getUri());
            log.info("replicaset---------------" + this.properties.getReplicaSetName());
            if (StringUtils.isNotBlank((String)this.properties.getReplicaSetName())) {
                builder.applyToClusterSettings(settings -> settings.requiredClusterType(ClusterType.REPLICA_SET).mode(ClusterConnectionMode.MULTIPLE).requiredReplicaSetName(this.properties.getReplicaSetName())).applyConnectionString(new ConnectionString(this.properties.getUri()));
            } else {
                builder.applyToClusterSettings(settings -> {}).applyConnectionString(new ConnectionString(this.properties.getUri()));
            }
        }
    }

    @Bean
    public MongoClient mongoClient() {
        return this.createMongoClient(this.mongoClientSettings());
    }

    @ConditionalOnProperty(prefix="spring.data.mongodb", name={"replica-set-name"})
    @Bean(value={"mongoTransactionManager"})
    public MongoTransactionManager transactionManager(MongoDatabaseFactory dbFactory) {
        return new MongoTransactionManager(dbFactory);
    }

    protected String getDatabaseName() {
        return this.properties.getDatabase();
    }
}

