/*
 * Decompiled with CFR 0.152.
 */
package com.product.config.redis;

import com.product.annotation.redis.CacheKeyGenerator;
import com.product.component.redis.LockKeyGenerator;
import com.product.config.redis.LockMethodInterceptor;
import com.product.config.redis.RedisLockHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnProperty(name={"distributedLock.enabled"}, havingValue="true")
public class DistributedLockConfiger {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockConfiger.class);

    @Bean(name={"cacheKeyGenerator"})
    public CacheKeyGenerator onCacheKeyGenerator() {
        LockKeyGenerator service = new LockKeyGenerator();
        return service;
    }

    @Bean(name={"redisLockHelper"})
    public RedisLockHelper onRedisLockHelper(@Qualifier(value="stringRedisTemplate") StringRedisTemplate stringRedisTemplate) {
        RedisLockHelper service = new RedisLockHelper(stringRedisTemplate);
        return service;
    }

    @Bean
    public LockMethodInterceptor onLockMethodInterceptor(RedisLockHelper redisLockHelper, CacheKeyGenerator cacheKeyGenerator) {
        LockMethodInterceptor service = new LockMethodInterceptor(redisLockHelper, cacheKeyGenerator);
        return service;
    }
}

