/*
 * Decompiled with CFR 0.152.
 */
package com.product.config.redis;

import com.efuture.redis.BaseJedisConnectionFactory;
import com.efuture.redis.component.RedisClient;
import java.time.Duration;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class RedisLettucePoolConfig {
    @Resource
    ConfigurableEnvironment environment;

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    public RedisStandaloneConfiguration redisStandaloneConfig() {
        String host = this.environment.getProperty("spring.redis.host");
        String port = this.environment.getProperty("spring.redis.port");
        String password = this.environment.getProperty("spring.redis.password");
        String index = this.environment.getProperty("spring.redis.database");
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setHostName(host.trim());
        redisStandaloneConfiguration.setPort(Integer.parseInt(port.trim()));
        redisStandaloneConfiguration.setDatabase(!StringUtils.isEmpty((Object)index) ? Integer.valueOf(index) : 0);
        redisStandaloneConfiguration.setPassword(!StringUtils.isEmpty((Object)password) ? password.trim() : "");
        return redisStandaloneConfiguration;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, matchIfMissing=false)
    public LettucePoolingClientConfiguration singleRedisConnectionFactory() {
        LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder builder = LettucePoolingClientConfiguration.builder();
        builder.poolConfig((GenericObjectPoolConfig)this.poolConfiguration());
        int timeout = (Integer)this.environment.getProperty("spring.redis.timeout", Integer.class, (Object)10000);
        builder.commandTimeout(Duration.ofMillis(timeout));
        return builder.build();
    }

    @Bean(value={"lettuceConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    @Primary
    public LettuceConnectionFactory redisConnectionFactory() {
        LettuceConnectionFactory connect = new LettuceConnectionFactory(this.redisStandaloneConfig(), (LettuceClientConfiguration)this.singleRedisConnectionFactory());
        connect.setConvertPipelineAndTxResults(false);
        return connect;
    }

    @Bean(value={"jedisConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    public JedisConnectionFactory singleJedisConnectionFactory() {
        BaseJedisConnectionFactory.StandaloneJedisClientConfiguration clientConfig = (BaseJedisConnectionFactory.StandaloneJedisClientConfiguration)BaseJedisConnectionFactory.StandaloneJedisClientConfiguration.create((GenericObjectPoolConfig)this.poolConfiguration());
        int timeout = (Integer)this.environment.getProperty("spring.redis.timeout", Integer.class, (Object)10000);
        clientConfig.setReadTimeout(Duration.ofMillis(timeout));
        BaseJedisConnectionFactory jedisConnectionFactory = new BaseJedisConnectionFactory(this.redisStandaloneConfig(), (JedisClientConfiguration)clientConfig);
        jedisConnectionFactory.setConvertPipelineAndTxResults(false);
        return jedisConnectionFactory;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="cluster")
    public RedisClusterConfiguration clusterConfiguration() {
        Properties properties = new Properties();
        properties.put("spring.redis.cluster.nodes", this.environment.getProperty("spring.redis.cluster.nodes"));
        String maxRedirects = this.environment.getProperty("spring.redis.cluster.max-redirects");
        properties.put("spring.redis.cluster.max-redirects", (Object)Integer.parseInt(maxRedirects));
        PropertiesPropertySource redisPropertySource = new PropertiesPropertySource("redis", properties);
        RedisClusterConfiguration redisClusterConfiguration = new RedisClusterConfiguration((PropertySource)redisPropertySource);
        String password = this.environment.getProperty("spring.redis.password");
        redisClusterConfiguration.setPassword(password);
        return redisClusterConfiguration;
    }

    @Bean(value={"lettuceConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="cluster")
    public LettuceConnectionFactory clusterConnectionFactory() {
        LettuceConnectionFactory connect = new LettuceConnectionFactory(this.clusterConfiguration(), (LettuceClientConfiguration)this.singleRedisConnectionFactory());
        connect.setConvertPipelineAndTxResults(false);
        return connect;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, matchIfMissing=false)
    public JedisPoolConfig poolConfiguration() {
        JedisPoolConfig config = new JedisPoolConfig();
        String maxActive = this.environment.getProperty("spring.redis.jedis.pool.max-active");
        String maxWait = this.environment.getProperty("spring.redis.jedis.pool.max-wait");
        String maxIdle = this.environment.getProperty("spring.redis.jedis.pool.max-idle");
        String minIdle = this.environment.getProperty("spring.redis.jedis.pool.min-idle");
        boolean testOnCreate = (Boolean)this.environment.getProperty("spring.redis.pool.test-on-create", Boolean.class, (Object)false);
        boolean testOnBorrow = (Boolean)this.environment.getProperty("spring.redis.pool.test-on-borrow", Boolean.class, (Object)false);
        boolean testOnReturn = (Boolean)this.environment.getProperty("spring.redis.pool.test-on-return", Boolean.class, (Object)false);
        boolean testWhileIdle = (Boolean)this.environment.getProperty("spring.redis.pool.test-while-idle", Boolean.class, (Object)false);
        config.setMaxTotal(Integer.parseInt(maxActive));
        config.setMaxWaitMillis((long)Integer.parseInt(maxWait));
        config.setMaxIdle(Integer.parseInt(maxIdle));
        config.setMinIdle(Integer.parseInt(minIdle));
        config.setTestOnBorrow(testOnBorrow);
        config.setTestOnCreate(testOnCreate);
        config.setTestOnReturn(testOnReturn);
        config.setTestWhileIdle(testWhileIdle);
        return config;
    }

    @Bean(value={"redisTemplate"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    RedisTemplate<String, Object> redisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)this.redisConnectionFactory());
        redisTemplate.setEnableTransactionSupport(true);
        GenericJackson2JsonRedisSerializer jackson2JsonRedisSerializer = new GenericJackson2JsonRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean(value={"stringRedisTemplate"})
    @Qualifier(value="stringRedisTemplate")
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    StringRedisTemplate stringRedisTemplate() {
        StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory((RedisConnectionFactory)this.redisConnectionFactory());
        stringRedisTemplate.setEnableTransactionSupport(true);
        return stringRedisTemplate;
    }

    @Bean(value={"redisTemplate"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="cluster")
    RedisTemplate<String, Object> clusterRedisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)this.clusterConnectionFactory());
        GenericJackson2JsonRedisSerializer jackson2JsonRedisSerializer = new GenericJackson2JsonRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean(value={"stringRedisTemplate"})
    @Qualifier(value="stringRedisTemplate")
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="cluster")
    StringRedisTemplate clusterStringRedisTemplate() {
        StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory((RedisConnectionFactory)this.clusterConnectionFactory());
        return stringRedisTemplate;
    }

    @Bean
    @Autowired
    RedisClient redisClient(@Qualifier(value="stringRedisTemplate") StringRedisTemplate stringRedisTemplate) {
        return new RedisClient(stringRedisTemplate);
    }
}

