/*
 * Decompiled with CFR 0.152.
 */
package com.product.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.product.controller.ProductReflect;
import com.product.exception.ServiceRuntimeException;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.storage.slice.filter.SliceBase;
import com.product.timezone.TimeZoneUtil;
import com.product.trace.TraceMonitor;
import com.product.util.SpringContext;
import com.product.util.StaticVariable;
import com.product.util.StatisticUtils;
import com.product.util.Utils;
import com.shiji.core.service.InvokerHandler;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.StringUtils;

public class ProductController {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ProductController.class);
    @Autowired(required=false)
    private TraceMonitor traceMonitor;
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpServletResponse response;
    @Autowired
    @Qualifier(value="ServiceMethodReflect")
    protected ProductReflect rcm;
    @Autowired
    InvokerHandler invoker;
    @Autowired
    public SliceBase sliceBase;

    public ServiceSession getSession(String method, String session, String versionCode, String entId, String userId, String userName, String locale) {
        ServiceSession response = new ServiceSession();
        if (StringUtils.isEmpty((Object)session)) {
            if (!StringUtils.isEmpty((Object)entId)) {
                if (!StringUtils.isEmpty((Object)entId)) {
                    response.setEnt_id(Long.parseLong(entId));
                }
            } else {
                response.setEnt_id(0L);
                response.setUser_id(0L);
            }
            if (!StringUtils.isEmpty((Object)userId)) {
                response.setUser_id(Long.parseLong(userId));
            }
            response.setUser_name(userName);
            response.setLocale(locale);
        } else if (session != null && !session.equals("")) {
            try {
                session = URLDecoder.decode(session, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("\u8f6c\u6362Session\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
                session = "{'ent_id':0,'user_id':0}";
            }
            response = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
        }
        StaticVariable.put((String)"ProductReflect.executeClassMethod.session", (Object)response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String onAction(String method, String session, String entId, String userId, String userName, String versionCode, String encrypt, String locale, String params) {
        String string;
        long startTimeMillis = System.currentTimeMillis();
        StatisticUtils.onIncrementMethod((String)method, (long)startTimeMillis);
        try {
            if (method.contains("refresh.splitconfig")) {
                this.onRefreshSliceReader();
                String string2 = "\u5206\u7247\u7801\u5237\u65b0\u5b8c\u6210\uff01";
                return string2;
            }
            String menuCode = this.request.getParameter("menuCode");
            String moduleCode = this.request.getParameter("moduleCode");
            StaticVariable.put((String)"context.menuCode", (Object)(menuCode + ""));
            StaticVariable.put((String)"context.moduleCode", (Object)(moduleCode + ""));
            ServiceSession contextSession = this.getSession(method, session, versionCode, entId, userId, userName, locale);
            contextSession.setMenuCode(menuCode + "");
            contextSession.setModuleCode(moduleCode + "");
            TimeZoneUtil.initTimeZone(this.request.getParameter("timeZone"), contextSession);
            SpringContext.putSession((ServiceSession)contextSession);
            SpringContext.removePageno();
            SpringContext.removePageSize();
            String requestURL = this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort() + this.request.getServletPath();
            if (this.request.getQueryString() != null) {
                requestURL = requestURL + "?" + this.request.getQueryString();
            }
            LOGGER.info("\u8bf7\u6c42\u5730\u5740:{} \u8bf7\u6c42\u53c2\u6570:{}", (Object)requestURL, (Object)params);
            String beanName = null;
            String methodName = null;
            if (!StringUtils.isEmpty((Object)method)) {
                int index = method.lastIndexOf(".");
                if (index <= 0) {
                    ServiceResponse response2 = ServiceResponse.buildFailure((ServiceSession)contextSession, (String)"10000", (String)"\u8bf7\u6c42\u6620\u5c04\u65b9\u6cd5\u9519\u8bef");
                    String string3 = JSON.toJSONString((Object)response2);
                    return string3;
                }
                beanName = method.substring(0, index);
                methodName = method.substring(index + 1);
            } else {
                ServiceResponse response = ServiceResponse.buildFailure((ServiceSession)contextSession, (String)"10000", (String)"\u672a\u627e\u5230\u8bf7\u6c42\u6620\u5c04\u65b9\u6cd5");
                String response2 = JSON.toJSONString((Object)response);
                return response2;
            }
            String component = String.format("%1$s.%2$s", beanName, methodName);
            LOGGER.debug("\u8bf7\u6c42\u65b9\u6cd5\u4e3a:{}", (Object)component);
            JSONObject paramsObjec = this.rcm.decrypt(contextSession, encrypt, params);
            Object response = this.invoker.invoke(component, paramsObjec);
            String string4 = JSON.toJSONString((Object)Utils.toNormalJSONObject((Object)response));
            return string4;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, (String)"10000", (String)e.getMessage()));
            return string;
        }
        catch (ServiceRuntimeException ex) {
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, (String)ex.getCode(), (String)ex.getMessage()));
            return string;
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, (String)"10000", (String)Utils.getLastExceptionMessage((Exception)ex)));
            return string;
        }
        finally {
            long endTimeMillis = System.currentTimeMillis();
            long elapsed = endTimeMillis - startTimeMillis;
            StatisticUtils.onDecrementMethod((String)method, (Long)elapsed);
            if ("true".equals(SpringContext.getEnvironment().getProperty("aop.trace.enable"))) {
                this.traceMonitor.printTrace();
            }
            TimeZoneUtil.removeCurrentTimeZone();
        }
    }

    public String onRestService(String method, String session, String ent_id, String user_id, String user_name, String locale, String param) {
        return this.onRestService(method, session, ent_id, user_id, user_name, locale, "0", param);
    }

    public String onRestService(String method, String session, String ent_id, String user_id, String user_name, String locale, String encrypt, String param) {
        return this.onRestService(method, session, null, ent_id, user_id, user_name, locale, encrypt, param, "0");
    }

    public String onRestService(String method, String session, String ent_id, String user_id, String user_name, String locale, String encrypt, String param, String debugMode) {
        return this.onRestService(method, session, null, ent_id, user_id, user_name, locale, encrypt, param, debugMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String onRestService(String method, String session, String versionCode, String ent_id, String user_id, String user_name, String locale, String encrypt, String param, String debugMode) {
        long startTimeMillis = System.currentTimeMillis();
        StatisticUtils.onIncrementMethod((String)method, (long)startTimeMillis);
        LOGGER.debug(String.format("---->method=%1$s session=%2$s param=%3$s ent_id=%4$s user_id=%5$s user_name=%6$s locale=%7$s encrypt=%8$s", method + "", session + "", param + "", ent_id + "", user_id + "", user_name + "", locale + "", encrypt + ""));
        try {
            if (StringUtils.isEmpty((Object)session) && !StringUtils.isEmpty((Object)ent_id)) {
                ServiceSession ss = new ServiceSession();
                if (!StringUtils.isEmpty((Object)ent_id)) {
                    ss.setEnt_id(Long.parseLong(ent_id));
                }
                if (!StringUtils.isEmpty((Object)user_id)) {
                    ss.setUser_id(Long.parseLong(user_id));
                }
                ss.setUser_name(user_name);
                ss.setLocale(locale);
                session = JSON.toJSONString((Object)ss);
            }
            SpringContext.getRequest().setAttribute("requestSession", (Object)session);
            Object retdata = this.rcm.executeClassMethod(method, versionCode, session, param, encrypt);
            if (retdata == null) {
                String string = "";
                return string;
            }
            if (retdata instanceof String) {
                String string = (String)retdata;
                return string;
            }
            String string = JSON.toJSONString((Object)Utils.toNormalJSONObject((Object)retdata));
            return string;
        }
        catch (InvocationTargetException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Throwable th = e.getTargetException();
            if (th instanceof IllegalArgumentException) {
                String endTimeMillis = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, (String)"10000", (String)e.getTargetException().getMessage()));
                return endTimeMillis;
            }
            if (th instanceof ServiceRuntimeException) {
                ServiceRuntimeException ex = (ServiceRuntimeException)th;
                String endTimeMillis = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, (String)ex.getCode(), (String)ex.getMessage()));
                return endTimeMillis;
            }
            String ex = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, (String)"10000", (String)Utils.getLastExceptionMessage((Exception)e)));
            return ex;
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            String string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, (String)"10000", (String)Utils.getLastExceptionMessage((Exception)ex)));
            return string;
        }
        finally {
            long endTimeMillis = System.currentTimeMillis();
            long elapsed = endTimeMillis - startTimeMillis;
            StatisticUtils.onDecrementMethod((String)method, (Long)elapsed);
            if ("true".equals(SpringContext.getEnvironment().getProperty("aop.trace.enable"))) {
                this.traceMonitor.printTrace();
            }
        }
    }

    @Scheduled(cron="0 01 01 * * ?")
    public void onRefreshSliceReader() {
        LOGGER.info("onRefreshSliceReader------begin");
        this.sliceBase.init();
        LOGGER.info("onRefreshSliceReader------end");
    }
}

