/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.filter;

import com.product.storage.filter.DataRangeExecutorWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"efuture.auth"}, havingValue="true", matchIfMissing=false)
public class SqlSessionBeanFactoryPostProcessor
implements BeanPostProcessor {
    @Value(value="${mybatisPath:classpath:mybatis-config.xml}")
    private String mybatisPath;
    @Autowired
    @Qualifier(value="stringRedisTemplate")
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${defaultDataRangeExecutorType:1}")
    private String defaultDataRangeExecutorType;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SqlSessionFactoryBean) {
            try {
                long count;
                DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
                Resource resource = resourceLoader.getResource(this.mybatisPath);
                InputStream inputStream = resource.getInputStream();
                XMLConfigBuilder xmlConfigBuilder = new XMLConfigBuilder(inputStream);
                Configuration configuration = xmlConfigBuilder.parse();
                List interceptors = configuration.getInterceptors();
                if (!this.defaultDataRangeExecutorType.equals("1") && (count = interceptors.stream().filter(x -> x instanceof DataRangeExecutorWrapper).count()) == 0L) {
                    Interceptor[] InterceptorArray = new Interceptor[]{new DataRangeExecutorWrapper()};
                    ((SqlSessionFactoryBean)bean).setPlugins(InterceptorArray);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

