/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.filter;

import com.product.storage.filter.user.DataRange;
import com.product.storage.filter.user.UserService;
import com.product.storage.filter.user.UserTokenInfo;
import com.product.util.CacheUtils;
import com.product.util.SpringContext;
import java.util.List;
import org.springframework.util.StringUtils;

public class UserDataRangeSrv {
    private static final ThreadLocal<UserTokenInfo> LOCAL_USERINFO = new ThreadLocal();
    private static final ThreadLocal<List<DataRange>> LOCAL_DataRange = new ThreadLocal();
    private static final ThreadLocal<String> LOCAL_TOKEN = new ThreadLocal();
    private static final ThreadLocal<Boolean> LOCAL_ISRANGE = new ThreadLocal();
    private static boolean OPENRANGE = true;
    private static UserService us;
    private static final String TOKEN_MEMKEY = "ocptoken-";

    public static void setlocaltoken(String token) {
        LOCAL_TOKEN.set(token);
        LOCAL_DataRange.remove();
        LOCAL_USERINFO.remove();
        if (StringUtils.isEmpty((Object)token)) {
            LOCAL_ISRANGE.set(false);
        } else {
            LOCAL_ISRANGE.set(true);
        }
    }

    public static boolean getlocalisrange() {
        if (!OPENRANGE) {
            return OPENRANGE;
        }
        Boolean b = LOCAL_ISRANGE.get();
        if (null == b) {
            return false;
        }
        return b;
    }

    public static void setlocalisrange(boolean isrange) {
        LOCAL_ISRANGE.set(isrange);
    }

    public static String getlocaltoken() {
        return LOCAL_TOKEN.get();
    }

    public static UserTokenInfo getlocaluser() {
        if (!OPENRANGE) {
            return null;
        }
        return UserDataRangeSrv.getuserinfo();
    }

    public static UserTokenInfo getuserinfo() {
        UserTokenInfo info = LOCAL_USERINFO.get();
        if (null == info) {
            String token = UserDataRangeSrv.getlocaltoken();
            if (token.isEmpty()) {
                return null;
            }
            info = UserDataRangeSrv.getuserinfo(token);
            LOCAL_USERINFO.set(info);
        }
        return LOCAL_USERINFO.get();
    }

    public static List<DataRange> getlocaldatarange() {
        if (!OPENRANGE) {
            return null;
        }
        List<DataRange> dr = LOCAL_DataRange.get();
        if (null == dr || dr.size() < 1) {
            UserTokenInfo info = UserDataRangeSrv.getlocaluser();
            if (null == info) {
                return null;
            }
            dr = UserDataRangeSrv.getDataRangeBytoken(info.getToken());
            LOCAL_DataRange.set(dr);
        }
        return dr;
    }

    public static UserTokenInfo getuserinfo(String token) {
        if (!OPENRANGE) {
            return null;
        }
        if (StringUtils.isEmpty((Object)token)) {
            return null;
        }
        String key = TOKEN_MEMKEY + token;
        UserTokenInfo info = (UserTokenInfo)CacheUtils.getCacheUtils().getData(key);
        if (null == info) {
            UserService us = UserDataRangeSrv.getServerSrv();
            info = us.getuserinfo(token);
            if (null == info) {
                return null;
            }
            CacheUtils.getCacheUtils().putData(key, info, 86400);
        }
        return info;
    }

    private static UserService getServerSrv() {
        if (null == us) {
            us = (UserService)SpringContext.getBean((String)"UserServerSrv", UserService.class);
        }
        return us;
    }

    public static List<DataRange> getDataRangeBytoken(String token) {
        if (!OPENRANGE) {
            return null;
        }
        UserTokenInfo info = UserDataRangeSrv.getuserinfo(token);
        if (null == info) {
            return null;
        }
        return info.getDatarange();
    }

    public static boolean isOpenrange() {
        return OPENRANGE;
    }

    public static void setOpenrange(boolean openrange) {
        OPENRANGE = openrange;
    }

    public static void unload() {
        LOCAL_TOKEN.remove();
        LOCAL_ISRANGE.remove();
    }
}

