/*
 * Decompiled with CFR 0.152.
 */
package com.product.timezone;

import com.product.timezone.TimeZoneUtil;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TimeZoneHikariDataSource
extends HikariDataSource {
    private static final Logger log = LoggerFactory.getLogger(TimeZoneHikariDataSource.class);

    public Connection getConnection() throws SQLException {
        Connection connection = super.getConnection();
        String curTimeZone = TimeZoneUtil.getCurrentTimeZone();
        if (!StringUtils.isEmpty((Object)curTimeZone)) {
            String timeZoneOffSet = TimeZoneUtil.getTimeZoneOffSet(curTimeZone);
            log.info("getConnection timezone:{}, timeZoneOffSet:{}", (Object)curTimeZone, (Object)timeZoneOffSet);
            PreparedStatement prst = connection.prepareStatement("SET time_zone=?");
            prst.setString(1, timeZoneOffSet);
            prst.execute();
        }
        return connection;
    }
}

